/*
 * Decompiled with CFR 0.152.
 */
package spim.process.fusion.weightedavg;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import mpicbg.spim.data.sequence.Channel;
import mpicbg.spim.data.sequence.ImgLoader;
import mpicbg.spim.data.sequence.SequenceDescription;
import mpicbg.spim.data.sequence.TimePoint;
import mpicbg.spim.data.sequence.ViewDescription;
import mpicbg.spim.data.sequence.ViewId;
import mpicbg.spim.io.IOFunctions;
import net.imglib2.Cursor;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.RealRandomAccessible;
import net.imglib2.img.Img;
import net.imglib2.interpolation.InterpolatorFactory;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.real.FloatType;
import spim.Threads;
import spim.fiji.spimdata.SpimData2;
import spim.process.fusion.FusionHelper;
import spim.process.fusion.ImagePortion;
import spim.process.fusion.boundingbox.BoundingBoxGUI;
import spim.process.fusion.weightedavg.ProcessFusion;
import spim.process.fusion.weightedavg.ProcessSequentialPortion;
import spim.process.fusion.weightedavg.ProcessSequentialPortionWeight;
import spim.process.fusion.weightedavg.ProcessSequentialPortionWeights;

public class ProcessSequential
extends ProcessFusion {
    final int numSequentialViews;

    public ProcessSequential(SpimData2 spimData, List<ViewId> viewIdsToProcess, BoundingBoxGUI bb, boolean useBlending, boolean useContentBased, int numSequentialViews) {
        super(spimData, viewIdsToProcess, bb, useBlending, useContentBased);
        this.numSequentialViews = numSequentialViews;
    }

    @Override
    public <T extends RealType<T> & NativeType<T>> Img<T> fuseStack(T type, InterpolatorFactory<T, RandomAccessible<T>> interpolatorFactory, TimePoint timepoint, Channel channel) {
        IOFunctions.println("(" + new Date(System.currentTimeMillis()) + "): Reserving memory for fused image.");
        ArrayList<ViewDescription> allInputData = FusionHelper.assembleInputData(this.spimData, timepoint, channel, this.viewIdsToProcess);
        if (allInputData.size() == 0) {
            return null;
        }
        Img fusedImg = this.bb.getImgFactory(type).create(this.bb.getDimensions(), type);
        if (fusedImg == null) {
            IOFunctions.println("(" + new Date(System.currentTimeMillis()) + "): WeightedAverageFusion: Cannot create output image.");
            return null;
        }
        Img weightImg = this.bb.getImgFactory(new FloatType()).create(this.bb.getDimensions(), (Object)new FloatType());
        if (weightImg == null) {
            IOFunctions.println("(" + new Date(System.currentTimeMillis()) + "): WeightedAverageFusion: Cannot create weight image.");
            return null;
        }
        for (int batch = 0; batch < this.numBatches(allInputData.size(), this.numSequentialViews); ++batch) {
            int start = batch * this.numSequentialViews;
            int end = Math.min((batch + 1) * this.numSequentialViews, allInputData.size());
            IOFunctions.println("(" + new Date(System.currentTimeMillis()) + "): Fusing view " + start + " ... " + (end - 1) + " of " + (allInputData.size() - 1));
            ArrayList<ViewDescription> inputData = new ArrayList<ViewDescription>();
            for (int i = start; i < end; ++i) {
                inputData.add(allInputData.get(i));
            }
            ArrayList imgs = new ArrayList();
            for (int i = 0; i < inputData.size(); ++i) {
                ViewDescription vd = (ViewDescription)inputData.get(i);
                IOFunctions.println("(" + new Date(System.currentTimeMillis()) + "): Requesting Img from ImgLoader (tp=" + vd.getTimePointId() + ", setup=" + vd.getViewSetupId() + ")");
                imgs.add(ProcessSequential.getImage(type, this.spimData, (ViewId)vd, false));
            }
            ArrayList<ArrayList<RealRandomAccessible<FloatType>>> weights = new ArrayList<ArrayList<RealRandomAccessible<FloatType>>>();
            for (int i = 0; i < inputData.size(); ++i) {
                weights.add(this.getAllWeights((RandomAccessibleInterval)imgs.get(i), (ViewDescription)inputData.get(i), (ImgLoader)((SequenceDescription)this.spimData.getSequenceDescription()).getImgLoader()));
            }
            Vector<ImagePortion> portions = FusionHelper.divideIntoPortions(fusedImg.size(), Threads.numThreads() * 4);
            ExecutorService taskExecutor = Executors.newFixedThreadPool(Threads.numThreads());
            ArrayList tasks = new ArrayList();
            if (((ArrayList)weights.get(0)).size() == 0) {
                for (ImagePortion portion : portions) {
                    tasks.add(new ProcessSequentialPortion(portion, imgs, interpolatorFactory, this.getTransforms(inputData), fusedImg, (Img<FloatType>)weightImg, this.bb));
                }
            } else if (((ArrayList)weights.get(0)).size() > 1) {
                for (ImagePortion portion : portions) {
                    tasks.add(new ProcessSequentialPortionWeights(portion, imgs, weights, interpolatorFactory, this.getTransforms(inputData), fusedImg, (Img<FloatType>)weightImg, this.bb));
                }
            } else {
                ArrayList<RealRandomAccessible<FloatType>> singleWeight = new ArrayList<RealRandomAccessible<FloatType>>();
                for (int i = 0; i < inputData.size(); ++i) {
                    singleWeight.add((RealRandomAccessible<FloatType>)((ArrayList)weights.get(i)).get(0));
                }
                for (ImagePortion portion : portions) {
                    tasks.add(new ProcessSequentialPortionWeight(portion, imgs, singleWeight, interpolatorFactory, this.getTransforms(inputData), fusedImg, (Img<FloatType>)weightImg, this.bb));
                }
            }
            IOFunctions.println("(" + new Date(System.currentTimeMillis()) + "): Starting fusion process.");
            try {
                taskExecutor.invokeAll(tasks);
            }
            catch (InterruptedException e) {
                IOFunctions.println("(" + new Date(System.currentTimeMillis()) + "): Failed to compute fusion: " + e);
                e.printStackTrace();
                return null;
            }
            taskExecutor.shutdown();
        }
        this.mergeFinalImage(fusedImg, (Img<FloatType>)weightImg);
        return fusedImg;
    }

    protected <T extends RealType<T>> void mergeFinalImage(final Img<T> img, final Img<FloatType> weights) {
        Vector<ImagePortion> portions = FusionHelper.divideIntoPortions(img.size(), Threads.numThreads() * 4);
        ExecutorService taskExecutor = Executors.newFixedThreadPool(Threads.numThreads());
        ArrayList<1> tasks = new ArrayList<1>();
        for (final ImagePortion portion : portions) {
            tasks.add(new Callable<String>(){

                @Override
                public String call() throws Exception {
                    Cursor cursor = img.cursor();
                    Cursor cursorW = weights.cursor();
                    cursor.jumpFwd(portion.getStartPosition());
                    cursorW.jumpFwd(portion.getStartPosition());
                    int j = 0;
                    while ((long)j < portion.getLoopSize()) {
                        float w = ((FloatType)cursorW.next()).get();
                        RealType type = (RealType)cursor.next();
                        if (w > 0.0f) {
                            type.setReal(type.getRealFloat() / w);
                        }
                        ++j;
                    }
                    return "";
                }
            });
        }
        try {
            taskExecutor.invokeAll(tasks);
        }
        catch (InterruptedException e) {
            IOFunctions.println("Failed to merge final image: " + e);
            e.printStackTrace();
            return;
        }
        taskExecutor.shutdown();
    }

    protected int numBatches(int numViews, int sequentialViews) {
        return numViews / sequentialViews + Math.min(numViews % sequentialViews, 1);
    }
}

