/*
 * Decompiled with CFR 0.152.
 */
package spim.process.interestpointregistration;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import mpicbg.models.AbstractAffineModel3D;
import mpicbg.models.Affine3D;
import mpicbg.models.AffineModel3D;
import mpicbg.models.IllDefinedDataPointsException;
import mpicbg.models.Model;
import mpicbg.models.NotEnoughDataPointsException;
import mpicbg.models.PointMatch;
import mpicbg.models.RigidModel3D;
import mpicbg.models.Tile;
import mpicbg.models.TileConfiguration;
import mpicbg.spim.data.sequence.ViewId;
import mpicbg.spim.io.IOFunctions;
import mpicbg.spim.mpicbg.PointMatchGeneric;
import spim.process.interestpointregistration.Detection;
import spim.process.interestpointregistration.PairwiseMatch;
import spim.process.interestpointregistration.optimizationtypes.GlobalOptimizationSubset;
import spim.process.interestpointregistration.optimizationtypes.GlobalOptimizationType;
import spim.vecmath.Matrix4f;
import spim.vecmath.Quat4f;
import spim.vecmath.Transform3D;
import spim.vecmath.Vector3d;
import spim.vecmath.Vector3f;

public class GlobalOpt {
    public static <M extends Model<M>> HashMap<ViewId, Tile<M>> compute(M model, GlobalOptimizationType registrationType, GlobalOptimizationSubset subset, boolean considerTimePointsAsUnit) {
        List<PairwiseMatch> pairs = subset.getViewPairs();
        List<ViewId> views = subset.getViews();
        HashMap<ViewId, Tile<M>> map = GlobalOpt.assignViewsToTiles(model, views, considerTimePointsAsUnit);
        for (PairwiseMatch pair : pairs) {
            GlobalOpt.addPointMatches(pair.getInliers(), map.get(pair.getViewIdA()), map.get(pair.getViewIdB()));
        }
        TileConfiguration tc = GlobalOpt.addAndFixTiles(views, map, registrationType, subset, considerTimePointsAsUnit);
        if (tc.getTiles().size() == 0) {
            IOFunctions.println("There are no connected tiles, cannot do an optimization. Quitting.");
            return null;
        }
        try {
            int unaligned = tc.preAlign().size();
            if (unaligned > 0) {
                IOFunctions.println("(" + new Date(System.currentTimeMillis()) + "): pre-aligned all tiles but " + unaligned);
            } else {
                IOFunctions.println("(" + new Date(System.currentTimeMillis()) + "): prealigned all tiles");
            }
            tc.optimize(10.0, 10000, 200);
            if (considerTimePointsAsUnit) {
                IOFunctions.println("(" + new Date(System.currentTimeMillis()) + "): Global optimization of " + tc.getTiles().size() + " timepoint-tiles (Model=" + model.getClass().getSimpleName() + "):");
            } else {
                IOFunctions.println("(" + new Date(System.currentTimeMillis()) + "): Global optimization of " + tc.getTiles().size() + " view-tiles (Model=" + model.getClass().getSimpleName() + "):");
            }
            IOFunctions.println("(" + new Date(System.currentTimeMillis()) + "):    Avg Error: " + tc.getError() + "px");
            IOFunctions.println("(" + new Date(System.currentTimeMillis()) + "):    Min Error: " + tc.getMinError() + "px");
            IOFunctions.println("(" + new Date(System.currentTimeMillis()) + "):    Max Error: " + tc.getMaxError() + "px");
        }
        catch (NotEnoughDataPointsException e) {
            IOFunctions.println("Global optimization failed: " + (Object)((Object)e));
            e.printStackTrace();
        }
        catch (IllDefinedDataPointsException e) {
            IOFunctions.println("Global optimization failed: " + (Object)((Object)e));
            e.printStackTrace();
        }
        IOFunctions.println("(" + new Date(System.currentTimeMillis()) + "): Transformation Models:");
        for (ViewId viewId : views) {
            Tile<M> tile = map.get(viewId);
            String output = "ViewId=" + viewId.getViewSetupId() + ": " + GlobalOpt.printAffine3D((Affine3D)tile.getModel());
            if (tile.getModel() instanceof RigidModel3D) {
                String rotA = "Java3D is MISSING!";
                try {
                    rotA = GlobalOpt.getRotationAxis((RigidModel3D)tile.getModel());
                }
                catch (NoClassDefFoundError noClassDefFoundError) {
                    // empty catch block
                }
                IOFunctions.println(output + ", Rotation Axis=" + rotA);
                continue;
            }
            String scaling = "Java3D is MISSING!";
            try {
                scaling = GlobalOpt.getScaling((Affine3D)tile.getModel());
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                // empty catch block
            }
            IOFunctions.println(output + ", Scaling=" + scaling);
        }
        return map;
    }

    public static String getRotationAxis(RigidModel3D model) {
        try {
            Matrix4f matrix = new Matrix4f();
            GlobalOpt.getTransform3D(model).get(matrix);
            Quat4f qu = new Quat4f();
            qu.set(matrix);
            Vector3f n = new Vector3f(qu.getX(), qu.getY(), qu.getZ());
            n.normalize();
            return "Approx. axis: " + n + ", approx. angle: " + Math.toDegrees(Math.acos(qu.getW()) * 2.0);
        }
        catch (Exception e) {
            return "Check if Apple's out-dated Java 3D version 1.3 is installed in System/Library/Java/Extensions/ on your Mac.Remove all Java 3D 1.3 related files including vecmath.jar (jar, jnilib), they are useless.";
        }
    }

    public static String getScaling(Affine3D<?> affine) {
        Transform3D t = GlobalOpt.getTransform3D(affine);
        Vector3d v = new Vector3d();
        t.getScale(v);
        return "Scaling: " + v.x + ", " + v.y + ", " + v.z;
    }

    public static Transform3D getTransform3D(Affine3D<?> affine) {
        double[][] m = new double[3][4];
        affine.toMatrix(m);
        Transform3D transform = new Transform3D();
        double[] m2 = new double[16];
        transform.get(m2);
        m2[0] = m[0][0];
        m2[1] = m[0][1];
        m2[2] = m[0][2];
        m2[3] = m[0][3];
        m2[4] = m[1][0];
        m2[5] = m[1][1];
        m2[6] = m[1][2];
        m2[7] = m[1][3];
        m2[8] = m[2][0];
        m2[9] = m[2][1];
        m2[10] = m[2][2];
        m2[11] = m[2][3];
        transform.set(m2);
        return transform;
    }

    public static <M extends AbstractAffineModel3D<M>> Transform3D getTransform3D(M model) {
        Transform3D transform = new Transform3D();
        double[] m = model.getMatrix(null);
        double[] m2 = new double[16];
        transform.get(m2);
        for (int i = 0; i < m.length; ++i) {
            m2[i] = m[i];
        }
        transform.set(m2);
        return transform;
    }

    public static String printAffine3D(Affine3D<?> model) {
        double[][] m = new double[3][4];
        model.toMatrix(m);
        return m[0][0] + "," + m[0][1] + "," + m[0][2] + "," + m[0][3] + "," + m[1][0] + "," + m[1][1] + "," + m[1][2] + "," + m[1][3] + "," + m[2][0] + "," + m[2][1] + "," + m[2][2] + "," + m[2][3];
    }

    protected static <M extends Model<M>> TileConfiguration addAndFixTiles(List<ViewId> views, HashMap<ViewId, Tile<M>> map, GlobalOptimizationType registrationType, GlobalOptimizationSubset subset, boolean considerTimePointsAsUnit) {
        TileConfiguration tc = new TileConfiguration();
        HashSet<Tile<M>> tiles = new HashSet<Tile<M>>();
        for (ViewId viewId : views) {
            Tile<M> tile = map.get(viewId);
            if (registrationType.isFixedTile(viewId) && !tc.getFixedTiles().contains(tile)) {
                if (considerTimePointsAsUnit) {
                    IOFunctions.println("(" + new Date(System.currentTimeMillis()) + "): Fixing timepoint-tile (timepointId = " + viewId.getTimePointId() + ")");
                } else {
                    IOFunctions.println("(" + new Date(System.currentTimeMillis()) + "): Fixing view-tile (viewSetupId = " + viewId.getViewSetupId() + ")");
                }
                tc.fixTile(tile);
            }
            tiles.add(tile);
        }
        for (Tile tile : tiles) {
            if (tile.getConnectedTiles().size() <= 0) continue;
            tc.addTile(tile);
        }
        return tc;
    }

    protected static <M extends Model<M>> HashMap<ViewId, Tile<M>> assignViewsToTiles(M model, List<ViewId> views, boolean considerTimePointsAsUnit) {
        HashMap<ViewId, Tile<M>> map = new HashMap<ViewId, Tile<M>>();
        if (considerTimePointsAsUnit) {
            HashSet<Integer> timepoints = new HashSet<Integer>();
            for (ViewId view : views) {
                timepoints.add(view.getTimePointId());
            }
            Iterator<Object> iterator = timepoints.iterator();
            while (iterator.hasNext()) {
                int t = (Integer)iterator.next();
                Tile tileTimepoint = new Tile(model.copy());
                for (ViewId viewId : views) {
                    if (viewId.getTimePointId() != t) continue;
                    map.put(viewId, tileTimepoint);
                }
            }
        } else {
            for (ViewId viewId : views) {
                map.put(viewId, new Tile(model.copy()));
            }
        }
        return map;
    }

    protected static void addPointMatches(ArrayList<PointMatchGeneric<Detection>> correspondences, Tile<?> tileA, Tile<?> tileB) {
        ArrayList<PointMatchGeneric<Detection>> pm = new ArrayList<PointMatchGeneric<Detection>>();
        pm.addAll(correspondences);
        if (correspondences.size() > 0) {
            tileA.addMatches(pm);
            tileB.addMatches(PointMatch.flip(pm));
            tileA.addConnectedTile(tileB);
            tileB.addConnectedTile(tileA);
        }
    }

    public static void main(String[] args) {
        HashMap<ViewId, Tile> map = new HashMap<ViewId, Tile>();
        AffineModel3D m1 = new AffineModel3D();
        AffineModel3D m2 = new AffineModel3D();
        Tile tile1 = new Tile((Model)m1);
        Tile tile2 = new Tile((Model)m2);
        ViewId v11 = new ViewId(1, 1);
        ViewId v21 = new ViewId(2, 1);
        ViewId v12 = new ViewId(1, 2);
        ViewId v22 = new ViewId(2, 2);
        map.put(v11, tile1);
        map.put(v21, tile2);
        map.put(v12, tile1);
        map.put(v22, tile2);
        m1.set(1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0);
        m2.set(2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0);
        System.out.println(((Tile)map.get(v11)).getModel());
        System.out.println(((Tile)map.get(v21)).getModel());
        System.out.println(((Tile)map.get(v12)).getModel());
        System.out.println(((Tile)map.get(v22)).getModel());
    }
}

