/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.morphology.thin;

import java.util.HashMap;
import net.imagej.ops.morphology.thin.ThinningStrategy;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessible;
import net.imglib2.type.logic.BitType;

public abstract class Abstract3x3NeighbourhoodThinning
implements ThinningStrategy {
    protected boolean m_foreground;
    protected boolean m_background;
    private HashMap<RandomAccessible, RandomAccess> accesses = new HashMap();

    protected Abstract3x3NeighbourhoodThinning() {
        this.m_foreground = true;
        this.m_background = false;
    }

    protected Abstract3x3NeighbourhoodThinning(boolean foreground) {
        this.m_foreground = foreground;
        this.m_background = !foreground;
    }

    protected boolean[] getNeighbourhood(RandomAccess<BitType> access) {
        boolean[] vals = new boolean[9];
        vals[0] = ((BitType)access.get()).get();
        access.move(-1, 1);
        vals[1] = ((BitType)access.get()).get();
        access.move(1, 0);
        vals[2] = ((BitType)access.get()).get();
        access.move(1, 1);
        vals[3] = ((BitType)access.get()).get();
        access.move(1, 1);
        vals[4] = ((BitType)access.get()).get();
        access.move(-1, 0);
        vals[5] = ((BitType)access.get()).get();
        access.move(-1, 0);
        vals[6] = ((BitType)access.get()).get();
        access.move(-1, 1);
        vals[7] = ((BitType)access.get()).get();
        access.move(-1, 1);
        vals[8] = ((BitType)access.get()).get();
        return vals;
    }

    protected int findPatternSwitches(boolean[] vals) {
        int res = 0;
        for (int i = 1; i < vals.length - 1; ++i) {
            if (vals[i] == this.m_foreground && vals[i + 1] == this.m_background) {
                ++res;
            }
            if (vals[vals.length - 1] != this.m_foreground || vals[1] != this.m_background) continue;
            ++res;
        }
        return res;
    }

    @Override
    public void afterCycle() {
    }

    @Override
    public int getIterationsPerCycle() {
        return 1;
    }

    protected <T> RandomAccess<T> randomAccess(RandomAccessible<T> ra) {
        return this.accesses.computeIfAbsent(ra, r -> r.randomAccess());
    }
}

