/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d;

import java.util.ArrayList;
import java.util.Vector;
import org.jogamp.java3d.InputDevice;
import org.jogamp.java3d.InputDeviceBlockingThread;
import org.jogamp.java3d.J3dThread;
import org.jogamp.java3d.J3dThreadData;
import org.jogamp.java3d.PhysicalEnvironment;
import org.jogamp.java3d.VirtualUniverse;

class InputDeviceScheduler
extends J3dThread {
    ArrayList nonBlockingDevices = new ArrayList(1);
    ArrayList blockingDevices = new ArrayList(1);
    ArrayList threads = new ArrayList(1);
    PhysicalEnvironment physicalEnv;
    J3dThreadData threadData = new J3dThreadData();
    boolean active = false;
    static int samplingTime = 5;
    private static int numInstances = 0;
    private int instanceNum = -1;

    private synchronized int newInstanceNum() {
        return ++numInstances;
    }

    @Override
    int getInstanceNum() {
        if (this.instanceNum == -1) {
            this.instanceNum = this.newInstanceNum();
        }
        return this.instanceNum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    InputDeviceScheduler(ThreadGroup threadGroup, PhysicalEnvironment physicalEnv) {
        super(threadGroup);
        this.setName("J3D-InputDeviceScheduler-" + this.getInstanceNum());
        this.threadData.threadType = 4;
        this.threadData.thread = this;
        this.physicalEnv = physicalEnv;
        Vector<InputDevice> vector = physicalEnv.devices;
        synchronized (vector) {
            for (InputDevice each : physicalEnv.devices) {
                this.addInputDevice(each);
            }
            physicalEnv.inputsched = this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addInputDevice(InputDevice device) {
        switch (device.getProcessingMode()) {
            case 3: {
                InputDeviceBlockingThread thread = VirtualUniverse.mc.getInputDeviceBlockingThread(device);
                thread.start();
                ArrayList arrayList = this.blockingDevices;
                synchronized (arrayList) {
                    this.threads.add(thread);
                    this.blockingDevices.add(device);
                    break;
                }
            }
            case 4: {
                ArrayList arrayList = this.nonBlockingDevices;
                synchronized (arrayList) {
                    this.nonBlockingDevices.add(device);
                    if (this.active && this.nonBlockingDevices.size() == 1) {
                        VirtualUniverse.mc.addInputDeviceScheduler(this);
                    }
                    break;
                }
            }
            default: {
                for (int i = device.getSensorCount() - 1; i >= 0; --i) {
                    device.getSensor((int)i).demand_driven = true;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeInputDevice(InputDevice device) {
        switch (device.getProcessingMode()) {
            case 3: {
                ArrayList arrayList = this.blockingDevices;
                synchronized (arrayList) {
                    int idx = this.blockingDevices.indexOf(device);
                    InputDeviceBlockingThread thread = (InputDeviceBlockingThread)this.threads.remove(idx);
                    thread.finish();
                    this.blockingDevices.remove(idx);
                    break;
                }
            }
            case 4: {
                ArrayList arrayList = this.nonBlockingDevices;
                synchronized (arrayList) {
                    this.nonBlockingDevices.remove(this.nonBlockingDevices.indexOf(device));
                    if (this.active && this.nonBlockingDevices.size() == 0) {
                        VirtualUniverse.mc.removeInputDeviceScheduler(this);
                    }
                    break;
                }
            }
            default: {
                for (int i = device.getSensorCount() - 1; i >= 0; --i) {
                    device.getSensor((int)i).demand_driven = false;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void activate() {
        if (!this.active) {
            this.active = true;
            ArrayList arrayList = this.nonBlockingDevices;
            synchronized (arrayList) {
                if (this.nonBlockingDevices.size() > 0) {
                    VirtualUniverse.mc.addInputDeviceScheduler(this);
                }
            }
            arrayList = this.blockingDevices;
            synchronized (arrayList) {
                for (int i = this.threads.size() - 1; i >= 0; --i) {
                    ((InputDeviceBlockingThread)this.threads.get(i)).restart();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deactivate() {
        if (this.active) {
            ArrayList arrayList = this.nonBlockingDevices;
            synchronized (arrayList) {
                if (this.nonBlockingDevices.size() > 0) {
                    VirtualUniverse.mc.removeInputDeviceScheduler(this);
                }
            }
            arrayList = this.blockingDevices;
            synchronized (arrayList) {
                for (int i = this.threads.size() - 1; i >= 0; --i) {
                    ((InputDeviceBlockingThread)this.threads.get(i)).sleep();
                }
            }
            this.active = false;
        }
    }

    J3dThreadData getThreadData() {
        return this.threadData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void doWork(long referenceTime) {
        ArrayList arrayList = this.nonBlockingDevices;
        synchronized (arrayList) {
            for (int i = this.nonBlockingDevices.size() - 1; i >= 0; --i) {
                ((InputDevice)this.nonBlockingDevices.get(i)).pollAndProcessInput();
            }
        }
    }

    @Override
    void shutdown() {
        for (int i = this.threads.size() - 1; i >= 0; --i) {
            ((InputDeviceBlockingThread)this.threads.get(i)).finish();
        }
        this.threads.clear();
        this.blockingDevices.clear();
        this.nonBlockingDevices.clear();
    }
}

