/*
 * Decompiled with CFR 0.152.
 */
package org.siox.example;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.siox.util.Utils;

public class ImagePane
extends JComponent {
    public static final String RECTANGLE_SELECTION = "Rectangle";
    public static final String ELLIPSE_SELECTION = "Ellipse";
    public static final String LASSO_SELECTION = "Lasso";
    private final BufferedImage origImage;
    private final BufferedImage currImage;
    private final int iWidth;
    private final int iHeight;
    private final int[] tmpBuffer;
    private Shape selection = null;
    private Point2D selectionAnchor = new Point2D.Float(0.0f, 0.0f);
    private boolean unsavedChanges = false;
    private int zoomFactor = 1;
    private boolean zoomIn = true;
    private Icon bgTileIcon = null;
    private Icon topIcon;
    private Icon leftIcon;

    public ImagePane(BufferedImage image) {
        this.currImage = image;
        this.iWidth = this.currImage.getWidth();
        this.iHeight = this.currImage.getHeight();
        this.tmpBuffer = new int[this.iWidth * this.iHeight];
        this.origImage = new BufferedImage(this.iWidth, this.iHeight, 2);
        this.origImage.getGraphics().drawImage(this.currImage, 0, 0, null);
        this.setZoom(1, true);
    }

    public int getInnerXMargin() {
        double scale = this.zoomIn ? (double)this.zoomFactor : 1.0 / (double)this.zoomFactor;
        return Math.max(0, (int)(((double)this.getWidth() - (double)this.iWidth * scale) / 2.0 + 0.5));
    }

    public int getInnerYMargin() {
        double scale = this.zoomIn ? (double)this.zoomFactor : 1.0 / (double)this.zoomFactor;
        return Math.max(0, (int)(((double)this.getHeight() - (double)this.iHeight * scale) / 2.0 + 0.5));
    }

    protected void setTopIcon(Icon topIcon) {
        this.topIcon = topIcon;
    }

    protected void setLeftIcon(Icon leftIcon) {
        this.leftIcon = leftIcon;
    }

    @Override
    public void paintComponent(Graphics graphics) {
        Shape clip;
        Icon icon;
        Graphics2D g = (Graphics2D)graphics.create();
        int offX = this.getInnerXMargin();
        int offY = this.getInnerYMargin();
        if (offX > 0 && (icon = this.leftIcon) != null && offX >= icon.getIconWidth()) {
            icon.paintIcon(this, g, offX - icon.getIconWidth(), 0);
        }
        if (offY > 0 && (icon = this.topIcon) != null && offY >= icon.getIconHeight()) {
            icon.paintIcon(this, g, 0, offY - icon.getIconHeight());
        }
        g.translate(offX, offY);
        if (this.zoomFactor != 1) {
            double scale = this.zoomIn ? (double)this.zoomFactor : 1.0 / (double)this.zoomFactor;
            g.transform(AffineTransform.getScaleInstance(scale, scale));
        }
        if ((clip = g.getClip()) != null) {
            Rectangle2D.Double r = new Rectangle2D.Double(0.0, 0.0, this.iWidth - 1, this.iHeight - 1);
            Rectangle2D.intersect(clip.getBounds2D(), r, r);
            g.setClip(r);
        } else {
            g.setClip(0, 0, this.iWidth - 1, this.iHeight - 1);
        }
        Icon icon2 = this.bgTileIcon;
        if (icon2 != null) {
            int iconWidth = icon2.getIconWidth();
            int iconHeight = icon2.getIconHeight();
            for (int x = 0; x < this.iWidth; x += iconWidth) {
                for (int y = 0; y < this.iHeight; y += iconHeight) {
                    icon2.paintIcon(this, g, x, y);
                }
            }
        }
        g.drawImage((Image)this.currImage, 0, 0, null);
        Shape shape = this.selection;
        if (shape != null) {
            Point2D p;
            g.setColor(Color.white);
            g.setXORMode(Color.black);
            g.draw(shape);
            if (shape instanceof GeneralPath && !this.selectionAnchor.equals(p = ((GeneralPath)shape).getCurrentPoint())) {
                float[] dash = new float[]{3.0f, 5.0f};
                g.setStroke(new BasicStroke(1.0f, 2, 0, 10.0f, dash, 0.0f));
                g.drawLine((int)this.selectionAnchor.getX(), (int)this.selectionAnchor.getY(), (int)p.getX(), (int)p.getY());
            }
        }
        g.dispose();
    }

    public boolean selectTo(int x, int y) {
        Shape shape = this.selection;
        if (shape == null) {
            return false;
        }
        if (shape instanceof GeneralPath) {
            ((GeneralPath)shape).lineTo(x, y);
        } else {
            ((RectangularShape)shape).setFrameFromDiagonal(this.selectionAnchor.getX(), this.selectionAnchor.getY(), x, y);
        }
        this.repaint();
        return true;
    }

    public void startSelection(int x, int y, String selectionMode) {
        this.selectionAnchor.setLocation(x, y);
        if (RECTANGLE_SELECTION.equals(selectionMode)) {
            this.selection = new Rectangle2D.Float(x, y, 0.0f, 0.0f);
        } else if (ELLIPSE_SELECTION.equals(selectionMode)) {
            this.selection = new Ellipse2D.Float(x, y, 0.0f, 0.0f);
        } else if (LASSO_SELECTION.equals(selectionMode)) {
            GeneralPath gp = new GeneralPath();
            gp.moveTo(x, y);
            this.selection = gp;
        } else {
            throw new IllegalArgumentException("unknown selection mode: " + selectionMode);
        }
    }

    public void clearSelection() {
        this.selection = null;
        this.repaint();
    }

    public Area getSelectionArea() {
        Shape shape = this.selection;
        return shape == null ? null : new Area(shape);
    }

    public void setBackgroundTile(Icon tileIcon) {
        this.bgTileIcon = tileIcon;
        this.repaint();
    }

    public void setZoom(int factor, boolean zoomIn) {
        if (this.zoomFactor < 1) {
            throw new IllegalArgumentException("nonpositive zoom factor: " + this.zoomFactor);
        }
        this.zoomFactor = factor;
        this.zoomIn = zoomIn;
        int w = zoomIn ? this.iWidth * this.zoomFactor : Math.max(1, (this.iWidth + this.iWidth - 1) / this.zoomFactor);
        int h = zoomIn ? this.iHeight * this.zoomFactor : Math.max(1, (this.iHeight + this.iHeight - 1) / this.zoomFactor);
        Dimension size = new Dimension(Math.max(this.iWidth, w), Math.max(this.iHeight, h));
        this.setPreferredSize(size);
        this.setMinimumSize(size);
        this.setMaximumSize(size);
        this.setSize(size);
    }

    public Icon getBackgroundTile() {
        return this.bgTileIcon;
    }

    public double getZoomScale() {
        return this.zoomIn ? (double)this.zoomFactor : 1.0 / (double)this.zoomFactor;
    }

    public int getImageWidth() {
        return this.iWidth;
    }

    public int getImageHeight() {
        return this.iHeight;
    }

    public int zoomX(int x) {
        double scale = this.zoomIn ? (double)this.zoomFactor : 1.0 / (double)this.zoomFactor;
        int off = (int)(((double)this.getWidth() - (double)this.iWidth * scale) / 2.0 + 0.5);
        return off + (this.zoomIn ? x * this.zoomFactor : (x + this.zoomFactor - 1) / this.zoomFactor);
    }

    public int zoomY(int y) {
        double scale = this.zoomIn ? (double)this.zoomFactor : 1.0 / (double)this.zoomFactor;
        int off = (int)(((double)this.getHeight() - (double)this.iHeight * scale) / 2.0 + 0.5);
        return off + (this.zoomIn ? y * this.zoomFactor : (y + this.zoomFactor - 1) / this.zoomFactor);
    }

    public int unzoomX(int x) {
        double scale = this.zoomIn ? (double)this.zoomFactor : 1.0 / (double)this.zoomFactor;
        int imageX = !this.zoomIn ? x * this.zoomFactor + (this.zoomFactor - 1) / 2 : (x -= (int)(((double)this.getWidth() - (double)this.iWidth * scale) / 2.0 + 0.5)) / this.zoomFactor;
        return Math.max(0, Math.min(imageX, this.iWidth - 1));
    }

    public int unzoomY(int y) {
        double scale = this.zoomIn ? (double)this.zoomFactor : 1.0 / (double)this.zoomFactor;
        int imageY = !this.zoomIn ? y * this.zoomFactor + (this.zoomFactor - 1) / 2 : (y -= (int)(((double)this.getHeight() - (double)this.iHeight * scale) / 2.0 + 0.5)) / this.zoomFactor;
        return Math.max(0, Math.min(imageY, this.iHeight - 1));
    }

    public void resetPane() {
        this.selection = null;
        Arrays.fill(this.tmpBuffer, 0);
        this.currImage.setRGB(0, 0, this.iWidth, this.iHeight, this.tmpBuffer, 0, this.iWidth);
        this.currImage.getGraphics().drawImage(this.origImage, 0, 0, null);
        this.unsavedChanges = false;
        this.repaint();
    }

    public boolean hasUnsavedChanges() {
        return this.unsavedChanges;
    }

    public void updateImage(int[] imgData, float[] cm) {
        for (int k = 0; k < imgData.length; ++k) {
            this.tmpBuffer[k] = Utils.setAlpha(cm[k], imgData[k]);
        }
        this.currImage.setRGB(0, 0, this.iWidth, this.iHeight, this.tmpBuffer, 0, this.iWidth);
        this.unsavedChanges = true;
        this.repaint();
    }

    public void storeCurrentImage(File outputFile) throws IOException {
        ImageIO.write((RenderedImage)this.currImage, "PNG", outputFile);
        this.unsavedChanges = false;
    }
}

