/*
 * Decompiled with CFR 0.152.
 */
package siox;

import ij.ImagePlus;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;

public class ControlJPanel
extends JPanel {
    private static final long serialVersionUID = -1037100741242680537L;
    final JPanel segJPanel = new JPanel(new GridBagLayout());
    final JPanel drbJPanel = new JPanel(new GridBagLayout());
    final JPanel resetJPanel = new JPanel(new GridBagLayout());
    final JLabel fgOrBgJLabel = new JLabel("Add Known ");
    final JButton segmentJButton = new JButton("Segment");
    final JRadioButton fgJRadioButton = new JRadioButton("Foreground");
    final JRadioButton bgJRadioButton = new JRadioButton("Background");
    final JSlider smoothness = new JSlider(0, 10, 6);
    final JCheckBox multipart = new JCheckBox("Allow multiple foreground components", false);
    final JLabel smoothJLabel = new JLabel("Smoothing:");
    final JRadioButton addJRadioButton = new JRadioButton("add");
    final JRadioButton subJRadioButton = new JRadioButton("subtract");
    final JButton refineJButton = new JButton("Refine");
    final JSlider addThreshold = new JSlider(0, 100, 100);
    final JSlider subThreshold = new JSlider(0, 100, 0);
    final JButton resetJButton = new JButton("Reset");
    final JButton createMaskJButton = new JButton("Create mask");
    final JButton saveSegmentatorJButton = new JButton("Save segmentator");
    static final int FG_ADDED_STATUS = 5;
    static final int SEGMENTED_STATUS = 6;
    int status = 5;

    public ControlJPanel(ImagePlus imp) {
        super(new BorderLayout());
        JPanel controlsBox = new JPanel(new GridBagLayout());
        this.segJPanel.setBorder(BorderFactory.createTitledBorder("1. Initial Segmentation"));
        this.drbJPanel.setBorder(BorderFactory.createTitledBorder("2. Detail Refinement Brush"));
        ButtonGroup fgOrBgButtonGroup = new ButtonGroup();
        fgOrBgButtonGroup.add(this.fgJRadioButton);
        fgOrBgButtonGroup.add(this.bgJRadioButton);
        this.fgJRadioButton.setSelected(true);
        String fgOrBgTooltip = "Add Selection as Known Foreground/Background.";
        this.fgOrBgJLabel.setToolTipText("Add Selection as Known Foreground/Background.");
        this.fgJRadioButton.setToolTipText("Add Selection as Known Foreground/Background.");
        this.bgJRadioButton.setToolTipText("Add Selection as Known Foreground/Background.");
        this.segJPanel.add((Component)this.fgOrBgJLabel, ControlJPanel.getGbc(0, 0, 1, false, false));
        this.segJPanel.add((Component)this.fgJRadioButton, ControlJPanel.getGbc(1, 0, 1, false, false));
        this.segJPanel.add((Component)this.bgJRadioButton, ControlJPanel.getGbc(2, 0, 1, false, false));
        this.multipart.setToolTipText("Use All Foreground Components of at Least a Fourth of the Biggest Connected Component.");
        this.smoothness.setToolTipText("Number of Smoothing Cycles in Postprocessing.");
        this.smoothness.setPaintTicks(true);
        this.smoothness.setMinorTickSpacing(1);
        this.smoothness.putClientProperty("JSlider.isFilled", Boolean.TRUE);
        this.segJPanel.add((Component)this.multipart, ControlJPanel.getGbc(0, 1, 3, false, true));
        this.segJPanel.add((Component)this.smoothJLabel, ControlJPanel.getGbc(0, 2, 3, false, true));
        this.segJPanel.add((Component)this.smoothness, ControlJPanel.getGbc(1, 2, 2, false, true));
        GridBagConstraints segGc = ControlJPanel.getGbc(0, 3, 3, false, false);
        segGc.anchor = 10;
        this.segJPanel.add((Component)this.segmentJButton, segGc);
        ButtonGroup drbButtonGroup = new ButtonGroup();
        drbButtonGroup.add(this.addJRadioButton);
        drbButtonGroup.add(this.subJRadioButton);
        ActionListener drbModeListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ControlJPanel.this.addThreshold.setEnabled(ControlJPanel.this.addJRadioButton.isSelected());
                ControlJPanel.this.subThreshold.setEnabled(ControlJPanel.this.subJRadioButton.isSelected());
            }
        };
        this.addJRadioButton.addActionListener(drbModeListener);
        this.subJRadioButton.addActionListener(drbModeListener);
        this.subJRadioButton.setSelected(true);
        String drbTooltip = "Additive or Subtractive Alpha Brush to Improve Edges or Highly Detailed Regions.";
        this.addJRadioButton.setToolTipText("Additive or Subtractive Alpha Brush to Improve Edges or Highly Detailed Regions.");
        this.subJRadioButton.setToolTipText("Additive or Subtractive Alpha Brush to Improve Edges or Highly Detailed Regions.");
        this.addThreshold.setToolTipText("Threshold Defining Subpixel Granularity for Additive Refinement Brush.");
        this.subThreshold.setToolTipText("Threshold Defining Subpixel Granularity for Substractive Refinement Brush.");
        this.addThreshold.setPaintTicks(true);
        this.addThreshold.setMinorTickSpacing(5);
        this.addThreshold.putClientProperty("JSlider.isFilled", Boolean.TRUE);
        this.subThreshold.setPaintTicks(true);
        this.subThreshold.setMinorTickSpacing(5);
        this.subThreshold.putClientProperty("JSlider.isFilled", Boolean.TRUE);
        this.drbJPanel.add((Component)this.subJRadioButton, ControlJPanel.getGbc(0, 1, 1, false, false));
        this.drbJPanel.add((Component)this.subThreshold, ControlJPanel.getGbc(1, 1, 2, false, true));
        this.drbJPanel.add((Component)this.addJRadioButton, ControlJPanel.getGbc(0, 2, 1, false, false));
        this.drbJPanel.add((Component)this.addThreshold, ControlJPanel.getGbc(1, 2, 2, false, true));
        this.drbJPanel.add(Box.createVerticalStrut(6), ControlJPanel.getGbc(0, 3, 1, false, false));
        this.drbJPanel.add((Component)this.refineJButton, segGc);
        String resetTooltip = "Reset displayed image";
        this.resetJButton.setToolTipText("Reset displayed image");
        this.resetJPanel.add((Component)this.resetJButton, ControlJPanel.getGbc(0, 0, 1, false, false));
        this.resetJPanel.add((Component)this.createMaskJButton, ControlJPanel.getGbc(1, 0, 1, false, false));
        this.resetJPanel.add((Component)this.saveSegmentatorJButton, ControlJPanel.getGbc(2, 0, 1, false, false));
        controlsBox.add((Component)this.segJPanel, ControlJPanel.getGbc(0, 0, 1, false, true));
        controlsBox.add((Component)this.drbJPanel, ControlJPanel.getGbc(0, 1, 1, false, true));
        controlsBox.add((Component)this.resetJPanel, ControlJPanel.getGbc(0, 2, 1, false, true));
        this.add((Component)controlsBox, "East");
        this.updateComponentEnabling();
    }

    private static GridBagConstraints getGbc(int x, int y, int width, boolean vFill, boolean hFill) {
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(6, 6, 5, 5);
        c.anchor = 17;
        c.gridx = x;
        c.gridy = y;
        c.gridwidth = width;
        if (vFill) {
            c.fill = 3;
            c.weighty = 1.0;
        }
        if (hFill) {
            c.fill = hFill ? 1 : 2;
            c.weightx = 1.0;
        }
        return c;
    }

    void updateComponentEnabling() {
        Color onColor = UIManager.getColor("TitledBorder.titleColor");
        Color offColor = UIManager.getColor("Label.disabledForeground");
        boolean addPhase = this.status == 5;
        ((TitledBorder)this.segJPanel.getBorder()).setTitleColor(addPhase ? onColor : offColor);
        this.smoothness.setEnabled(addPhase);
        this.smoothJLabel.setEnabled(addPhase);
        this.fgOrBgJLabel.setEnabled(addPhase);
        this.fgJRadioButton.setEnabled(addPhase);
        this.bgJRadioButton.setEnabled(addPhase);
        this.multipart.setEnabled(addPhase);
        this.segmentJButton.setEnabled(addPhase);
        this.segJPanel.repaint();
        boolean drbPhase = this.status == 6;
        ((TitledBorder)this.drbJPanel.getBorder()).setTitleColor(drbPhase ? onColor : offColor);
        this.addJRadioButton.setEnabled(drbPhase);
        this.subJRadioButton.setEnabled(drbPhase);
        if (!this.addJRadioButton.isEnabled()) {
            this.subJRadioButton.setSelected(true);
        }
        this.refineJButton.setEnabled(drbPhase);
        this.addThreshold.setEnabled(drbPhase && this.addJRadioButton.isSelected());
        this.subThreshold.setEnabled(drbPhase && this.subJRadioButton.isSelected());
        this.drbJPanel.repaint();
    }
}

