/*
 * Decompiled with CFR 0.152.
 */
package ij3d.pointlist;

import org.jogamp.java3d.Alpha;
import org.jogamp.java3d.Appearance;
import org.jogamp.java3d.BoundingSphere;
import org.jogamp.java3d.Bounds;
import org.jogamp.java3d.BranchGroup;
import org.jogamp.java3d.ColoringAttributes;
import org.jogamp.java3d.Geometry;
import org.jogamp.java3d.Group;
import org.jogamp.java3d.Material;
import org.jogamp.java3d.Node;
import org.jogamp.java3d.OrientedShape3D;
import org.jogamp.java3d.RenderingAttributes;
import org.jogamp.java3d.ScaleInterpolator;
import org.jogamp.java3d.Transform3D;
import org.jogamp.java3d.TransformGroup;
import org.jogamp.java3d.utils.geometry.Sphere;
import org.jogamp.java3d.utils.geometry.Text2D;
import org.jogamp.vecmath.Color3f;
import org.jogamp.vecmath.Point3d;
import org.jogamp.vecmath.Point3f;
import org.jogamp.vecmath.Vector3f;
import vib.BenesNamedPoint;
import vib.PointList;

public class PointListShape
extends BranchGroup
implements PointList.PointListListener {
    private PointList points;
    private Color3f color = new Color3f(1.0f, 1.0f, 0.0f);
    private Appearance appearance;
    private float radius = 1.0f;
    private final Transform3D t3d = new Transform3D();
    private final Vector3f v3f = new Vector3f();

    public PointListShape(PointList points) {
        this.setCapability(14);
        this.setCapability(13);
        this.setCapability(17);
        this.points = points;
        points.addPointListListener((PointList.PointListListener)this);
        this.initAppearance(this.color);
        this.recreate();
    }

    public void setPointList(PointList pl) {
        this.points.removePointListListener((PointList.PointListListener)this);
        this.points = pl;
        this.points.addPointListListener((PointList.PointListListener)this);
        this.recreate();
    }

    public float getRadius() {
        return this.radius;
    }

    public void setRadius(float r) {
        this.radius = r;
        Transform3D t3d = new Transform3D();
        for (int i = 0; i < this.numChildren(); ++i) {
            BranchGroup bg = (BranchGroup)this.getChild(i);
            TransformGroup tg = (TransformGroup)bg.getChild(0);
            ScaleInterpolator si = (ScaleInterpolator)tg.getChild(1);
            if (si != null) {
                si.setMaximumScale(5.0f * this.radius);
                si.setMinimumScale(this.radius);
            }
            TransformGroup sig = (TransformGroup)tg.getChild(0);
            sig.getTransform(t3d);
            t3d.setScale((double)this.radius);
            sig.setTransform(t3d);
        }
    }

    public void setColor(Color3f c) {
        this.color = c == null ? new Color3f(1.0f, 1.0f, 0.0f) : c;
        this.initAppearance(this.color);
        for (int i = 0; i < this.numChildren(); ++i) {
            BranchGroup bg = (BranchGroup)this.getChild(i);
            TransformGroup tg = (TransformGroup)((Group)bg.getChild(0)).getChild(0);
            Sphere s = (Sphere)tg.getChild(0);
            s.setAppearance(this.appearance);
            Group gr = (Group)bg.getChild(0);
            gr = (Group)gr.getChild(2);
            OrientedShape3D os = (OrientedShape3D)gr.getChild(0);
            Text2D t2d = new Text2D(this.points.get(i).getName(), this.color, "Helvetica", 24, 0);
            t2d.setRectangleScaleFactor(0.03f);
            Geometry g = t2d.getGeometry();
            Appearance a = t2d.getAppearance();
            RenderingAttributes ra = new RenderingAttributes();
            ra.setDepthTestFunction(0);
            a.setRenderingAttributes(ra);
            g.setCapability(18);
            os.setGeometry(g);
            os.setAppearance(a);
        }
    }

    public Color3f getColor() {
        return this.color;
    }

    public void added(BenesNamedPoint p) {
        Point3f p3f = new Point3f((float)p.x, (float)p.y, (float)p.z);
        this.addPointToGeometry(p3f, p.getName());
    }

    public void removed(BenesNamedPoint p) {
        this.deletePointFromGeometry(p.getName());
    }

    public void renamed(BenesNamedPoint p) {
        int i = this.points.indexOf(p);
        this.getChild(i).setName(this.points.get(i).getName());
        Group bg = (Group)this.getChild(i);
        bg = (Group)bg.getChild(0);
        bg = (Group)bg.getChild(2);
        OrientedShape3D os = (OrientedShape3D)bg.getChild(0);
        Text2D t2d = new Text2D(p.getName(), this.color, "Helvetica", 24, 0);
        t2d.setRectangleScaleFactor(0.03f);
        Geometry g = t2d.getGeometry();
        Appearance a = t2d.getAppearance();
        RenderingAttributes ra = new RenderingAttributes();
        ra.setDepthTestFunction(0);
        a.setRenderingAttributes(ra);
        g.setCapability(18);
        os.setGeometry(g);
        os.setAppearance(a);
    }

    public void moved(BenesNamedPoint p) {
        int i = this.points.indexOf(p);
        if (i >= 0 && i < this.points.size()) {
            this.updatePositionInGeometry(i, new Point3d(p.x, p.y, p.z));
        }
    }

    public void reordered() {
        this.recreate();
    }

    public void highlighted(BenesNamedPoint p) {
        int i = this.points.indexOf(p);
        BranchGroup bg = (BranchGroup)this.getChild(i);
        TransformGroup tg = (TransformGroup)bg.getChild(0);
        ScaleInterpolator si = (ScaleInterpolator)tg.getChild(1);
        Alpha a = si.getAlpha();
        si.setEnable(true);
        a.resume();
        try {
            Thread.sleep(600L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        a.pause();
        si.setEnable(false);
    }

    private void deletePointFromGeometry(String name) {
        for (int i = 0; i < this.numChildren(); ++i) {
            BranchGroup bg = (BranchGroup)this.getChild(i);
            if (!bg.getName().equals(name)) continue;
            bg.detach();
            return;
        }
    }

    private void addPointToGeometry(Point3f p, String name) {
        this.v3f.x = p.x;
        this.v3f.y = p.y;
        this.v3f.z = p.z;
        BranchGroup bg = new BranchGroup();
        bg.setName(name);
        bg.setCapability(17);
        this.t3d.set(this.v3f);
        TransformGroup tg = new TransformGroup(this.t3d);
        tg.setCapability(18);
        bg.addChild((Node)tg);
        TransformGroup sig = new TransformGroup();
        sig.setCapability(18);
        tg.addChild((Node)sig);
        Alpha alpha = new Alpha();
        alpha.setStartTime(System.currentTimeMillis());
        alpha.setMode(3);
        alpha.setIncreasingAlphaDuration(300L);
        alpha.setDecreasingAlphaDuration(300L);
        alpha.pause();
        ScaleInterpolator si = new ScaleInterpolator(alpha, sig);
        si.setMaximumScale(5.0f * this.radius);
        si.setMinimumScale(this.radius);
        BoundingSphere bs = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 100000.0);
        si.setSchedulingBounds((Bounds)bs);
        tg.addChild((Node)si);
        Sphere sphere = new Sphere();
        sphere.setPickable(false);
        sphere.getShape().setCapability(15);
        sphere.setCapability(64);
        sphere.setAppearance(this.appearance);
        sig.addChild((Node)sphere);
        this.addText((Group)tg, name, p, this.color);
        this.addChild((Node)bg);
        si.setEnable(false);
        Transform3D scaleTransform = new Transform3D();
        sig.getTransform(scaleTransform);
        scaleTransform.setScale((double)this.radius);
        sig.setTransform(scaleTransform);
    }

    private void addText(Group bg, String s, Point3f pos, Color3f c) {
        Transform3D translation = new Transform3D();
        translation.setTranslation(new Vector3f(-this.radius, -this.radius, 0.0f));
        TransformGroup tg = new TransformGroup(translation);
        Text2D t2d = new Text2D(s, c, "Helvetica", 24, 0);
        t2d.setRectangleScaleFactor(0.03f);
        Geometry g = t2d.getGeometry();
        Appearance a = t2d.getAppearance();
        RenderingAttributes ra = new RenderingAttributes();
        ra.setDepthTestFunction(0);
        a.setRenderingAttributes(ra);
        g.setCapability(18);
        OrientedShape3D textShape = new OrientedShape3D();
        textShape.setCapability(13);
        textShape.setCapability(15);
        textShape.setAlignmentMode(1);
        textShape.setAlignmentAxis(0.0f, 1.0f, 0.0f);
        textShape.setRotationPoint(new Point3f());
        textShape.setConstantScaleEnable(true);
        textShape.setGeometry(g);
        textShape.setAppearance(a);
        tg.setCapability(1);
        tg.setPickable(true);
        tg.addChild((Node)textShape);
        bg.addChild((Node)tg);
    }

    private void updatePositionInGeometry(int i, Point3d pos) {
        BranchGroup bg = (BranchGroup)this.getChild(i);
        TransformGroup tg = (TransformGroup)bg.getChild(0);
        this.v3f.x = (float)pos.x;
        this.v3f.y = (float)pos.y;
        this.v3f.z = (float)pos.z;
        this.t3d.set(this.v3f);
        tg.setTransform(this.t3d);
    }

    private void recreate() {
        this.removeAllChildren();
        for (int i = 0; i < this.points.size(); ++i) {
            BenesNamedPoint po = this.points.get(i);
            Point3f p3f = new Point3f((float)po.x, (float)po.y, (float)po.z);
            this.addPointToGeometry(p3f, po.getName());
        }
    }

    private void initAppearance(Color3f color) {
        this.appearance = new Appearance();
        this.appearance.setCapability(8);
        ColoringAttributes colorAttrib = new ColoringAttributes();
        colorAttrib.setShadeModel(3);
        colorAttrib.setColor(color);
        colorAttrib.setCapability(1);
        this.appearance.setColoringAttributes(colorAttrib);
        Material material = new Material();
        material.setDiffuseColor(color);
        this.appearance.setMaterial(material);
    }

    public String toString() {
        return this.points.toString();
    }
}

