/*
 * Decompiled with CFR 0.152.
 */
package org.lsmp.djep.rewrite;

import org.lsmp.djep.rewrite.RewriteRuleI;
import org.lsmp.djep.xjep.DoNothingVisitor;
import org.lsmp.djep.xjep.TreeUtils;
import org.lsmp.djep.xjep.XJep;
import org.nfunk.jep.ASTFunNode;
import org.nfunk.jep.Node;
import org.nfunk.jep.ParseException;

public class RewriteVisitor
extends DoNothingVisitor {
    private XJep xj;
    private RewriteRuleI[] rules;
    private boolean simp = false;

    public Node rewrite(Node node, XJep xjep, RewriteRuleI[] inrules, boolean simplify) throws ParseException, IllegalArgumentException {
        this.xj = xjep;
        this.rules = inrules;
        this.simp = simplify;
        if (this.rules.length == 0) {
            return node;
        }
        if (node == null) {
            throw new IllegalArgumentException("topNode parameter is null");
        }
        Node res = (Node)node.jjtAccept(this, null);
        return res;
    }

    @Override
    public Object visit(ASTFunNode node, Object data) throws ParseException {
        Node[] children = this.acceptChildrenAsArray(node, data);
        TreeUtils.copyChildrenIfNeeded(node, children);
        for (int i = 0; i < this.rules.length; ++i) {
            if (!this.rules[i].test(node, children)) continue;
            Node newNode = this.rules[i].apply(node, children);
            if (this.simp) {
                newNode = this.xj.simplify(newNode);
            }
            return newNode.jjtAccept(this, data);
        }
        return node;
    }
}

