/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import edu.umd.cs.findbugs.annotations.Nullable;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import org.jhotdraw.draw.AbstractCompositeFigure;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.FigureLayerComparator;
import org.jhotdraw.draw.event.FigureAdapter;
import org.jhotdraw.draw.event.FigureEvent;
import org.jhotdraw.geom.Dimension2DDouble;
import org.jhotdraw.geom.QuadTree;
import org.jhotdraw.util.ReversedList;

public abstract class QuadTreeCompositeFigure
extends AbstractCompositeFigure {
    private QuadTree<Figure> quadTree = new QuadTree();
    private boolean needsSorting = false;
    private FigureHandler figureHandler = this.createFigureHandler();
    private Dimension2DDouble canvasSize;

    protected FigureHandler createFigureHandler() {
        return new FigureHandler();
    }

    @Override
    public int indexOf(Figure figure) {
        return this.children.indexOf(figure);
    }

    @Override
    public void basicAdd(int index, Figure figure) {
        this.children.add(index, figure);
        this.quadTree.add(figure, figure.getDrawingArea());
        figure.addFigureListener(this.figureHandler);
        this.needsSorting = true;
    }

    @Override
    public Figure basicRemoveChild(int index) {
        Figure figure = (Figure)this.children.get(index);
        this.children.remove(index);
        this.quadTree.remove(figure);
        figure.removeFigureListener(this.figureHandler);
        this.needsSorting = true;
        return figure;
    }

    @Override
    public void draw(Graphics2D g) {
        Rectangle clipBounds = g.getClipBounds();
        if (clipBounds != null) {
            Collection<Figure> c = this.quadTree.findIntersects(clipBounds);
            List<Figure> toDraw = this.sort(c);
            this.draw(g, toDraw);
        } else {
            this.draw(g, this.children);
        }
    }

    public List<Figure> sort(Collection<Figure> c) {
        this.ensureSorted();
        ArrayList<Figure> sorted = new ArrayList<Figure>(c.size());
        for (Figure f : this.children) {
            if (!c.contains(f)) continue;
            sorted.add(f);
        }
        return sorted;
    }

    public void draw(Graphics2D g, Collection<Figure> c) {
        for (Figure f : c) {
            f.draw(g);
        }
    }

    public List<Figure> getFigures(Rectangle2D.Double bounds) {
        return new LinkedList<Figure>(this.quadTree.findInside(bounds));
    }

    @Override
    public List<Figure> getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    @Override
    public Figure findFigureInside(Point2D.Double p) {
        Collection<Figure> c = this.quadTree.findContains(p);
        for (Figure f : this.getFiguresFrontToBack()) {
            if (!c.contains(f) || !f.contains(p)) continue;
            return f.findFigureInside(p);
        }
        return null;
    }

    public List<Figure> getFiguresFrontToBack() {
        this.ensureSorted();
        return new ReversedList<Figure>(this.children);
    }

    @Nullable
    public Figure findFigure(Point2D.Double p) {
        Collection<Figure> c = this.quadTree.findContains(p);
        switch (c.size()) {
            case 0: {
                return null;
            }
            case 1: {
                Figure f = c.iterator().next();
                return f.contains(p) ? f : null;
            }
        }
        for (Figure f : this.getFiguresFrontToBack()) {
            if (!c.contains(f) || !f.contains(p)) continue;
            return f;
        }
        return null;
    }

    @Nullable
    public Figure findFigureExcept(Point2D.Double p, Figure ignore) {
        Collection<Figure> c = this.quadTree.findContains(p);
        switch (c.size()) {
            case 0: {
                return null;
            }
            case 1: {
                Figure f = c.iterator().next();
                return f == ignore || !f.contains(p) ? null : f;
            }
        }
        for (Figure f : this.getFiguresFrontToBack()) {
            if (f == ignore || !f.contains(p)) continue;
            return f;
        }
        return null;
    }

    @Nullable
    public Figure findFigureExcept(Point2D.Double p, Collection ignore) {
        Collection<Figure> c = this.quadTree.findContains(p);
        switch (c.size()) {
            case 0: {
                return null;
            }
            case 1: {
                Figure f = c.iterator().next();
                return !ignore.contains(f) || !f.contains(p) ? null : f;
            }
        }
        for (Figure f : this.getFiguresFrontToBack()) {
            if (ignore.contains(f) || !f.contains(p)) continue;
            return f;
        }
        return null;
    }

    @Nullable
    public Figure findFigureBehind(Point2D.Double p, Figure figure) {
        boolean isBehind = false;
        for (Figure f : this.getFiguresFrontToBack()) {
            if (isBehind) {
                if (!f.isVisible() || !f.contains(p)) continue;
                return f;
            }
            isBehind = figure == f;
        }
        return null;
    }

    @Nullable
    public Figure findFigureBehind(Point2D.Double p, Collection<Figure> figures) {
        int inFrontOf = figures.size();
        for (Figure f : this.getFiguresFrontToBack()) {
            if (inFrontOf == 0) {
                if (!f.isVisible() || !f.contains(p)) continue;
                return f;
            }
            if (!figures.contains(f)) continue;
            --inFrontOf;
        }
        return null;
    }

    public List<Figure> findFigures(Rectangle2D.Double r) {
        LinkedList<Figure> c = new LinkedList<Figure>(this.quadTree.findIntersects(r));
        switch (c.size()) {
            case 0: 
            case 1: {
                return c;
            }
        }
        return this.sort(c);
    }

    public List<Figure> findFiguresWithin(Rectangle2D.Double bounds) {
        LinkedList<Figure> contained = new LinkedList<Figure>();
        for (Figure f : this.children) {
            Rectangle2D r = f.getBounds();
            if (f.get(AttributeKeys.TRANSFORM) != null) {
                r = f.get(AttributeKeys.TRANSFORM).createTransformedShape(r).getBounds2D();
            }
            if (!f.isVisible() || !bounds.contains(r)) continue;
            contained.add(f);
        }
        return contained;
    }

    @Override
    public void bringToFront(Figure figure) {
        if (this.children.remove(figure)) {
            this.children.add(figure);
            this.needsSorting = true;
            this.fireAreaInvalidated(figure.getDrawingArea());
        }
    }

    @Override
    public void sendToBack(Figure figure) {
        if (this.children.remove(figure)) {
            this.children.add(0, figure);
            this.needsSorting = true;
            this.fireAreaInvalidated(figure.getDrawingArea());
        }
    }

    @Override
    public boolean contains(Figure f) {
        return this.children.contains(f);
    }

    private void ensureSorted() {
        if (this.needsSorting) {
            Collections.sort(this.children, FigureLayerComparator.INSTANCE);
            this.needsSorting = false;
        }
    }

    public void setCanvasSize(Dimension2DDouble newValue) {
        Dimension2DDouble oldValue = this.canvasSize;
        this.canvasSize = newValue;
        this.firePropertyChange("canvasSize", oldValue, newValue);
    }

    public Dimension2DDouble getCanvasSize() {
        return this.canvasSize;
    }

    protected class FigureHandler
    extends FigureAdapter
    implements UndoableEditListener {
        protected FigureHandler() {
        }

        @Override
        public void undoableEditHappened(UndoableEditEvent e) {
            QuadTreeCompositeFigure.this.fireUndoableEditHappened(e.getEdit());
        }

        @Override
        public void areaInvalidated(FigureEvent e) {
            QuadTreeCompositeFigure.this.fireAreaInvalidated(e.getInvalidatedArea());
        }

        @Override
        public void figureChanged(FigureEvent e) {
            QuadTreeCompositeFigure.this.quadTree.remove(e.getFigure());
            QuadTreeCompositeFigure.this.quadTree.add(e.getFigure(), e.getFigure().getDrawingArea());
            QuadTreeCompositeFigure.this.needsSorting = true;
            if (!QuadTreeCompositeFigure.this.isChanging()) {
                QuadTreeCompositeFigure.this.fireAreaInvalidated(e.getInvalidatedArea());
            }
        }

        @Override
        public void figureRequestRemove(FigureEvent e) {
            QuadTreeCompositeFigure.this.remove(e.getFigure());
        }
    }
}

