/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.svg;

import edu.umd.cs.findbugs.annotations.Nullable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.print.Pageable;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.HashMap;
import javax.swing.SwingUtilities;
import org.jhotdraw.app.AbstractView;
import org.jhotdraw.draw.Drawing;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.io.InputFormat;
import org.jhotdraw.draw.print.DrawingPageable;
import org.jhotdraw.gui.JFileURIChooser;
import org.jhotdraw.gui.URIChooser;
import org.jhotdraw.net.URIUtil;
import org.jhotdraw.samples.svg.SVGDrawingPanel;
import org.jhotdraw.samples.svg.io.SVGOutputFormat;
import org.jhotdraw.undo.UndoRedoManager;
import org.jhotdraw.util.ResourceBundleUtil;

public class SVGView
extends AbstractView {
    public static final String DRAWING_PROPERTY = "drawing";
    public static final String GRID_VISIBLE_PROPERTY = "gridVisible";
    protected JFileURIChooser exportChooser;
    private UndoRedoManager undo;
    @Nullable
    private PropertyChangeListener propertyHandler;
    private SVGDrawingPanel svgPanel;

    public SVGView() {
        this.initComponents();
        this.undo = this.svgPanel.getUndoRedoManager();
        Drawing oldDrawing = this.svgPanel.getDrawing();
        this.svgPanel.setDrawing(this.createDrawing());
        this.firePropertyChange(DRAWING_PROPERTY, oldDrawing, this.svgPanel.getDrawing());
        this.svgPanel.getDrawing().addUndoableEditListener(this.undo);
        this.initActions();
        this.propertyHandler = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                SVGView.this.setHasUnsavedChanges(SVGView.this.undo.hasSignificantEdits());
            }
        };
        this.undo.addPropertyChangeListener(this.propertyHandler);
    }

    @Override
    public void dispose() {
        this.clear();
        this.undo.removePropertyChangeListener(this.propertyHandler);
        this.propertyHandler = null;
        this.svgPanel.dispose();
        super.dispose();
    }

    protected Drawing createDrawing() {
        return this.svgPanel.createDrawing();
    }

    public Pageable createPageable() {
        return new DrawingPageable(this.svgPanel.getDrawing());
    }

    public DrawingEditor getEditor() {
        return this.svgPanel.getEditor();
    }

    public void setEditor(DrawingEditor newValue) {
        this.svgPanel.setEditor(newValue);
    }

    public UndoRedoManager getUndoManager() {
        return this.undo;
    }

    private void initActions() {
        this.getActionMap().put("edit.undo", this.undo.getUndoAction());
        this.getActionMap().put("edit.redo", this.undo.getRedoAction());
    }

    @Override
    protected void setHasUnsavedChanges(boolean newValue) {
        super.setHasUnsavedChanges(newValue);
        this.undo.setHasSignificantEdits(newValue);
    }

    @Override
    public void write(URI uri, URIChooser chooser) throws IOException {
        new SVGOutputFormat().write(new File(uri), this.svgPanel.getDrawing());
    }

    @Override
    public void read(URI uri, URIChooser chooser) throws IOException {
        try {
            JFileURIChooser fc = (JFileURIChooser)chooser;
            final Drawing drawing = this.createDrawing();
            HashMap fileFilterInputFormatMap = null;
            if (fc != null) {
                fileFilterInputFormatMap = (HashMap)fc.getClientProperty("InputFormatMap");
            }
            InputFormat selectedFormat = fc == null ? null : (InputFormat)fileFilterInputFormatMap.get(fc.getFileFilter());
            boolean success = false;
            if (selectedFormat != null) {
                try {
                    selectedFormat.read(uri, drawing, true);
                    success = true;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (!success) {
                for (InputFormat sfi : drawing.getInputFormats()) {
                    if (sfi == selectedFormat) continue;
                    try {
                        sfi.read(uri, drawing, true);
                        success = true;
                        break;
                    }
                    catch (Exception e) {
                    }
                }
            }
            if (!success) {
                ResourceBundleUtil labels = ResourceBundleUtil.getBundle("org.jhotdraw.app.Labels");
                throw new IOException(labels.getFormatted("file.open.unsupportedFileFormat.message", URIUtil.getName(uri)));
            }
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    Drawing oldDrawing = SVGView.this.svgPanel.getDrawing();
                    SVGView.this.svgPanel.setDrawing(drawing);
                    SVGView.this.firePropertyChange(SVGView.DRAWING_PROPERTY, oldDrawing, SVGView.this.svgPanel.getDrawing());
                    SVGView.this.undo.discardAllEdits();
                }
            });
        }
        catch (InterruptedException e) {
            InternalError error = new InternalError();
            e.initCause(e);
            throw error;
        }
        catch (InvocationTargetException e) {
            InternalError error = new InternalError();
            error.initCause(e);
            throw error;
        }
    }

    public Drawing getDrawing() {
        return this.svgPanel.getDrawing();
    }

    @Override
    public void setEnabled(boolean newValue) {
        this.svgPanel.setEnabled(newValue);
        super.setEnabled(newValue);
    }

    @Override
    public void clear() {
        final Drawing newDrawing = this.createDrawing();
        try {
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    Drawing oldDrawing = SVGView.this.svgPanel.getDrawing();
                    SVGView.this.svgPanel.setDrawing(newDrawing);
                    SVGView.this.firePropertyChange(SVGView.DRAWING_PROPERTY, oldDrawing, newDrawing);
                    if (oldDrawing != null) {
                        oldDrawing.removeAllChildren();
                        oldDrawing.removeUndoableEditListener(SVGView.this.undo);
                    }
                    SVGView.this.undo.discardAllEdits();
                    newDrawing.addUndoableEditListener(SVGView.this.undo);
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                r.run();
            } else {
                SwingUtilities.invokeAndWait(r);
            }
        }
        catch (InvocationTargetException ex) {
            ex.printStackTrace();
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public boolean canSaveTo(URI file) {
        return file.getPath().endsWith(".svg") || file.getPath().endsWith(".svgz");
    }

    private void initComponents() {
        this.svgPanel = new SVGDrawingPanel();
        this.setLayout(new BorderLayout());
        this.add((Component)this.svgPanel, "Center");
    }
}

