/*
 * Decompiled with CFR 0.152.
 */
package process3d;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.gui.GenericDialog;
import ij.plugin.filter.PlugInFilter;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;
import ij.text.TextWindow;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import process3d.Plot_Dots;

public class Particle_Analyzer_3D
implements PlugInFilter {
    private ImagePlus image;
    private ImagePlus result;
    private int[] classes;
    private int[] sizes;
    private int[] intensities;
    private int w;
    private int h;
    private int z;
    private int threshold = 100;
    private boolean showStatus = true;

    public Particle_Analyzer_3D() {
    }

    public int setup(String arg, ImagePlus imp) {
        this.image = imp;
        return 1;
    }

    public void run(ImageProcessor ip) {
        GenericDialog gd = new GenericDialog("Particle Analyzer 3D");
        gd.addNumericField("Threshold [0..255]", (double)this.threshold, 0);
        gd.addCheckbox("Show_result_table", true);
        gd.addCheckbox("Show_result_chart", true);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        this.threshold = (int)gd.getNextNumber();
        this.w = this.image.getWidth();
        this.h = this.image.getHeight();
        this.z = this.image.getStackSize();
        this.showStatus = true;
        this.result = this.classify(this.image);
        this.calculateIntensities(this.image);
        this.calculateSizes();
        this.sortResults();
        if (this.sizes.length > 3) {
            this.keepNLargest(3);
        }
        this.getResultAsByteImage().show();
        if (gd.getNextBoolean()) {
            this.showResultWindow();
        }
        if (gd.getNextBoolean()) {
            this.showChart();
        }
    }

    public ImagePlus getResultAsByteImage() {
        ImageStack stack = new ImageStack(this.w, this.h);
        for (int d = 0; d < this.z; ++d) {
            int[] p = (int[])this.result.getStack().getPixels(d + 1);
            byte[] b = new byte[this.w * this.h];
            for (int i = 0; i < b.length; ++i) {
                b[i] = p[i] == -1 ? -1 : (byte)p[i];
            }
            stack.addSlice("", (ImageProcessor)new ByteProcessor(this.w, this.h, b, null));
        }
        ImagePlus res = new ImagePlus("Classified", stack);
        res.setCalibration(this.image.getCalibration());
        return res;
    }

    public void keepNLargest(int n) {
        int[] sizes_tmp = new int[n];
        int[] intensities_tmp = new int[n];
        int[] classes_tmp = new int[n];
        System.arraycopy(this.sizes, 0, sizes_tmp, 0, n);
        System.arraycopy(this.intensities, 0, intensities_tmp, 0, n);
        System.arraycopy(this.classes, 0, classes_tmp, 0, n);
        for (int z = 0; z < this.result.getStackSize(); ++z) {
            ImageProcessor ip = this.result.getStack().getProcessor(z + 1);
            for (int i = 0; i < this.w * this.h; ++i) {
                if (ip.get(i) < n) continue;
                ip.set(i, -1);
            }
        }
        this.sizes = sizes_tmp;
        this.intensities = intensities_tmp;
        this.classes = classes_tmp;
    }

    public void sortResults() {
        Object[] cls = new Cl[this.classes.length];
        for (int i = 0; i < cls.length; ++i) {
            cls[i] = new Cl(this.classes[i], this.sizes[i], this.intensities[i]);
        }
        Arrays.sort(cls);
        for (int z = 0; z < this.result.getStackSize(); ++z) {
            ImageProcessor ip = this.result.getStack().getProcessor(z + 1);
            block2: for (int i = 0; i < this.w * this.h; ++i) {
                if (ip.get(i) == -1) continue;
                for (int c = 0; c < cls.length; ++c) {
                    if (ip.get(i) != ((Cl)cls[c]).cl) continue;
                    ip.set(i, c);
                    continue block2;
                }
            }
        }
        for (int c = 0; c < this.classes.length; ++c) {
            Object cl = cls[c];
            this.sizes[c] = ((Cl)cl).size;
            this.intensities[c] = ((Cl)cl).inten;
        }
    }

    public void showResultWindow() {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < this.classes.length; ++i) {
            buf.append(this.classes[i] + "\t" + this.sizes[i]);
            buf.append("\t" + this.intensities[i]);
            buf.append("\n");
        }
        String headings = "Class\tsize\tintensity";
        new TextWindow("Results", headings, buf.toString(), 500, 350);
    }

    public void showChart() {
        double[] x = new double[this.sizes.length];
        double[] y = new double[this.intensities.length];
        String[] labels = new String[this.classes.length];
        for (int i = 0; i < x.length; ++i) {
            x[i] = this.sizes[i];
            y[i] = (double)this.intensities[i] / 100.0;
            labels[i] = Integer.toString(this.classes[i]);
        }
        Plot_Dots pd = new Plot_Dots();
        pd.x = x;
        pd.y = y;
        pd.labels = labels;
        pd.xLabel = "Size";
        pd.yLabel = "Intensity";
        pd.create();
    }

    public Particle_Analyzer_3D(ImagePlus imp, int th, boolean showStatus) {
        this.image = imp;
        this.w = this.image.getWidth();
        this.h = this.image.getHeight();
        this.z = this.image.getStackSize();
        this.showStatus = showStatus;
        this.threshold = th;
        this.result = this.classify(this.image);
    }

    public int[] getClasses() {
        return this.classes;
    }

    public int[] sizes() {
        return this.sizes;
    }

    public int classesCount() {
        return this.classes.length;
    }

    public ImagePlus classesAsImage() {
        return this.result;
    }

    public ImagePlus imageForClass(int classlabel, String label) {
        ImageStack stack = new ImageStack(this.w, this.h);
        for (int d = 1; d <= this.z; ++d) {
            int[] result_pixels = (int[])this.result.getStack().getProcessor(d).getPixels();
            byte[] new_pixels = new byte[result_pixels.length];
            for (int i = 0; i < result_pixels.length; ++i) {
                new_pixels[i] = result_pixels[i] == classlabel ? -1 : 0;
            }
            stack.addSlice("", (ImageProcessor)new ByteProcessor(this.w, this.h, new_pixels, null));
        }
        if (label == null || label.trim().equals("")) {
            label = "Class " + classlabel;
        }
        ImagePlus tmp = new ImagePlus(label, stack);
        tmp.setCalibration(this.result.getCalibration());
        return tmp;
    }

    public int getSize(int classlabel) {
        for (int i = 0; i < this.classes.length; ++i) {
            if (this.classes[i] != classlabel) continue;
            return this.sizes[i];
        }
        return -1;
    }

    public int getLargestClass() {
        int index = -1;
        int maxSize = -1;
        for (int i = 0; i < this.classes.length; ++i) {
            if (this.sizes[i] <= maxSize) continue;
            maxSize = this.sizes[i];
            index = i;
        }
        return this.classes[index];
    }

    public ImagePlus imageOfLargestClass() {
        return this.imageForClass(this.getLargestClass(), "Largest object");
    }

    private ImagePlus classify(ImagePlus image) {
        if (this.showStatus) {
            IJ.showStatus((String)"classify...");
        }
        MergedClasses mergedClasses = new MergedClasses();
        ImageStack resStack = new ImageStack(this.w, this.h);
        for (int d = 1; d <= this.z; ++d) {
            byte[] pixels = (byte[])image.getStack().getProcessor(d).getPixels();
            int[] classes = new int[this.w * this.h];
            int[] classesBefore = d > 1 ? (int[])resStack.getProcessor(d - 1).getPixels() : null;
            for (int i = 0; i < this.h; ++i) {
                for (int j = 0; j < this.w; ++j) {
                    int index = i * this.w + j;
                    byte current = pixels[index];
                    int upper_c = i > 0 ? classes[index - this.w] : -1;
                    int left_c = j > 0 ? classes[index - 1] : -1;
                    int before_c = d > 1 ? classesBefore[index] : -1;
                    classes[index] = this.classifyPixel(mergedClasses, current, upper_c, left_c, before_c);
                }
            }
            if (this.showStatus) {
                IJ.showProgress((int)d, (int)this.z);
            }
            resStack.addSlice("", (ImageProcessor)new ColorProcessor(this.w, this.h, classes));
        }
        this.correctMergedClasses(mergedClasses, resStack);
        ImagePlus tmp = new ImagePlus("Classified", resStack);
        tmp.setCalibration(image.getCalibration());
        return tmp;
    }

    private void correctMergedClasses(MergedClasses mergedClasses, ImageStack resStack) {
        if (this.showStatus) {
            IJ.showStatus((String)"correct merged classes...");
        }
        Map<Integer, Integer> map = mergedClasses.mapToRealClasses();
        for (int d = 1; d <= this.z; ++d) {
            int[] res_pixels = (int[])resStack.getProcessor(d).getPixels();
            for (int i = 0; i < res_pixels.length; ++i) {
                int realClass;
                if (res_pixels[i] == -1) continue;
                res_pixels[i] = realClass = map.get(res_pixels[i]).intValue();
            }
            if (!this.showStatus) continue;
            IJ.showProgress((int)d, (int)this.z);
        }
        int n_classes = mergedClasses.classes.size();
        this.classes = new int[n_classes];
        for (int i = 0; i < n_classes; ++i) {
            this.classes[i] = i;
        }
    }

    public void calculateSizes() {
        if (this.showStatus) {
            IJ.showStatus((String)"calculate class sizes...");
        }
        ImageStack resStack = this.result.getStack();
        this.sizes = new int[this.classes.length];
        for (int d = 1; d <= this.z; ++d) {
            int[] classPixels = (int[])resStack.getProcessor(d).getPixels();
            for (int i = 0; i < this.w * this.h; ++i) {
                if (classPixels[i] == -1) continue;
                int n = classPixels[i];
                this.sizes[n] = this.sizes[n] + 1;
            }
            if (!this.showStatus) continue;
            IJ.showProgress((int)d, (int)this.z);
        }
    }

    public void calculateIntensities(ImagePlus intImp) {
        if (this.showStatus) {
            IJ.showStatus((String)"calculate class intensities...");
        }
        this.intensities = new int[this.classes.length];
        ImageStack resStack = this.result.getStack();
        ImageStack intStack = intImp.getStack();
        for (int d = 1; d <= this.z; ++d) {
            int[] classPixels = (int[])resStack.getProcessor(d).getPixels();
            byte[] intPixels = (byte[])intStack.getProcessor(d).getPixels();
            for (int i = 0; i < this.w * this.h; ++i) {
                if (classPixels[i] == -1) continue;
                int n = classPixels[i];
                this.intensities[n] = this.intensities[n] + (intPixels[i] & 0xFF);
            }
            if (!this.showStatus) continue;
            IJ.showProgress((int)d, (int)this.z);
        }
    }

    private int max(int[] array) {
        int max = array[0];
        for (int i = 1; i < array.length; ++i) {
            if (array[i] <= max) continue;
            max = array[i];
        }
        return max;
    }

    private int classifyPixel(MergedClasses mergedClasses, byte cur, int upper_c, int left_c, int before_c) {
        if ((cur & 0xFF) < this.threshold) {
            return -1;
        }
        boolean connected = upper_c != -1 || left_c != -1 || before_c != -1;
        int classl = -1;
        if (connected) {
            classl = Math.max(Math.max(upper_c, left_c), before_c);
            if (upper_c != classl && upper_c != -1) {
                mergedClasses.mergeIfNecessary(upper_c, classl);
            }
            if (left_c != classl && left_c != -1) {
                mergedClasses.mergeIfNecessary(left_c, classl);
            }
            if (before_c != classl && before_c != -1) {
                mergedClasses.mergeIfNecessary(before_c, classl);
            }
        } else {
            classl = mergedClasses.addNewClass();
        }
        return classl;
    }

    private class MergedClasses {
        private List<Set<Integer>> classes = new ArrayList<Set<Integer>>();
        private int n_entries = 0;

        private MergedClasses() {
        }

        int addNewClass() {
            HashSet<Integer> newset = new HashSet<Integer>();
            newset.add(this.n_entries);
            this.classes.add(newset);
            ++this.n_entries;
            return this.n_entries - 1;
        }

        void mergeIfNecessary(int a, int b) {
            Set<Integer> aSet = this.getClassWhichContains(a);
            Set<Integer> bSet = this.getClassWhichContains(b);
            if (aSet == null || bSet == null) {
                IJ.error((String)"Expected that both classes a and b already exist");
            }
            if (aSet == bSet) {
                return;
            }
            aSet.addAll(bSet);
            this.classes.remove(bSet);
        }

        Set<Integer> getClassWhichContains(int n) {
            int index = this.getClassIndexWhichContains(n);
            if (index != -1) {
                return this.classes.get(index);
            }
            return null;
        }

        int getClassIndexWhichContains(int n) {
            int i = 0;
            for (Set<Integer> set : this.classes) {
                if (set.contains(n)) {
                    return i;
                }
                ++i;
            }
            return -1;
        }

        Map<Integer, Integer> mapToRealClasses() {
            HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
            for (int i = 0; i < this.n_entries; ++i) {
                map.put(i, this.getClassIndexWhichContains(i));
            }
            return map;
        }

        void print() {
            for (int i = 0; i < this.classes.size(); ++i) {
                Set<Integer> set = this.classes.get(i);
                System.out.println(i + " --> [" + this.asString(set) + "]");
            }
        }

        String asString(Set<Integer> set) {
            StringBuffer buf = new StringBuffer();
            for (Integer i : set) {
                buf.append(i + "  ");
            }
            return buf.toString();
        }
    }

    private class Cl
    implements Comparable {
        int cl;
        int size;
        int inten;

        Cl(int cl, int size, int inten) {
            this.cl = cl;
            this.size = size;
            this.inten = inten;
        }

        public int compareTo(Object o) {
            return ((Cl)o).size - this.size;
        }
    }
}

