/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.internal.dataset.conv;

import com.google.common.collect.ImmutableList;
import com.google.re2j.Matcher;
import com.google.re2j.Pattern;
import java.io.IOException;
import java.util.Optional;
import javax.annotation.Nullable;
import ucar.ma2.Array;
import ucar.ma2.ArrayChar;
import ucar.ma2.ArrayDouble;
import ucar.ma2.DataType;
import ucar.ma2.IndexIterator;
import ucar.ma2.InvalidRangeException;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.constants.AxisType;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.CoordinateAxis1D;
import ucar.nc2.dataset.CoordinateSystem;
import ucar.nc2.dataset.CoordinateTransform;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.ProjectionCT;
import ucar.nc2.dataset.VariableDS;
import ucar.nc2.dataset.spi.CoordSystemBuilderFactory;
import ucar.nc2.internal.dataset.CoordSystemBuilder;
import ucar.nc2.internal.dataset.transform.vertical.WRFEtaTransformBuilder;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.time.CalendarDateFormatter;
import ucar.nc2.units.SimpleUnit;
import ucar.nc2.util.CancelTask;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.ProjectionImpl;
import ucar.unidata.geoloc.ProjectionPoint;
import ucar.unidata.geoloc.projection.FlatEarth;
import ucar.unidata.geoloc.projection.LambertConformal;
import ucar.unidata.geoloc.projection.Mercator;
import ucar.unidata.geoloc.projection.Stereographic;
import ucar.unidata.util.StringUtil2;

public class WRFConvention
extends CoordSystemBuilder {
    private static final String CONVENTION_NAME = "WRF";
    private double centerX;
    private double centerY;
    private ProjectionCT projCT;
    private boolean gridE;

    private WRFConvention(NetcdfDataset.Builder datasetBuilder) {
        super(datasetBuilder);
        this.conventionName = CONVENTION_NAME;
    }

    @Override
    public void augmentDataset(CancelTask cancelTask) {
        if (this.rootGroup.findVariableLocal("x").isPresent()) {
            return;
        }
        Attribute att = this.rootGroup.getAttributeContainer().findAttribute("GRIDTYPE");
        this.gridE = att != null && att.getStringValue().equalsIgnoreCase("E");
        for (Variable.Builder<?> v : this.rootGroup.vbuilders) {
            String units;
            att = v.getAttributeContainer().findAttributeIgnoreCase("units");
            if (att == null || (units = att.getStringValue()) == null) continue;
            ((VariableDS.Builder)v).setUnits(this.normalize(units));
        }
        att = this.rootGroup.getAttributeContainer().findAttribute("MAP_PROJ");
        if (att == null) {
            throw new IllegalStateException("WRF must have numeric MAP_PROJ attribute");
        }
        int projType = att.getNumericValue().intValue();
        boolean isLatLon = false;
        if (projType == 203) {
            Optional<Variable.Builder<?>> glatOpt = this.rootGroup.findVariableLocal("GLAT");
            if (!glatOpt.isPresent()) {
                this.parseInfo.format("Projection type 203 - expected GLAT variable not found%n", new Object[0]);
            } else {
                Variable.Builder<?> glat = glatOpt.get();
                glat.addAttribute(new Attribute("_CoordinateAxisType", AxisType.Lat.toString()));
                if (this.gridE) {
                    glat.addAttribute(new Attribute("_CoordinateStagger", "Arakawa-E"));
                }
                glat.setDimensionsByName("south_north west_east");
                glat.setCachedData(this.convertToDegrees(glat), false);
                ((VariableDS.Builder)glat).setUnits("degrees_north");
            }
            Optional<Variable.Builder<?>> glonOpt = this.rootGroup.findVariableLocal("GLON");
            if (!glonOpt.isPresent()) {
                this.parseInfo.format("Projection type 203 - expected GLON variable not found%n", new Object[0]);
            } else {
                Variable.Builder<?> glon = glonOpt.get();
                glon.addAttribute(new Attribute("_CoordinateAxisType", AxisType.Lon.toString()));
                if (this.gridE) {
                    glon.addAttribute(new Attribute("_CoordinateStagger", "Arakawa-E"));
                }
                glon.setDimensionsByName("south_north west_east");
                glon.setCachedData(this.convertToDegrees(glon), false);
                ((VariableDS.Builder)glon).setUnits("degrees_east");
            }
            VariableDS.Builder v = (VariableDS.Builder)((VariableDS.Builder)VariableDS.builder().setName("LatLonCoordSys")).setDataType(DataType.CHAR);
            v.addAttribute(new Attribute("_CoordinateAxes", "GLAT GLON Time"));
            Array data = Array.factory(DataType.CHAR, new int[0], (Object)new char[]{' '});
            v.setCachedData(data, true);
            this.rootGroup.addVariable(v);
            this.rootGroup.findVariableLocal("LANDMASK").ifPresent(dataVar -> dataVar.addAttribute(new Attribute("_CoordinateSystems", "LatLonCoordSys")));
        } else {
            double lat1 = this.findAttributeDouble("TRUELAT1");
            double lat2 = this.findAttributeDouble("TRUELAT2");
            double centralLat = this.findAttributeDouble("CEN_LAT");
            double centralLon = this.findAttributeDouble("CEN_LON");
            double standardLon = this.findAttributeDouble("STAND_LON");
            double standardLat = this.findAttributeDouble("MOAD_CEN_LAT");
            ProjectionImpl proj = null;
            switch (projType) {
                case 0: {
                    proj = new FlatEarth();
                    this.projCT = new ProjectionCT("flat_earth", "FGDC", proj);
                    break;
                }
                case 1: {
                    proj = new LambertConformal(standardLat, standardLon, lat1, lat2, 0.0, 0.0, 6370.0);
                    this.projCT = new ProjectionCT("Lambert", "FGDC", proj);
                    break;
                }
                case 2: {
                    double lon0 = Double.isNaN(standardLon) ? centralLon : standardLon;
                    double lat0 = Double.isNaN(centralLat) ? lat2 : centralLat;
                    double scaleFactor = (1.0 + Math.abs(Math.sin(Math.toRadians(lat1)))) / 2.0;
                    proj = new Stereographic(lat0, lon0, scaleFactor, 0.0, 0.0, 6370.0);
                    this.projCT = new ProjectionCT("Stereographic", "FGDC", proj);
                    break;
                }
                case 3: {
                    proj = new Mercator(standardLon, lat1, 0.0, 0.0, 6370.0);
                    this.projCT = new ProjectionCT("Mercator", "FGDC", proj);
                    break;
                }
                case 6: {
                    isLatLon = true;
                    for (VariableDS.Builder<?> v : ImmutableList.copyOf(this.rootGroup.vbuilders)) {
                        if (v.shortName.startsWith("XLAT")) {
                            v = this.removeConstantTimeDim(v);
                            v.addAttribute(new Attribute("_CoordinateAxisType", AxisType.Lat.toString()));
                            continue;
                        }
                        if (v.shortName.startsWith("XLONG")) {
                            v = this.removeConstantTimeDim(v);
                            v.addAttribute(new Attribute("_CoordinateAxisType", AxisType.Lon.toString()));
                            continue;
                        }
                        if (v.shortName.equals("T")) {
                            v.addAttribute(new Attribute("_CoordinateAxes", "Time XLAT XLONG z"));
                            continue;
                        }
                        if (v.shortName.equals("U")) {
                            v.addAttribute(new Attribute("_CoordinateAxes", "Time XLAT_U XLONG_U z"));
                            continue;
                        }
                        if (v.shortName.equals("V")) {
                            v.addAttribute(new Attribute("_CoordinateAxes", "Time XLAT_V XLONG_V z"));
                            continue;
                        }
                        if (!v.shortName.equals("W")) continue;
                        v.addAttribute(new Attribute("_CoordinateAxes", "Time XLAT XLONG z_stag"));
                    }
                    break;
                }
                default: {
                    this.parseInfo.format("ERROR: unknown projection type = %s%n", projType);
                }
            }
            if (proj != null) {
                LatLonPoint lpt1 = LatLonPoint.create(centralLat, centralLon);
                ProjectionPoint ppt1 = proj.latLonToProj(lpt1);
                this.centerX = ppt1.getX();
                this.centerY = ppt1.getY();
                if (this.debug) {
                    System.out.println("centerX=" + this.centerX);
                    System.out.println("centerY=" + this.centerY);
                }
            }
            if (!isLatLon) {
                this.datasetBuilder.replaceCoordinateAxis(this.rootGroup, this.makeXCoordAxis("x", "west_east"));
                this.datasetBuilder.replaceCoordinateAxis(this.rootGroup, this.makeXCoordAxis("x_stag", "west_east_stag"));
                this.datasetBuilder.replaceCoordinateAxis(this.rootGroup, this.makeYCoordAxis("y", "south_north"));
                this.datasetBuilder.replaceCoordinateAxis(this.rootGroup, this.makeYCoordAxis("y_stag", "south_north_stag"));
            }
            this.datasetBuilder.replaceCoordinateAxis(this.rootGroup, this.makeZCoordAxis("z", "bottom_top"));
            this.datasetBuilder.replaceCoordinateAxis(this.rootGroup, this.makeZCoordAxis("z_stag", "bottom_top_stag"));
            if (this.projCT != null) {
                VariableDS.Builder v = this.makeCoordinateTransformVariable(this.projCT);
                v.addAttribute(new Attribute("_CoordinateAxisTypes", "GeoX GeoY"));
                if (this.gridE) {
                    v.addAttribute(new Attribute("_CoordinateStagger", "Arakawa-E"));
                }
                this.rootGroup.addVariable(v);
            }
        }
        Optional<Variable.Builder<?>> timeVar = this.rootGroup.findVariableLocal("Time");
        if (!timeVar.isPresent()) {
            CoordinateAxis.Builder<?> taxis = this.makeTimeCoordAxis("Time", "Time");
            if (taxis == null) {
                taxis = this.makeTimeCoordAxis("Time", "Times");
            }
            if (taxis != null) {
                this.datasetBuilder.replaceCoordinateAxis(this.rootGroup, taxis);
            }
        }
        this.datasetBuilder.replaceCoordinateAxis(this.rootGroup, this.makeSoilDepthCoordAxis("ZS"));
    }

    private VariableDS.Builder<?> removeConstantTimeDim(Variable.Builder<?> vb) {
        VariableDS.Builder vds = (VariableDS.Builder)vb;
        Variable v = vds.orgVar;
        int[] shape = v.getShape();
        if (v.getRank() == 3 && shape[0] == 1) {
            Variable view;
            try {
                view = v.slice(0, 0);
            }
            catch (InvalidRangeException e) {
                this.parseInfo.format("Cant remove first dimension in variable %s", v);
                return vds;
            }
            Variable.Builder vbnew = VariableDS.builder().copyFrom(view);
            this.rootGroup.replaceVariable(vbnew);
            return vbnew;
        }
        return vds;
    }

    private Array convertToDegrees(Variable.Builder<?> vb) {
        Array data;
        VariableDS.Builder vds = (VariableDS.Builder)vb;
        Variable v = vds.orgVar;
        try {
            data = v.read();
            data = data.reduce();
        }
        catch (IOException ioe) {
            throw new RuntimeException("data read failed on " + v.getFullName() + "=" + ioe.getMessage());
        }
        IndexIterator ii = data.getIndexIterator();
        while (ii.hasNext()) {
            ii.setDoubleCurrent(Math.toDegrees(ii.getDoubleNext()));
        }
        return data;
    }

    private String normalize(String units) {
        switch (units) {
            case "fraction": 
            case "dimensionless": 
            case "-": 
            case "NA": {
                units = "";
                break;
            }
            default: {
                units = StringUtil2.substitute(units, "**", "^");
                units = StringUtil2.remove(units, 125);
                units = StringUtil2.remove(units, 123);
            }
        }
        return units;
    }

    @Override
    protected void makeCoordinateTransforms() {
        CoordSystemBuilder.VarProcess vp;
        if (this.projCT != null && (vp = this.findVarProcess(this.projCT.getName(), null)) != null) {
            vp.isCoordinateTransform = true;
            vp.ct = CoordinateTransform.builder().setPreBuilt(this.projCT);
            this.coords.addCoordinateTransform(vp.ct);
        }
        super.makeCoordinateTransforms();
    }

    @Override
    @Nullable
    protected AxisType getAxisType(VariableDS.Builder v) {
        String vname = v.shortName;
        if (vname.equalsIgnoreCase("x") || vname.equalsIgnoreCase("x_stag")) {
            return AxisType.GeoX;
        }
        if (vname.equalsIgnoreCase("lon")) {
            return AxisType.Lon;
        }
        if (vname.equalsIgnoreCase("y") || vname.equalsIgnoreCase("y_stag")) {
            return AxisType.GeoY;
        }
        if (vname.equalsIgnoreCase("lat")) {
            return AxisType.Lat;
        }
        if (vname.equalsIgnoreCase("z") || vname.equalsIgnoreCase("z_stag")) {
            return AxisType.GeoZ;
        }
        if (vname.equalsIgnoreCase("Z")) {
            return AxisType.Height;
        }
        if (vname.equalsIgnoreCase("time") || vname.equalsIgnoreCase("times")) {
            return AxisType.Time;
        }
        String unit = v.getUnits();
        if (unit != null) {
            if (SimpleUnit.isCompatible("millibar", unit)) {
                return AxisType.Pressure;
            }
            if (SimpleUnit.isCompatible("m", unit)) {
                return AxisType.Height;
            }
        }
        return null;
    }

    public String getZisPositive(CoordinateAxis v) {
        return "down";
    }

    @Nullable
    private CoordinateAxis.Builder makeLonCoordAxis(String axisName, Dimension dim) {
        if (dim == null) {
            return null;
        }
        double dx = 4.0 * this.findAttributeDouble("DX");
        int nx = dim.getLength();
        double startx = this.centerX - dx * (double)(nx - 1) / 2.0;
        CoordinateAxis.Builder v = (CoordinateAxis.Builder)((CoordinateAxis1D.Builder)((CoordinateAxis1D.Builder)((CoordinateAxis1D.Builder)((CoordinateAxis1D.Builder)CoordinateAxis1D.builder().setName(axisName)).setDataType(DataType.DOUBLE)).setDimensionsByName(dim.getShortName())).setUnits("degrees_east")).setDesc("synthesized longitude coordinate");
        v.setAutoGen(startx, dx);
        v.setAxisType(AxisType.Lon);
        v.addAttribute(new Attribute("_CoordinateAxisType", "Lon"));
        if (!axisName.equals(dim.getShortName())) {
            v.addAttribute(new Attribute("_CoordinateAliasForDimension", dim.getShortName()));
        }
        return v;
    }

    @Nullable
    private CoordinateAxis.Builder makeLatCoordAxis(String axisName, Dimension dim) {
        if (dim == null) {
            return null;
        }
        double dy = this.findAttributeDouble("DY");
        int ny = dim.getLength();
        double starty = this.centerY - dy * (double)(ny - 1) / 2.0;
        CoordinateAxis.Builder v = (CoordinateAxis.Builder)((CoordinateAxis1D.Builder)((CoordinateAxis1D.Builder)((CoordinateAxis1D.Builder)((CoordinateAxis1D.Builder)CoordinateAxis1D.builder().setName(axisName)).setDataType(DataType.DOUBLE)).setDimensionsByName(dim.getShortName())).setUnits("degrees_north")).setDesc("synthesized latitude coordinate");
        v.setAutoGen(starty, dy);
        v.setAxisType(AxisType.Lat);
        v.addAttribute(new Attribute("_CoordinateAxisType", "Lat"));
        if (!axisName.equals(dim.getShortName())) {
            v.addAttribute(new Attribute("_CoordinateAliasForDimension", dim.getShortName()));
        }
        return v;
    }

    @Nullable
    private CoordinateAxis.Builder makeXCoordAxis(String axisName, String dimName) {
        Optional<Dimension> dimOpt = this.rootGroup.findDimension(dimName);
        if (!dimOpt.isPresent()) {
            return null;
        }
        Dimension dim = dimOpt.get();
        double dx = this.findAttributeDouble("DX") / 1000.0;
        int nx = dim.getLength();
        double startx = this.centerX - dx * (double)(nx - 1) / 2.0;
        CoordinateAxis.Builder v = (CoordinateAxis.Builder)((CoordinateAxis1D.Builder)((CoordinateAxis1D.Builder)((CoordinateAxis1D.Builder)((CoordinateAxis1D.Builder)((CoordinateAxis1D.Builder)CoordinateAxis1D.builder().setName(axisName)).setDataType(DataType.DOUBLE)).setParentGroupBuilder(this.rootGroup)).setDimensionsByName(dim.getShortName())).setUnits("km")).setDesc("synthesized GeoX coordinate from DX attribute");
        v.setAutoGen(startx, dx);
        v.setAxisType(AxisType.GeoX);
        v.addAttribute(new Attribute("_CoordinateAxisType", "GeoX"));
        if (!axisName.equals(dim.getShortName())) {
            v.addAttribute(new Attribute("_CoordinateAliasForDimension", dim.getShortName()));
        }
        if (this.gridE) {
            v.addAttribute(new Attribute("_CoordinateStagger", "Arakawa-E"));
        }
        return v;
    }

    @Nullable
    private CoordinateAxis.Builder makeYCoordAxis(String axisName, String dimName) {
        Optional<Dimension> dimOpt = this.rootGroup.findDimension(dimName);
        if (!dimOpt.isPresent()) {
            return null;
        }
        Dimension dim = dimOpt.get();
        double dy = this.findAttributeDouble("DY") / 1000.0;
        int ny = dim.getLength();
        double starty = this.centerY - dy * (double)(ny - 1) / 2.0;
        CoordinateAxis.Builder v = (CoordinateAxis.Builder)((CoordinateAxis1D.Builder)((CoordinateAxis1D.Builder)((CoordinateAxis1D.Builder)((CoordinateAxis1D.Builder)((CoordinateAxis1D.Builder)CoordinateAxis1D.builder().setName(axisName)).setDataType(DataType.DOUBLE)).setParentGroupBuilder(this.rootGroup)).setDimensionsByName(dim.getShortName())).setUnits("km")).setDesc("synthesized GeoY coordinate from DY attribute");
        v.setAxisType(AxisType.GeoY);
        v.addAttribute(new Attribute("_CoordinateAxisType", "GeoY"));
        v.setAutoGen(starty, dy);
        if (!axisName.equals(dim.getShortName())) {
            v.addAttribute(new Attribute("_CoordinateAliasForDimension", dim.getShortName()));
        }
        if (this.gridE) {
            v.addAttribute(new Attribute("_CoordinateStagger", "Arakawa-E"));
        }
        return v;
    }

    @Nullable
    private CoordinateAxis.Builder makeZCoordAxis(String axisName, String dimName) {
        Optional<Variable.Builder<?>> etaVarOpt;
        Optional<Dimension> dimOpt = this.rootGroup.findDimension(dimName);
        if (!dimOpt.isPresent()) {
            return null;
        }
        Dimension dim = dimOpt.get();
        String fromWhere = axisName.endsWith("stag") ? "ZNW" : "ZNU";
        CoordinateAxis.Builder v = (CoordinateAxis.Builder)((CoordinateAxis1D.Builder)((CoordinateAxis1D.Builder)((CoordinateAxis1D.Builder)((CoordinateAxis1D.Builder)((CoordinateAxis1D.Builder)CoordinateAxis1D.builder().setName(axisName)).setDataType(DataType.DOUBLE)).setParentGroupBuilder(this.rootGroup)).setDimensionsByName(dim.getShortName())).setUnits("")).setDesc("eta values from variable " + fromWhere);
        v.addAttribute(new Attribute("positive", "down"));
        v.setAxisType(AxisType.GeoZ);
        v.addAttribute(new Attribute("_CoordinateAxisType", "GeoZ"));
        if (!axisName.equals(dim.getShortName())) {
            v.addAttribute(new Attribute("_CoordinateAliasForDimension", dim.getShortName()));
        }
        if (!(etaVarOpt = this.rootGroup.findVariableLocal(fromWhere)).isPresent()) {
            return this.makeFakeCoordAxis(axisName, dim);
        }
        VariableDS.Builder etaVarDS = (VariableDS.Builder)etaVarOpt.get();
        Variable etaVar = etaVarDS.orgVar;
        int n = etaVar.getShape(1);
        int[] origin = new int[]{0, 0};
        int[] shape = new int[]{1, n};
        try {
            Array array = etaVar.read(origin, shape);
            ArrayDouble.D1 newArray = new ArrayDouble.D1(n);
            IndexIterator it = array.getIndexIterator();
            int count = 0;
            while (it.hasNext()) {
                double d = it.getDoubleNext();
                newArray.set(count++, d);
            }
            v.setCachedData(newArray, true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return v;
    }

    @Nullable
    private CoordinateAxis.Builder makeFakeCoordAxis(String axisName, Dimension dim) {
        if (dim == null) {
            return null;
        }
        CoordinateAxis.Builder v = (CoordinateAxis.Builder)((CoordinateAxis1D.Builder)((CoordinateAxis1D.Builder)((CoordinateAxis1D.Builder)((CoordinateAxis1D.Builder)((CoordinateAxis1D.Builder)CoordinateAxis1D.builder().setName(axisName)).setDataType(DataType.SHORT)).setParentGroupBuilder(this.rootGroup)).setDimensionsByName(dim.getShortName())).setUnits("")).setDesc("synthesized coordinate: only an index");
        v.setAxisType(AxisType.GeoZ);
        v.addAttribute(new Attribute("_CoordinateAxisType", "GeoZ"));
        if (!axisName.equals(dim.getShortName())) {
            v.addAttribute(new Attribute("_CoordinateAliasForDimension", dim.getShortName()));
        }
        v.setAutoGen(0.0, 1.0);
        return v;
    }

    @Nullable
    private CoordinateAxis.Builder<?> makeTimeCoordAxis(String axisName, String dimName) {
        Object iter;
        Array timeData;
        Optional<Dimension> dimOpt = this.rootGroup.findDimension(dimName);
        if (!dimOpt.isPresent()) {
            return null;
        }
        Dimension dim = dimOpt.get();
        int nt = dim.getLength();
        Optional<Variable.Builder<?>> timeOpt = this.rootGroup.findVariableLocal("Times");
        if (!timeOpt.isPresent()) {
            return null;
        }
        Variable timeV = ((VariableDS.Builder)timeOpt.get()).orgVar;
        try {
            timeData = timeV.read();
        }
        catch (IOException ioe) {
            return null;
        }
        ArrayDouble.D1 values = new ArrayDouble.D1(nt);
        int count = 0;
        if (timeData instanceof ArrayChar) {
            iter = ((ArrayChar)timeData).getStringIterator();
            String testTimeStr = ((ArrayChar)timeData).getString(0);
            boolean isCanonicalIsoStr = true;
            String wrfDateWithUnderscore = "([\\-\\d]{10})_";
            Pattern wrfDateWithUnderscorePattern = Pattern.compile((String)wrfDateWithUnderscore);
            Matcher m = wrfDateWithUnderscorePattern.matcher((CharSequence)testTimeStr);
            isCanonicalIsoStr = m.matches();
            while (((ArrayChar.StringIterator)iter).hasNext()) {
                String dateS = ((ArrayChar.StringIterator)iter).next();
                try {
                    CalendarDate cd = isCanonicalIsoStr ? CalendarDateFormatter.isoStringToCalendarDate(null, dateS) : CalendarDateFormatter.isoStringToCalendarDate(null, dateS.replaceFirst("_", "T"));
                    values.set(count++, (double)cd.getMillis() / 1000.0);
                }
                catch (IllegalArgumentException e) {
                    this.parseInfo.format("ERROR: cant parse Time string = <%s> err= %s%n", dateS, e.getMessage());
                    String startAtt = this.rootGroup.getAttributeContainer().findAttributeString("START_DATE", null);
                    if (nt != 1 || null == startAtt) continue;
                    try {
                        CalendarDate cd = CalendarDateFormatter.isoStringToCalendarDate(null, startAtt);
                        values.set(0, (double)cd.getMillis() / 1000.0);
                    }
                    catch (IllegalArgumentException e2) {
                        this.parseInfo.format("ERROR: cant parse global attribute START_DATE = <%s> err=%s%n", startAtt, e2.getMessage());
                    }
                }
            }
        } else {
            iter = timeData.getIndexIterator();
            while (iter.hasNext()) {
                String dateS = (String)iter.next();
                try {
                    CalendarDate cd = CalendarDateFormatter.isoStringToCalendarDate(null, dateS);
                    values.set(count++, (double)cd.getMillis() / 1000.0);
                }
                catch (IllegalArgumentException e) {
                    this.parseInfo.format("ERROR: cant parse Time string = %s%n", dateS);
                }
            }
        }
        CoordinateAxis.Builder v = (CoordinateAxis.Builder)((CoordinateAxis1D.Builder)((CoordinateAxis1D.Builder)((CoordinateAxis1D.Builder)((CoordinateAxis1D.Builder)((CoordinateAxis1D.Builder)CoordinateAxis1D.builder().setName(axisName)).setDataType(DataType.DOUBLE)).setParentGroupBuilder(this.rootGroup)).setDimensionsByName(dim.getShortName())).setUnits("secs since 1970-01-01 00:00:00")).setDesc("synthesized time coordinate from Times(time)");
        v.setAxisType(AxisType.Time);
        v.addAttribute(new Attribute("_CoordinateAxisType", "Time"));
        if (!axisName.equals(dim.getShortName())) {
            v.addAttribute(new Attribute("_CoordinateAliasForDimension", dim.getShortName()));
        }
        v.setCachedData(values, true);
        return v;
    }

    @Nullable
    private CoordinateAxis.Builder makeSoilDepthCoordAxis(String coordVarName) {
        Optional<Variable.Builder<?>> varOpt = this.rootGroup.findVariableLocal(coordVarName);
        if (!varOpt.isPresent()) {
            return null;
        }
        VariableDS.Builder coordVarB = (VariableDS.Builder)varOpt.get();
        Variable coordVar = coordVarB.orgVar;
        Dimension soilDim = null;
        ImmutableList<Dimension> dims = coordVar.getDimensions();
        for (Dimension d : dims) {
            if (!d.getShortName().startsWith("soil_layers")) continue;
            soilDim = d;
        }
        if (null == soilDim) {
            return null;
        }
        if (coordVar.getRank() == 1) {
            coordVarB.addAttribute(new Attribute("positive", "down"));
            coordVarB.addAttribute(new Attribute("_CoordinateAxisType", "GeoZ"));
            if (!coordVarName.equals(soilDim.getShortName())) {
                coordVarB.addAttribute(new Attribute("_CoordinateAliasForDimension", soilDim.getShortName()));
            }
            return CoordinateAxis.fromVariableDS(coordVarB);
        }
        String units = coordVar.attributes().findAttributeString("units", "");
        CoordinateAxis.Builder v = (CoordinateAxis.Builder)((CoordinateAxis1D.Builder)((CoordinateAxis1D.Builder)((CoordinateAxis1D.Builder)((CoordinateAxis1D.Builder)((CoordinateAxis1D.Builder)CoordinateAxis1D.builder().setName("soilDepth")).setDataType(DataType.DOUBLE)).setParentGroupBuilder(this.rootGroup)).setDimensionsByName(soilDim.getShortName())).setUnits(units)).setDesc("soil depth");
        v.addAttribute(new Attribute("positive", "down"));
        v.setAxisType(AxisType.GeoZ);
        v.addAttribute(new Attribute("_CoordinateAxisType", "GeoZ"));
        v.setUnits("units");
        if (!v.shortName.equals(soilDim.getShortName())) {
            v.addAttribute(new Attribute("_CoordinateAliasForDimension", soilDim.getShortName()));
        }
        int n = coordVar.getShape(1);
        int[] origin = new int[]{0, 0};
        int[] shape = new int[]{1, n};
        try {
            Array array = coordVar.read(origin, shape);
            ArrayDouble.D1 newArray = new ArrayDouble.D1(n);
            IndexIterator it = array.getIndexIterator();
            int count = 0;
            while (it.hasNext()) {
                double d = it.getDoubleNext();
                newArray.set(count++, d);
            }
            v.setCachedData(newArray, true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return v;
    }

    private double findAttributeDouble(String attname) {
        return this.rootGroup.getAttributeContainer().findAttributeDouble(attname, Double.NaN);
    }

    @Override
    protected void assignCoordinateTransforms() {
        super.assignCoordinateTransforms();
        if (this.rootGroup.findVariableLocal("PH").isPresent() && this.rootGroup.findVariableLocal("PHB").isPresent() && this.rootGroup.findVariableLocal("P").isPresent() && this.rootGroup.findVariableLocal("PB").isPresent()) {
            for (CoordinateSystem.Builder cs : this.coords.coordSys) {
                this.coords.findAxisByType(cs, AxisType.GeoZ).ifPresent(axis -> {
                    String units = axis.getUnits();
                    if (units == null || units.trim().isEmpty()) {
                        WRFEtaTransformBuilder vctb = new WRFEtaTransformBuilder(this.coords, cs);
                        this.coords.addVerticalCTBuilder(vctb);
                        cs.addCoordinateTransformByName(vctb.getTransformName());
                        this.parseInfo.format("***Added WRFEtaTransformBuilderto '%s'%n", cs.coordAxesNames);
                    }
                });
            }
        }
    }

    public static class Factory
    implements CoordSystemBuilderFactory {
        @Override
        public String getConventionName() {
            return WRFConvention.CONVENTION_NAME;
        }

        @Override
        public boolean isMine(NetcdfFile ncfile) {
            if (null == ncfile.findDimension("south_north")) {
                return false;
            }
            int dynOpt = ncfile.getRootGroup().attributes().findAttributeInteger("DYN_OPT", -1);
            if (dynOpt != -1 && dynOpt != 2) {
                return false;
            }
            String gridType = ncfile.getRootGroup().findAttributeString("GRIDTYPE", "null");
            if (!(gridType.equalsIgnoreCase("null") || gridType.equalsIgnoreCase("C") || gridType.equalsIgnoreCase("E"))) {
                return false;
            }
            return ncfile.findGlobalAttribute("MAP_PROJ") != null;
        }

        @Override
        public CoordSystemBuilder open(NetcdfDataset.Builder datasetBuilder) {
            return new WRFConvention(datasetBuilder);
        }
    }
}

