/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.util.reflect;

import java.io.PrintStream;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;

public class PublicInterfaceGenerator {
    static void generate(Class c, boolean doAllMethods, PrintStream out) throws SecurityException {
        Class sc = c.getSuperclass();
        out.print("public class " + PublicInterfaceGenerator.makeClassName(c));
        if (sc != Object.class) {
            out.print(" extends " + PublicInterfaceGenerator.makeClassName(sc));
        }
        out.println(" {");
        ArrayList allMethods = new ArrayList();
        PublicInterfaceGenerator.addAllMethods(allMethods, c, doAllMethods);
        allMethods.sort(new MethodComparator());
        for (Object allMethod : allMethods) {
            PublicInterfaceGenerator.genMethod((Method)allMethod, out);
        }
        out.println("}");
    }

    private static void addAllMethods(ArrayList allMethods, Class c, boolean doAllMethods) {
        if (c == null) {
            return;
        }
        if (c == Object.class) {
            return;
        }
        Method[] methodsArray = doAllMethods ? c.getMethods() : c.getDeclaredMethods();
        allMethods.addAll(Arrays.asList(methodsArray));
    }

    static void genMethod(Method m, PrintStream out) throws SecurityException {
        int mods = m.getModifiers();
        if (Modifier.isPrivate(mods) || Modifier.isProtected(mods)) {
            return;
        }
        out.print("  " + Modifier.toString(mods));
        out.print(" " + PublicInterfaceGenerator.makeClassName(m.getReturnType()));
        out.print(" " + m.getName() + "(");
        Class<?>[] params = m.getParameterTypes();
        for (int i = 0; i < params.length; ++i) {
            if (i > 0) {
                out.print(", ");
            }
            out.print(PublicInterfaceGenerator.makeClassName(params[i]) + " p" + i);
        }
        out.print(")");
        Class<?>[] ex = m.getExceptionTypes();
        if (ex.length > 0) {
            out.print(" throws ");
            for (int i = 0; i < ex.length; ++i) {
                if (i > 0) {
                    out.print(", ");
                }
                out.print(ex[i].getName());
            }
        }
        out.println(";");
    }

    static String makeClassName(Class c) {
        if (c.isArray()) {
            return PublicInterfaceGenerator.makeClassName(c.getComponentType()) + "[]";
        }
        String name = c.getName();
        Package p = c.getPackage();
        if (p == null) {
            return name;
        }
        String packageName = p.getName();
        return name.substring(packageName.length() + 1);
    }

    public static void showMethods(Class c, PrintStream out) {
        Method[] methodsArray;
        out.println("Methods for class " + c.getName());
        for (Method m : methodsArray = c.getDeclaredMethods()) {
            System.out.println(" " + m.getName());
        }
    }

    public static class MethodComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            Method t1 = (Method)o1;
            Method t2 = (Method)o2;
            return t1.getName().compareTo(t2.getName());
        }

        @Override
        public boolean equals(Object obj) {
            return obj == this;
        }
    }
}

