/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.convert;

import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.scijava.convert.AbstractConverter;
import org.scijava.convert.ConvertService;
import org.scijava.convert.Converter;
import org.scijava.parse.Item;
import org.scijava.parse.Items;
import org.scijava.parse.ParseService;
import org.scijava.parsington.Token;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.util.Types;

@Plugin(type=Converter.class, priority=-10000.0)
public class StringToArrayConverter
extends AbstractConverter<String, Object> {
    @Parameter(required=false)
    private ConvertService convertService;
    @Parameter(required=false)
    private ParseService parseService;

    @Override
    public boolean canConvert(Object src, Type dest) {
        return this.canConvert(src, Types.raw(dest));
    }

    @Override
    public boolean canConvert(Object src, Class<?> dest) {
        if (this.convertService == null || this.parseService == null) {
            return false;
        }
        if (!this.canConvert(src.getClass(), dest)) {
            return false;
        }
        try {
            this.parseService.parse((String)src, false);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        return true;
    }

    @Override
    public boolean canConvert(Class<?> src, Class<?> dest) {
        return src == String.class && dest.isArray();
    }

    @Override
    public Object convert(Object src, Type dest) {
        Type componentType = Types.component(dest);
        if (componentType == null) {
            throw new IllegalArgumentException(dest + " is not an array type!");
        }
        List<?> items = this.parse((String)src);
        return this.convertToArray(items, Types.raw(componentType));
    }

    @Override
    public <T> T convert(Object src, Class<T> dest) {
        Class<T> destType = dest;
        Object result = this.convert(src, (Type)destType);
        return (T)result;
    }

    @Override
    public Class<Object> getOutputType() {
        return Object.class;
    }

    @Override
    public Class<String> getInputType() {
        return String.class;
    }

    private Object convertToArray(List<?> tree, Class<?> componentType) {
        Object array = Array.newInstance(componentType, tree.size());
        for (int i = 0; i < tree.size(); ++i) {
            Object element = tree.get(i);
            Object converted = this.convertService.convert(element, componentType);
            Array.set(array, i, converted);
        }
        return array;
    }

    private List<?> parse(String s) {
        try {
            Items items = this.parseService.parse(s, false);
            return (List)this.unwrap(items);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    private Object unwrap(Object o) {
        if (o instanceof Collection) {
            return ((Collection)o).stream().map(item -> this.unwrap(item)).collect(Collectors.toList());
        }
        if (o instanceof Item) {
            return this.unwrap(((Item)o).value());
        }
        if (o instanceof Token) {
            return ((Token)o).getToken();
        }
        return o;
    }
}

