/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ui;

import java.lang.reflect.InvocationTargetException;
import org.scijava.log.LogService;
import org.scijava.plugin.Parameter;
import org.scijava.thread.ThreadService;
import org.scijava.ui.UIService;
import org.scijava.ui.UserInterface;
import org.scijava.widget.AbstractInputWidget;

public abstract class AbstractUIInputWidget<T, W>
extends AbstractInputWidget<T, W> {
    @Parameter
    private ThreadService threadService;
    @Parameter
    private UIService uiService;
    @Parameter
    private LogService log;

    @Override
    public void refreshWidget() {
        if (this.ui().requiresEDT()) {
            try {
                this.threadService.invoke(() -> this.doRefresh());
            }
            catch (InterruptedException e) {
                this.log.error("Interrupted while refresh widget: " + this.getClass(), e);
            }
            catch (InvocationTargetException e) {
                this.log.error("Failed to refresh widget: " + this.getClass() + " on EDT", e);
            }
        } else {
            this.doRefresh();
        }
    }

    protected abstract void doRefresh();

    protected abstract UserInterface ui();

    protected UserInterface ui(String uiName) {
        return this.uiService.getUI(uiName);
    }
}

