/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.dsp;

import edu.mines.jtk.dsp.Eigen;
import edu.mines.jtk.dsp.Tensors3;
import edu.mines.jtk.io.ArrayInputStream;
import edu.mines.jtk.io.ArrayOutputStream;
import edu.mines.jtk.util.ArrayMath;
import edu.mines.jtk.util.UnitSphereSampling;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class EigenTensors3
implements Tensors3,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final float AS_SET = 32767.0f;
    private static final float AS_GET = 3.051851E-5f;
    private static UnitSphereSampling _uss;
    private boolean _compressed;
    private int _n1;
    private int _n2;
    private int _n3;
    private float[][][] _as;
    private short[][][] _bu;
    private short[][][] _bw;
    private short[][][] _iu;
    private short[][][] _iw;
    private float[][][] _au;
    private float[][][] _aw;
    private float[][][] _u1;
    private float[][][] _u2;
    private float[][][] _w1;
    private float[][][] _w2;

    public EigenTensors3(int n1, int n2, int n3, boolean compressed) {
        this._n1 = n1;
        this._n2 = n2;
        this._n3 = n3;
        this._compressed = compressed;
        if (compressed) {
            this._bu = new short[n3][n2][n1];
            this._bw = new short[n3][n2][n1];
            this._iu = new short[n3][n2][n1];
            this._iw = new short[n3][n2][n1];
            if (_uss == null) {
                _uss = new UnitSphereSampling(16);
            }
        } else {
            this._au = new float[n3][n2][n1];
            this._aw = new float[n3][n2][n1];
            this._u1 = new float[n3][n2][n1];
            this._u2 = new float[n3][n2][n1];
            this._w1 = new float[n3][n2][n1];
            this._w2 = new float[n3][n2][n1];
        }
        this._as = new float[n3][n2][n1];
    }

    public EigenTensors3(float[][][] u1, float[][][] u2, float[][][] w1, float[][][] w2, float[][][] au, float[][][] av, float[][][] aw, boolean compressed) {
        this(u1[0][0].length, u1[0].length, u1.length, compressed);
        for (int i3 = 0; i3 < this._n3; ++i3) {
            for (int i2 = 0; i2 < this._n2; ++i2) {
                for (int i1 = 0; i1 < this._n1; ++i1) {
                    float aui = au[i3][i2][i1];
                    float avi = av[i3][i2][i1];
                    float awi = aw[i3][i2][i1];
                    float u1i = u1[i3][i2][i1];
                    float u2i = u2[i3][i2][i1];
                    float u3i = EigenTensors3.c3(u1i, u2i);
                    float w1i = w1[i3][i2][i1];
                    float w2i = w2[i3][i2][i1];
                    float w3i = EigenTensors3.c3(w1i, w2i);
                    this.setEigenvalues(i1, i2, i3, aui, avi, awi);
                    this.setEigenvectorU(i1, i2, i3, u1i, u2i, u3i);
                    this.setEigenvectorW(i1, i2, i3, w1i, w2i, w3i);
                }
            }
        }
    }

    public EigenTensors3(EigenTensors3 t) {
        this(t._n1, t._n2, t._n3, t._compressed);
        float[] a = new float[3];
        float[] u = new float[3];
        float[] w = new float[3];
        for (int i3 = 0; i3 < this._n3; ++i3) {
            for (int i2 = 0; i2 < this._n2; ++i2) {
                for (int i1 = 0; i1 < this._n1; ++i1) {
                    t.getEigenvalues(i1, i2, i3, a);
                    t.getEigenvectorU(i1, i2, i3, u);
                    t.getEigenvectorW(i1, i2, i3, w);
                    this.setEigenvalues(i1, i2, i3, a);
                    this.setEigenvectorU(i1, i2, i3, u);
                    this.setEigenvectorW(i1, i2, i3, w);
                }
            }
        }
    }

    public int getN1() {
        return this._n1;
    }

    public int getN2() {
        return this._n2;
    }

    public int getN3() {
        return this._n3;
    }

    @Override
    public void getTensor(int i1, int i2, int i3, float[] a) {
        float w3;
        float w2;
        float w1;
        float u3;
        float u2;
        float u1;
        float aw;
        float au;
        float asum = this._as[i3][i2][i1];
        if (this._compressed) {
            float ascale = asum * 3.051851E-5f;
            au = ascale * (float)this._bu[i3][i2][i1];
            aw = ascale * (float)this._bw[i3][i2][i1];
            float[] u = _uss.getPoint(this._iu[i3][i2][i1]);
            u1 = u[0];
            u2 = u[1];
            u3 = u[2];
            float[] w = _uss.getPoint(this._iw[i3][i2][i1]);
            w1 = w[0];
            w2 = w[1];
            w3 = w[2];
        } else {
            au = this._au[i3][i2][i1];
            aw = this._aw[i3][i2][i1];
            u1 = this._u1[i3][i2][i1];
            u2 = this._u2[i3][i2][i1];
            u3 = EigenTensors3.c3(u1, u2);
            w1 = this._w1[i3][i2][i1];
            w2 = this._w2[i3][i2][i1];
            w3 = EigenTensors3.c3(w1, w2);
        }
        float av = asum - au - aw;
        a[0] = (au -= av) * u1 * u1 + (aw -= av) * w1 * w1 + av;
        a[1] = au * u1 * u2 + aw * w1 * w2;
        a[2] = au * u1 * u3 + aw * w1 * w3;
        a[3] = au * u2 * u2 + aw * w2 * w2 + av;
        a[4] = au * u2 * u3 + aw * w2 * w3;
        a[5] = au * u3 * u3 + aw * w3 * w3 + av;
    }

    public float[] getTensor(int i1, int i2, int i3) {
        float[] a = new float[6];
        this.getTensor(i1, i2, i3, a);
        return a;
    }

    public void getEigenvalues(int i1, int i2, int i3, float[] a) {
        float aw;
        float au;
        float asum = this._as[i3][i2][i1];
        if (this._compressed) {
            float ascale = asum * 3.051851E-5f;
            au = ascale * (float)this._bu[i3][i2][i1];
            aw = ascale * (float)this._bw[i3][i2][i1];
        } else {
            au = this._au[i3][i2][i1];
            aw = this._aw[i3][i2][i1];
        }
        a[0] = au;
        a[1] = asum - au - aw;
        a[2] = aw;
    }

    public float[] getEigenvalues(int i1, int i2, int i3) {
        float[] a = new float[3];
        this.getEigenvalues(i1, i2, i3, a);
        return a;
    }

    public void getEigenvalues(float[][][] au, float[][][] av, float[][][] aw) {
        float[] auvw = new float[3];
        for (int i3 = 0; i3 < this._n3; ++i3) {
            for (int i2 = 0; i2 < this._n2; ++i2) {
                for (int i1 = 0; i1 < this._n1; ++i1) {
                    this.getEigenvalues(i1, i2, i3, auvw);
                    au[i3][i2][i1] = auvw[0];
                    av[i3][i2][i1] = auvw[1];
                    aw[i3][i2][i1] = auvw[2];
                }
            }
        }
    }

    public void getEigenvectorU(int i1, int i2, int i3, float[] u) {
        if (this._compressed) {
            float[] ui = _uss.getPoint(this._iu[i3][i2][i1]);
            u[0] = ui[0];
            u[1] = ui[1];
            u[2] = ui[2];
        } else {
            u[0] = this._u1[i3][i2][i1];
            u[1] = this._u2[i3][i2][i1];
            u[2] = EigenTensors3.c3(u[0], u[1]);
        }
    }

    public float[] getEigenvectorU(int i1, int i2, int i3) {
        float[] u = new float[3];
        this.getEigenvectorU(i1, i2, i3, u);
        return u;
    }

    public void getEigenvectorV(int i1, int i2, int i3, float[] v) {
        float[] u = this.getEigenvectorU(i1, i2, i3);
        float[] w = this.getEigenvectorW(i1, i2, i3);
        v[0] = w[1] * u[2] - w[2] * u[1];
        v[1] = w[2] * u[0] - w[0] * u[2];
        v[2] = w[0] * u[1] - w[1] * u[0];
    }

    public float[] getEigenvectorV(int i1, int i2, int i3) {
        float[] v = new float[3];
        this.getEigenvectorV(i1, i2, i3, v);
        return v;
    }

    public void getEigenvectorW(int i1, int i2, int i3, float[] w) {
        if (this._compressed) {
            float[] wi = _uss.getPoint(this._iw[i3][i2][i1]);
            w[0] = wi[0];
            w[1] = wi[1];
            w[2] = wi[2];
        } else {
            w[0] = this._w1[i3][i2][i1];
            w[1] = this._w2[i3][i2][i1];
            w[2] = EigenTensors3.c3(w[0], w[1]);
        }
    }

    public float[] getEigenvectorW(int i1, int i2, int i3) {
        float[] w = new float[3];
        this.getEigenvectorW(i1, i2, i3, w);
        return w;
    }

    public void setTensor(int i1, int i2, int i3, float[] a) {
        this.setTensor(i1, i2, i3, a[0], a[1], a[2], a[3], a[4], a[5]);
    }

    public void setTensor(int i1, int i2, int i3, float a11, float a12, float a13, float a22, float a23, float a33) {
        float aw;
        float av;
        double[][] aa = new double[][]{{a11, a12, a13}, {a12, a22, a23}, {a13, a23, a33}};
        double[][] vv = new double[3][3];
        double[] ev = new double[3];
        Eigen.solveSymmetric33(aa, vv, ev);
        double[] u = vv[0];
        double[] w = vv[2];
        float u1 = (float)u[0];
        float u2 = (float)u[1];
        float u3 = (float)u[2];
        float w1 = (float)w[0];
        float w2 = (float)w[1];
        float w3 = (float)w[2];
        float au = (float)ev[0];
        if (au < 0.0f) {
            au = 0.0f;
        }
        if ((av = (float)ev[1]) < 0.0f) {
            av = 0.0f;
        }
        if ((aw = (float)ev[2]) < 0.0f) {
            aw = 0.0f;
        }
        this.setEigenvectorU(i1, i2, i3, u1, u2, u3);
        this.setEigenvectorW(i1, i2, i3, w1, w2, w3);
        this.setEigenvalues(i1, i2, i3, au, av, aw);
    }

    public void setEigenvalues(float au, float av, float aw) {
        float as = au + av + aw;
        if (this._compressed) {
            float ascale = as > 0.0f ? 32767.0f / as : 0.0f;
            short bu = (short)(au * ascale + 0.5f);
            short bw = (short)(aw * ascale + 0.5f);
            ArrayMath.fill(bu, this._bu);
            ArrayMath.fill(bw, this._bw);
        } else {
            ArrayMath.fill(au, this._au);
            ArrayMath.fill(aw, this._aw);
        }
        ArrayMath.fill(as, this._as);
    }

    public void setEigenvalues(float[][][] au, float[][][] av, float[][][] aw) {
        for (int i3 = 0; i3 < this._n3; ++i3) {
            for (int i2 = 0; i2 < this._n2; ++i2) {
                for (int i1 = 0; i1 < this._n1; ++i1) {
                    float aui = au[i3][i2][i1];
                    float avi = av[i3][i2][i1];
                    float awi = aw[i3][i2][i1];
                    this.setEigenvalues(i1, i2, i3, aui, avi, awi);
                }
            }
        }
    }

    public void setEigenvalues(int i1, int i2, int i3, float au, float av, float aw) {
        float asum = au + av + aw;
        if (this._compressed) {
            float ascale = asum > 0.0f ? 32767.0f / asum : 0.0f;
            this._bu[i3][i2][i1] = (short)(au * ascale + 0.5f);
            this._bw[i3][i2][i1] = (short)(aw * ascale + 0.5f);
        } else {
            this._au[i3][i2][i1] = au;
            this._aw[i3][i2][i1] = aw;
        }
        this._as[i3][i2][i1] = asum;
    }

    public void setEigenvalues(int i1, int i2, int i3, float[] a) {
        this.setEigenvalues(i1, i2, i3, a[0], a[1], a[2]);
    }

    public void setEigenvectorU(int i1, int i2, int i3, float u1, float u2, float u3) {
        if (u3 < 0.0f) {
            u1 = -u1;
            u2 = -u2;
            u3 = -u3;
        }
        if (this._compressed) {
            this._iu[i3][i2][i1] = (short)_uss.getIndex(u1, u2, u3);
        } else {
            this._u1[i3][i2][i1] = u1;
            this._u2[i3][i2][i1] = u2;
        }
    }

    public void setEigenvectorU(int i1, int i2, int i3, float[] u) {
        this.setEigenvectorU(i1, i2, i3, u[0], u[1], u[2]);
    }

    public void setEigenvectorW(int i1, int i2, int i3, float w1, float w2, float w3) {
        if (w3 < 0.0f) {
            w1 = -w1;
            w2 = -w2;
            w3 = -w3;
        }
        if (this._compressed) {
            this._iw[i3][i2][i1] = (short)_uss.getIndex(w1, w2, w3);
        } else {
            this._w1[i3][i2][i1] = w1;
            this._w2[i3][i2][i1] = w2;
        }
    }

    public void setEigenvectorW(int i1, int i2, int i3, float[] w) {
        this.setEigenvectorW(i1, i2, i3, w[0], w[1], w[2]);
    }

    public void scale(float[][][] s) {
        float[] a = new float[3];
        for (int i3 = 0; i3 < this._n3; ++i3) {
            for (int i2 = 0; i2 < this._n2; ++i2) {
                for (int i1 = 0; i1 < this._n1; ++i1) {
                    float si = s[i3][i2][i1];
                    this.getEigenvalues(i1, i2, i3, a);
                    a[0] = a[0] * si;
                    a[1] = a[1] * si;
                    a[2] = a[2] * si;
                    this.setEigenvalues(i1, i2, i3, a);
                }
            }
        }
    }

    public void invert() {
        float[] a = new float[3];
        for (int i3 = 0; i3 < this._n3; ++i3) {
            for (int i2 = 0; i2 < this._n2; ++i2) {
                for (int i1 = 0; i1 < this._n1; ++i1) {
                    this.getEigenvalues(i1, i2, i3, a);
                    a[0] = 1.0f / a[0];
                    a[1] = 1.0f / a[1];
                    a[2] = 1.0f / a[2];
                    this.setEigenvalues(i1, i2, i3, a);
                }
            }
        }
    }

    public void invertStructure(double p0, double p1, double p2) {
        float[] a = new float[3];
        float amax = 0.0f;
        float amin = Float.MAX_VALUE;
        for (int i3 = 0; i3 < this._n3; ++i3) {
            for (int i2 = 0; i2 < this._n2; ++i2) {
                for (int i1 = 0; i1 < this._n1; ++i1) {
                    this.getEigenvalues(i1, i2, i3, a);
                    float aui = a[0];
                    float avi = a[1];
                    float awi = a[2];
                    if (awi < 0.0f) {
                        awi = 0.0f;
                    }
                    if (avi < awi) {
                        avi = awi;
                    }
                    if (aui < avi) {
                        aui = avi;
                    }
                    if (awi < amin) {
                        amin = awi;
                    }
                    if (aui > amax) {
                        amax = aui;
                    }
                    this.setEigenvalues(i1, i2, i3, aui, avi, awi);
                }
            }
        }
        float aeps = ArrayMath.max(1.4E-43f, 1.1920929E-7f * amax);
        amin += aeps;
        amax += aeps;
        float fp0 = (float)p0;
        float fp1 = (float)p1;
        float fp2 = (float)p2;
        for (int i3 = 0; i3 < this._n3; ++i3) {
            for (int i2 = 0; i2 < this._n2; ++i2) {
                for (int i1 = 0; i1 < this._n1; ++i1) {
                    this.getEigenvalues(i1, i2, i3, a);
                    float aui = a[0];
                    float avi = a[1];
                    float awi = a[2];
                    float a0i = ArrayMath.pow(amin / (awi += aeps), fp0);
                    float a1i = ArrayMath.pow(awi / (avi += aeps), fp1);
                    float a2i = ArrayMath.pow(avi / (aui += aeps), fp2);
                    aui = a0i * a1i * a2i;
                    avi = a0i * a1i;
                    awi = a0i;
                    this.setEigenvalues(i1, i2, i3, aui, avi, awi);
                }
            }
        }
    }

    private static float c3(float c1, float c2) {
        float c3s = 1.0f - c1 * c1 - c2 * c2;
        return c3s > 0.0f ? (float)Math.sqrt(c3s) : 0.0f;
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ArrayInputStream ais;
        int n3;
        int n2;
        int n1;
        int format = ois.readInt();
        if (format == 1) {
            boolean compressed = this._compressed = ois.readBoolean();
            n1 = this._n1 = ois.readInt();
            n2 = this._n2 = ois.readInt();
            n3 = this._n3 = ois.readInt();
            ais = new ArrayInputStream(ois);
            if (compressed) {
                this._bu = new short[n3][n2][n1];
                this._bw = new short[n3][n2][n1];
                this._iu = new short[n3][n2][n1];
                this._iw = new short[n3][n2][n1];
                ais.readShorts(this._bu);
                ais.readShorts(this._bw);
                ais.readShorts(this._iu);
                ais.readShorts(this._iw);
                if (_uss == null) {
                    _uss = new UnitSphereSampling(16);
                }
            } else {
                this._au = new float[n3][n2][n1];
                this._aw = new float[n3][n2][n1];
                this._u1 = new float[n3][n2][n1];
                this._u2 = new float[n3][n2][n1];
                this._w1 = new float[n3][n2][n1];
                this._w2 = new float[n3][n2][n1];
                ais.readFloats(this._au);
                ais.readFloats(this._aw);
                ais.readFloats(this._u1);
                ais.readFloats(this._u2);
                ais.readFloats(this._w1);
                ais.readFloats(this._w2);
            }
        } else {
            throw new InvalidClassException("invalid format");
        }
        this._as = new float[n3][n2][n1];
        ais.readFloats(this._as);
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.writeInt(1);
        oos.writeBoolean(this._compressed);
        oos.writeInt(this._n1);
        oos.writeInt(this._n2);
        oos.writeInt(this._n3);
        ArrayOutputStream aos = new ArrayOutputStream(oos);
        if (this._compressed) {
            aos.writeShorts(this._bu);
            aos.writeShorts(this._bw);
            aos.writeShorts(this._iu);
            aos.writeShorts(this._iw);
        } else {
            aos.writeFloats(this._au);
            aos.writeFloats(this._aw);
            aos.writeFloats(this._u1);
            aos.writeFloats(this._u2);
            aos.writeFloats(this._w1);
            aos.writeFloats(this._w2);
        }
        aos.writeFloats(this._as);
        aos.flush();
    }
}

