/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.opt;

import edu.mines.jtk.opt.ScalarSolver;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class ScalarSolverTest
extends TestCase {
    public void testLinearObjFunc() throws Exception {
        double answer = 0.3333333333333333;
        final int[] calls = new int[]{0};
        ScalarSolver solver = new ScalarSolver(new ScalarSolver.Function(){

            @Override
            public double function(double scalar) {
                calls[0] = calls[0] + 1;
                return Math.abs(scalar - 0.3333333333333333);
            }
        });
        double xmin = solver.solve(0.0, 1.0, 0.001, 0.001, 20, null);
        assert (xmin > 0.3323333333333333) : "xmin > answer - 0.001";
        assert (xmin > 0.33299999999999996) : "xmin > answer*(1. - 0.001)";
        assert (xmin < 0.3343333333333333) : "xmin < answer - 0.001";
        assert (xmin < 0.3336666666666666) : "xmin < answer*(1. + 0.001)";
        assert (calls[0] == 14) : "calls[0] == 14 != " + calls[0];
    }

    public void testNonUnitScalarRange() throws Exception {
        double answer = 0.3333333333333333;
        final int[] calls = new int[]{0};
        ScalarSolver solver = new ScalarSolver(new ScalarSolver.Function(){

            @Override
            public double function(double scalar) {
                calls[0] = calls[0] + 1;
                return Math.abs(scalar - 0.3333333333333333);
            }
        });
        double xmin = solver.solve(-1.0, 2.0, 0.001, 0.001, 20, null);
        assert (xmin > 0.3323333333333333) : "xmin > answer - 0.001";
        assert (xmin > 0.33299999999999996) : "xmin > answer*(1. - 0.001)";
        assert (xmin < 0.3343333333333333) : "xmin < answer - 0.001";
        assert (xmin < 0.3336666666666666) : "xmin < answer*(1. + 0.001)";
        assert (calls[0] == 15) : "calls[0] == 15 != " + calls[0];
    }

    public void testRightHandSide() throws Exception {
        double answer = 0.03;
        final int[] calls = new int[]{0};
        ScalarSolver solver = new ScalarSolver(new ScalarSolver.Function(){

            @Override
            public double function(double scalar) {
                calls[0] = calls[0] + 1;
                return Math.abs(scalar - 0.03);
            }
        });
        double xmin = solver.solve(0.0, 1.0, 0.001, 0.001, 20, null);
        assert (xmin > 0.028999999999999998) : "xmin > answer - 0.001";
        assert (xmin > 0.02997) : "xmin > answer*(1. - 0.001)";
        assert (xmin < 0.031) : "xmin < answer - 0.001";
        assert (xmin < 0.030029999999999994) : "xmin < answer*(1. + 0.001)";
        assert (calls[0] == 16) : "calls[0] == 16 != " + calls[0];
    }

    public void testLeftHandSide2() throws Exception {
        double answer = 0.98;
        final int[] calls = new int[]{0};
        ScalarSolver solver = new ScalarSolver(new ScalarSolver.Function(){

            @Override
            public double function(double scalar) {
                calls[0] = calls[0] + 1;
                return Math.abs(scalar - 0.98);
            }
        });
        double xmin = solver.solve(0.0, 1.0, 0.001, 0.001, 20, null);
        assert (xmin > 0.979) : "xmin > answer - 0.001";
        assert (xmin > 0.97902) : "xmin > answer*(1. - 0.001)";
        assert (xmin < 0.981) : "xmin < answer - 0.001";
        assert (xmin < 0.9809799999999999) : "xmin < answer*(1. + 0.001)";
        assert (calls[0] == 12) : "calls[0] == 12 != " + calls[0];
    }

    public void testParabola() throws Exception {
        double answer = 0.3333333333333333;
        final int[] calls = new int[]{0};
        ScalarSolver solver = new ScalarSolver(new ScalarSolver.Function(){

            @Override
            public double function(double scalar) {
                calls[0] = calls[0] + 1;
                return (scalar - 0.3333333333333333) * (scalar - 0.3333333333333333);
            }
        });
        double xmin = solver.solve(0.0, 1.0, 0.001, 0.001, 7, null);
        assert (xmin > 0.3323333333333333) : "xmin > answer - 0.001";
        assert (xmin > 0.33299999999999996) : "xmin > answer*(1. - 0.001)";
        assert (xmin < 0.3343333333333333) : "xmin < answer - 0.001";
        assert (xmin < 0.3336666666666666) : "xmin < answer*(1. + 0.001)";
        assert (calls[0] == 6) : "Number == 6 != " + calls[0];
    }

    public void testPositiveCurvature() throws Exception {
        double answer = 0.3333333333333333;
        final int[] calls = new int[]{0};
        ScalarSolver solver = new ScalarSolver(new ScalarSolver.Function(){

            @Override
            public double function(double scalar) {
                calls[0] = calls[0] + 1;
                return Math.sqrt(Math.abs(scalar - 0.3333333333333333));
            }
        });
        double xmin = solver.solve(0.0, 1.0, 0.001, 0.001, 20, null);
        assert (xmin > 0.3323333333333333) : "xmin > answer - 0.001";
        assert (xmin > 0.33299999999999996) : "xmin > answer*(1. - 0.001)";
        assert (xmin < 0.3343333333333333) : "xmin < answer - 0.001";
        assert (xmin < 0.3336666666666666) : "xmin < answer*(1. + 0.001)";
        assert (calls[0] == 16) : "Number == 16 != " + calls[0];
    }

    public void testStepFunction() throws Exception {
        double answer = 0.3333333333333333;
        final int[] calls = new int[]{0};
        ScalarSolver solver = new ScalarSolver(new ScalarSolver.Function(){

            @Override
            public double function(double scalar) {
                calls[0] = calls[0] + 1;
                if (scalar < 0.3333333333333333) {
                    return 3.0;
                }
                return scalar - 0.3333333333333333;
            }
        });
        double xmin = solver.solve(0.0, 1.0, 0.001, 0.001, 50, null);
        assert (xmin > 0.3323333333333333) : "xmin > answer - 0.001";
        assert (xmin > 0.33299999999999996) : "xmin > answer*(1. - 0.001)";
        assert (xmin < 0.3343333333333333) : "xmin < answer - 0.001";
        assert (xmin < 0.3336666666666666) : "xmin < answer*(1. + 0.001)";
        assert (calls[0] == 29) : "Number == 29 != " + calls[0];
    }

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public ScalarSolverTest(String name) {
        super(name);
    }

    public static Test suite() {
        try {
            assert (false);
            throw new IllegalStateException("need -ea");
        }
        catch (AssertionError assertionError) {
            return new TestSuite(ScalarSolverTest.class);
        }
    }

    public static void main(String[] args) {
        TestRunner.run((Test)ScalarSolverTest.suite());
    }
}

