/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.labkit.ui.models;

import sc.fiji.labkit.ui.models.Holder;
import sc.fiji.labkit.ui.utils.Notifier;

public class WeakListeningHolder<T>
implements Holder<T> {
    private final Holder<T> source;
    private final Notifier listeners = new Notifier();
    private final Runnable onSourceChanged = this::onSourceChanged;

    public WeakListeningHolder(Holder<T> source) {
        this.source = source;
        source.notifier().addWeakListener(this.onSourceChanged);
    }

    private void onSourceChanged() {
        this.listeners.notifyListeners();
    }

    @Override
    public void set(T value) {
        this.source.set(value);
    }

    @Override
    public T get() {
        return this.source.get();
    }

    @Override
    public Notifier notifier() {
        return this.listeners;
    }
}

