/*
 * Decompiled with CFR 0.152.
 */
package io.scif.gui;

import io.scif.gui.AWTImageTools;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBufferInt;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;

public class UnsignedIntColorModel
extends ColorModel {
    private final int nChannels;
    private final ComponentColorModel helper;

    public UnsignedIntColorModel(int pixelBits, int dataType, int nChannels) {
        super(pixelBits, UnsignedIntColorModel.makeBitArray(nChannels, pixelBits), AWTImageTools.makeColorSpace(nChannels), nChannels == 4, false, 3, dataType);
        this.helper = new ComponentColorModel(AWTImageTools.makeColorSpace(nChannels), nChannels == 4, false, 3, dataType);
        this.nChannels = nChannels;
    }

    @Override
    public synchronized Object getDataElements(int rgb, Object pixel) {
        return this.helper.getDataElements(rgb, pixel);
    }

    @Override
    public boolean isCompatibleRaster(Raster raster) {
        return raster.getNumBands() == this.getNumComponents() && raster.getTransferType() == this.getTransferType();
    }

    @Override
    public WritableRaster createCompatibleWritableRaster(int w, int h) {
        int[] bandOffsets = new int[this.nChannels];
        for (int i = 0; i < this.nChannels; ++i) {
            bandOffsets[i] = i;
        }
        ComponentSampleModel m = new ComponentSampleModel(3, w, h, this.nChannels, w * this.nChannels, bandOffsets);
        DataBufferInt db = new DataBufferInt(w * h, this.nChannels);
        return Raster.createWritableRaster(m, db, null);
    }

    @Override
    public int getAlpha(int pixel) {
        return this.getComponent(pixel);
    }

    @Override
    public int getBlue(int pixel) {
        return this.getComponent(pixel);
    }

    @Override
    public int getGreen(int pixel) {
        return this.getComponent(pixel);
    }

    @Override
    public int getRed(int pixel) {
        return this.getComponent(pixel);
    }

    @Override
    public int getAlpha(Object data) {
        int[] i;
        if (data instanceof int[] && (i = (int[])data).length == 4) {
            if (i.length == 1) {
                return this.getAlpha(i[0]);
            }
            return this.getAlpha(i[0]);
        }
        return Integer.MAX_VALUE;
    }

    @Override
    public int getRed(Object data) {
        if (data instanceof int[]) {
            int[] i = (int[])data;
            if (i.length == 1) {
                return this.getRed(i[0]);
            }
            return this.getRed(i.length != 4 ? i[0] : i[1]);
        }
        return Integer.MAX_VALUE;
    }

    @Override
    public int getGreen(Object data) {
        if (data instanceof int[]) {
            int[] i = (int[])data;
            if (i.length == 1) {
                return this.getGreen(i[0]);
            }
            return this.getGreen(i.length != 4 ? i[1] : i[2]);
        }
        return Integer.MAX_VALUE;
    }

    @Override
    public int getBlue(Object data) {
        if (data instanceof int[]) {
            int[] i = (int[])data;
            if (i.length == 1) {
                return this.getBlue(i[0]);
            }
            return this.getBlue(i[i.length - 1]);
        }
        return Integer.MAX_VALUE;
    }

    private int getComponent(int pixel) {
        long v = (long)pixel & 0xFFFFFFFFL;
        double f = (double)v / (Math.pow(2.0, 32.0) - 1.0);
        return (int)(f *= 255.0);
    }

    private static int[] makeBitArray(int nChannels, int nBits) {
        int[] bits = new int[nChannels];
        for (int i = 0; i < bits.length; ++i) {
            bits[i] = nBits;
        }
        return bits;
    }
}

