/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.algorithm.gauss;

import java.util.concurrent.atomic.AtomicInteger;
import mpicbg.imglib.algorithm.gauss.GaussianConvolution3;
import mpicbg.imglib.container.DirectAccessContainer;
import mpicbg.imglib.container.array.Array3D;
import mpicbg.imglib.container.basictypecontainer.array.FloatArray;
import mpicbg.imglib.cursor.LocalizableByDimCursor3D;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.multithreading.SimpleMultiThreading;
import mpicbg.imglib.outofbounds.OutOfBoundsStrategyFactory;
import mpicbg.imglib.type.numeric.NumericType;
import mpicbg.imglib.type.numeric.real.FloatType;

public class GaussianConvolution<T extends NumericType<T>>
extends GaussianConvolution3<T, T, T> {
    public GaussianConvolution(Image<T> image, OutOfBoundsStrategyFactory<T> outOfBoundsFactory, double[] sigma) {
        super(image, null, null, outOfBoundsFactory, null, null, sigma);
    }

    public GaussianConvolution(Image<T> image, OutOfBoundsStrategyFactory<T> outOfBoundsFactory, double sigma) {
        this(image, outOfBoundsFactory, GaussianConvolution.createArray(image, sigma));
    }

    @Override
    protected Image<T> getTempImage1(int currentDim) {
        if (currentDim == 0) {
            this.temp1 = this.image;
        } else if (currentDim == 1) {
            this.temp1 = this.image.createNewImage();
        }
        return this.temp1;
    }

    @Override
    protected Image<T> getTempImage2(int currentDim) {
        if (currentDim == 0) {
            this.temp2 = this.image.createNewImage();
        }
        return this.temp2;
    }

    @Override
    protected Image<T> getConvolvedImage() {
        Image output;
        if (this.numDimensions % 2 == 0) {
            output = this.temp1;
            this.temp2.close();
        } else {
            output = this.temp2;
            if (this.numDimensions > 1) {
                this.temp1.close();
            }
        }
        return output;
    }

    @Override
    protected boolean processWithOptimizedMethod() {
        if (Array3D.class.isInstance(this.image.getContainer()) && FloatType.class.isInstance(this.image.createType())) {
            this.convolved = GaussianConvolution.computeGaussFloatArray3D(this.image, this.outOfBoundsFactory, this.kernel, this.getNumThreads());
            return true;
        }
        return false;
    }

    protected static <T extends NumericType<T>> Image<T> computeGaussFloatArray3D(Image<T> image, OutOfBoundsStrategyFactory<T> outOfBoundsFactory, final double[][] kernel, final int numThreads) {
        int ithread;
        final OutOfBoundsStrategyFactory<T> outOfBoundsFactoryFloat = outOfBoundsFactory;
        final Image<T> imageFloat = image;
        final Image<T> convolved = imageFloat.createNewImage();
        final FloatArray inputArray = (FloatArray)((DirectAccessContainer)imageFloat.getContainer()).update(null);
        final FloatArray outputArray = (FloatArray)((DirectAccessContainer)convolved.getContainer()).update(null);
        final Array3D input = (Array3D)imageFloat.getContainer();
        final Array3D output = (Array3D)convolved.getContainer();
        final int width = imageFloat.getDimension(0);
        final int height = imageFloat.getDimension(1);
        final int depth = imageFloat.getDimension(2);
        final AtomicInteger ai = new AtomicInteger(0);
        Thread[] threads = SimpleMultiThreading.newThreads(numThreads);
        for (ithread = 0; ithread < threads.length; ++ithread) {
            threads[ithread] = new Thread(new Runnable(){

                @Override
                public void run() {
                    int myNumber = ai.getAndIncrement();
                    float[] in = inputArray.getCurrentStorageArray();
                    float[] out = outputArray.getCurrentStorageArray();
                    double[] kernel1 = (double[])kernel[0].clone();
                    int filterSize = kernel[0].length;
                    int filterSizeHalf = filterSize / 2;
                    LocalizableByDimCursor3D it = (LocalizableByDimCursor3D)imageFloat.createLocalizableByDimCursor(outOfBoundsFactoryFloat);
                    int[] posLUT = new int[kernel1.length];
                    for (int f = -filterSizeHalf; f <= filterSizeHalf; ++f) {
                        posLUT[f + filterSizeHalf] = f;
                    }
                    boolean[] directlyComputable = new boolean[width];
                    for (int x = 0; x < width; ++x) {
                        directlyComputable[x] = x - filterSizeHalf >= 0 && x + filterSizeHalf < width;
                    }
                    for (int z = 0; z < depth; ++z) {
                        if (z % numThreads != myNumber) continue;
                        int count = input.getPos(0, 0, z);
                        for (int y = 0; y < height; ++y) {
                            for (int x = 0; x < width; ++x) {
                                int kernelPos;
                                double avg = 0.0;
                                if (directlyComputable[x]) {
                                    for (kernelPos = 0; kernelPos < filterSize; ++kernelPos) {
                                        avg += (double)in[count + posLUT[kernelPos]] * kernel1[kernelPos];
                                    }
                                } else {
                                    kernelPos = 0;
                                    it.setPosition(x - filterSizeHalf - 1, y, z);
                                    for (int f = -filterSizeHalf; f <= filterSizeHalf; ++f) {
                                        it.fwdX();
                                        avg += (double)((FloatType)it.getType()).get() * kernel1[kernelPos++];
                                    }
                                }
                                out[count++] = (float)avg;
                            }
                        }
                    }
                    it.close();
                }
            });
        }
        SimpleMultiThreading.startAndJoin(threads);
        ai.set(0);
        for (ithread = 0; ithread < threads.length; ++ithread) {
            threads[ithread] = new Thread(new Runnable(){

                @Override
                public void run() {
                    int myNumber = ai.getAndIncrement();
                    float[] out = outputArray.getCurrentStorageArray();
                    LocalizableByDimCursor3D it = (LocalizableByDimCursor3D)convolved.createLocalizableByDimCursor(outOfBoundsFactoryFloat);
                    double[] kernel1 = (double[])kernel[1].clone();
                    int filterSize = kernel[1].length;
                    int filterSizeHalf = filterSize / 2;
                    int inc = output.getPos(0, 1, 0);
                    int[] posLUT = new int[kernel1.length];
                    for (int f = -filterSizeHalf; f <= filterSizeHalf; ++f) {
                        posLUT[f + filterSizeHalf] = f * inc;
                    }
                    boolean[] directlyComputable = new boolean[height];
                    for (int y = 0; y < height; ++y) {
                        directlyComputable[y] = y - filterSizeHalf >= 0 && y + filterSizeHalf < height;
                    }
                    float[] tempOut = new float[height];
                    for (int z = 0; z < depth; ++z) {
                        if (z % numThreads != myNumber) continue;
                        for (int x = 0; x < width; ++x) {
                            int y;
                            int count = output.getPos(x, 0, z);
                            for (y = 0; y < height; ++y) {
                                int kernelPos;
                                double avg = 0.0;
                                if (directlyComputable[y]) {
                                    for (kernelPos = 0; kernelPos < filterSize; ++kernelPos) {
                                        avg += (double)out[count + posLUT[kernelPos]] * kernel1[kernelPos];
                                    }
                                } else {
                                    kernelPos = 0;
                                    it.setPosition(x, y - filterSizeHalf - 1, z);
                                    for (int f = -filterSizeHalf; f <= filterSizeHalf; ++f) {
                                        it.fwdY();
                                        avg += (double)((FloatType)it.getType()).get() * kernel1[kernelPos++];
                                    }
                                }
                                tempOut[y] = (float)avg;
                                count += inc;
                            }
                            count = output.getPos(x, 0, z);
                            for (y = 0; y < height; ++y) {
                                out[count] = tempOut[y];
                                count += inc;
                            }
                        }
                    }
                    it.close();
                }
            });
        }
        SimpleMultiThreading.startAndJoin(threads);
        ai.set(0);
        for (ithread = 0; ithread < threads.length; ++ithread) {
            threads[ithread] = new Thread(new Runnable(){

                @Override
                public void run() {
                    int myNumber = ai.getAndIncrement();
                    double[] kernel1 = (double[])kernel[2].clone();
                    int filterSize = kernel[2].length;
                    int filterSizeHalf = filterSize / 2;
                    float[] out = outputArray.getCurrentStorageArray();
                    LocalizableByDimCursor3D it = (LocalizableByDimCursor3D)convolved.createLocalizableByDimCursor(outOfBoundsFactoryFloat);
                    int inc = output.getPos(0, 0, 1);
                    int[] posLUT = new int[kernel1.length];
                    for (int f = -filterSizeHalf; f <= filterSizeHalf; ++f) {
                        posLUT[f + filterSizeHalf] = f * inc;
                    }
                    boolean[] directlyComputable = new boolean[depth];
                    for (int z = 0; z < depth; ++z) {
                        directlyComputable[z] = z - filterSizeHalf >= 0 && z + filterSizeHalf < depth;
                    }
                    float[] tempOut = new float[depth];
                    for (int x = 0; x < width; ++x) {
                        if (x % numThreads != myNumber) continue;
                        for (int y = 0; y < height; ++y) {
                            int z;
                            int count = output.getPos(x, y, 0);
                            for (z = 0; z < depth; ++z) {
                                int kernelPos;
                                double avg = 0.0;
                                if (directlyComputable[z]) {
                                    for (kernelPos = 0; kernelPos < filterSize; ++kernelPos) {
                                        avg += (double)out[count + posLUT[kernelPos]] * kernel1[kernelPos];
                                    }
                                } else {
                                    kernelPos = 0;
                                    it.setPosition(x, y, z - filterSizeHalf - 1);
                                    for (int f = -filterSizeHalf; f <= filterSizeHalf; ++f) {
                                        it.fwdZ();
                                        avg += (double)((FloatType)it.getType()).get() * kernel1[kernelPos++];
                                    }
                                }
                                tempOut[z] = (float)avg;
                                count += inc;
                            }
                            count = output.getPos(x, y, 0);
                            for (z = 0; z < depth; ++z) {
                                out[count] = tempOut[z];
                                count += inc;
                            }
                        }
                    }
                    it.close();
                }
            });
        }
        SimpleMultiThreading.startAndJoin(threads);
        return convolved;
    }
}

