/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.container.imageplus;

import ij.ImagePlus;
import mpicbg.imglib.container.basictypecontainer.array.ArrayDataAccess;
import mpicbg.imglib.container.imageplus.ImagePlusContainerFactory;
import mpicbg.imglib.container.planar.PlanarContainer;
import mpicbg.imglib.cursor.imageplus.ImagePlusCursor;
import mpicbg.imglib.cursor.imageplus.ImagePlusCursor2D;
import mpicbg.imglib.cursor.imageplus.ImagePlusLocalizableByDimCursor;
import mpicbg.imglib.cursor.imageplus.ImagePlusLocalizableByDimOutOfBoundsCursor;
import mpicbg.imglib.cursor.imageplus.ImagePlusLocalizableCursor;
import mpicbg.imglib.cursor.imageplus.ImagePlusLocalizablePlaneCursor;
import mpicbg.imglib.exception.ImgLibException;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.outofbounds.OutOfBoundsStrategyFactory;
import mpicbg.imglib.type.Type;

public class ImagePlusContainer<T extends Type<T>, A extends ArrayDataAccess<A>>
extends PlanarContainer<T, A> {
    protected final ImagePlusContainerFactory factory;
    protected final int width;
    protected final int height;
    protected final int depth;
    protected final int frames;
    protected final int channels;

    protected ImagePlusContainer(ImagePlusContainerFactory factory, int width, int height, int depth, int frames, int channels, int entitiesPerPixel) {
        super(factory, ImagePlusContainer.reduceDimensions(new int[]{width, height, channels, depth, frames}), entitiesPerPixel);
        this.width = width;
        this.height = height;
        this.depth = depth;
        this.frames = frames;
        this.channels = channels;
        this.factory = factory;
    }

    ImagePlusContainer(ImagePlusContainerFactory factory, int[] dim, int entitiesPerPixel) {
        super(factory, dim, entitiesPerPixel);
        assert (dim.length < 6) : "ImagePlusContainer can only handle up to 5 dimensions.";
        this.width = dim.length > 0 ? dim[0] : 1;
        this.height = dim.length > 1 ? dim[1] : 1;
        this.channels = dim.length > 2 ? dim[2] : 1;
        this.depth = dim.length > 3 ? dim[3] : 1;
        this.frames = dim.length > 4 ? dim[4] : 1;
        this.factory = factory;
    }

    ImagePlusContainer(ImagePlusContainerFactory factory, A creator, int[] dim, int entitiesPerPixel) {
        this(factory, dim, entitiesPerPixel);
        this.mirror.clear();
        for (int i = 0; i < this.slices; ++i) {
            this.mirror.add(creator.createArray(this.width * this.height * entitiesPerPixel));
        }
    }

    public ImagePlus getImagePlus() throws ImgLibException {
        throw new ImgLibException(this, "has no ImagePlus instance, it is not a standard type of ImagePlus");
    }

    protected static int[] reduceDimensions(ImagePlus imp) {
        return ImagePlusContainer.reduceDimensions(imp.getDimensions());
    }

    protected static int[] reduceDimensions(int[] impDimensions) {
        int n = 2;
        for (int d = 2; d < impDimensions.length; ++d) {
            if (impDimensions[d] <= 1) continue;
            ++n;
        }
        int[] dim = new int[n];
        dim[0] = impDimensions[0];
        dim[1] = impDimensions[1];
        n = 1;
        if (impDimensions[2] > 1) {
            dim[++n] = impDimensions[2];
        }
        if (impDimensions[3] > 1) {
            dim[++n] = impDimensions[3];
        }
        if (impDimensions[4] > 1) {
            dim[++n] = impDimensions[4];
        }
        return dim;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getChannels() {
        return this.channels;
    }

    public int getDepth() {
        return this.depth;
    }

    public int getFrames() {
        return this.frames;
    }

    @Override
    public ImagePlusCursor<T> createCursor(Image<T> image) {
        if (this.numDimensions == 2) {
            return new ImagePlusCursor2D<T>(this, image, this.linkedType.duplicateTypeOnSameDirectAccessContainer());
        }
        return new ImagePlusCursor<T>(this, image, this.linkedType.duplicateTypeOnSameDirectAccessContainer());
    }

    @Override
    public ImagePlusLocalizableCursor<T> createLocalizableCursor(Image<T> image) {
        return new ImagePlusLocalizableCursor<T>(this, image, this.linkedType.duplicateTypeOnSameDirectAccessContainer());
    }

    @Override
    public ImagePlusLocalizablePlaneCursor<T> createLocalizablePlaneCursor(Image<T> image) {
        return new ImagePlusLocalizablePlaneCursor<T>(this, image, this.linkedType.duplicateTypeOnSameDirectAccessContainer());
    }

    @Override
    public ImagePlusLocalizableByDimCursor<T> createLocalizableByDimCursor(Image<T> image) {
        return new ImagePlusLocalizableByDimCursor<T>(this, image, this.linkedType.duplicateTypeOnSameDirectAccessContainer());
    }

    @Override
    public ImagePlusLocalizableByDimOutOfBoundsCursor<T> createLocalizableByDimCursor(Image<T> image, OutOfBoundsStrategyFactory<T> outOfBoundsFactory) {
        return new ImagePlusLocalizableByDimOutOfBoundsCursor<T>(this, image, this.linkedType.duplicateTypeOnSameDirectAccessContainer(), outOfBoundsFactory);
    }

    @Override
    public ImagePlusContainerFactory getFactory() {
        return this.factory;
    }
}

