/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.image.display;

import mpicbg.imglib.image.Image;
import mpicbg.imglib.type.Type;

public abstract class Display<T extends Type<T>> {
    protected final Image<T> img;
    protected double min;
    protected double max;

    public Display(Image<T> img) {
        this.img = img;
        this.min = 0.0;
        this.max = 1.0;
    }

    public Image<T> getImage() {
        return this.img;
    }

    public abstract void setMinMax();

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }

    public void setMin(double min) {
        this.min = min;
    }

    public void setMax(double max) {
        this.max = max;
    }

    public void setMinMax(double min, double max) {
        this.min = min;
        this.max = max;
    }

    public double normDouble(double c) {
        double value = (c - this.min) / (this.max - this.min);
        if (value < 0.0) {
            value = 0.0;
        } else if (value > 1.0) {
            value = 1.0;
        }
        return value;
    }

    public float normFloat(float c) {
        double value = ((double)c - this.min) / (this.max - this.min);
        if (value < 0.0) {
            value = 0.0;
        } else if (value > 1.0) {
            value = 1.0;
        }
        return (float)value;
    }

    public abstract float get32Bit(T var1);

    public abstract float get32BitNormed(T var1);

    public abstract byte get8BitSigned(T var1);

    public abstract short get8BitUnsigned(T var1);

    public int get8BitARGB(T c) {
        short col = this.get8BitUnsigned(c);
        return (col << 16) + (col << 8) + col;
    }
}

