/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.labeling;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import mpicbg.imglib.container.DirectAccessContainer;
import mpicbg.imglib.container.DirectAccessContainerFactory;
import mpicbg.imglib.container.basictypecontainer.IntAccess;
import mpicbg.imglib.cursor.Cursor;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.image.display.Display;
import mpicbg.imglib.labeling.LabelingMapping;
import mpicbg.imglib.type.Type;
import mpicbg.imglib.type.TypeImpl;

public class LabelingType<T extends Comparable<T>>
extends TypeImpl<LabelingType<T>>
implements Type<LabelingType<T>> {
    protected final DirectAccessContainer<LabelingType<T>, ? extends IntAccess> storage;
    protected final LabelingMapping<T, Integer> mapping;
    protected List<T> value = null;
    protected IntAccess access = null;
    protected long[] generation;

    public LabelingType(DirectAccessContainer<LabelingType<T>, ? extends IntAccess> storage) {
        this.storage = storage;
        this.mapping = new LabelingMapping(new Integer(0));
        this.generation = new long[1];
    }

    public LabelingType(List<T> value) {
        this.value = Collections.unmodifiableList(value);
        this.storage = null;
        this.mapping = null;
    }

    public LabelingType() {
        this.storage = null;
        this.mapping = null;
        this.value = Collections.emptyList();
        this.value = Collections.unmodifiableList(this.value);
    }

    protected LabelingType(DirectAccessContainer<LabelingType<T>, ? extends IntAccess> storage, LabelingMapping<T, Integer> mapping, IntAccess access, long[] generation) {
        this.storage = storage;
        this.mapping = mapping;
        this.access = access;
        this.generation = generation;
    }

    public List<T> getLabeling() {
        if (this.value != null) {
            return this.value;
        }
        return this.mapping.listAtIndex(this.access.getValue(this.i));
    }

    public void setLabeling(List<T> labeling) {
        if (this.value != null) {
            this.value = labeling;
        } else {
            this.access.setValue(this.i, this.mapping.indexOf(labeling));
            this.generation[0] = this.generation[0] + 1L;
        }
    }

    public void setLabeling(T[] labeling) {
        this.setLabeling(Arrays.asList(labeling));
    }

    public void setLabel(T label) {
        ArrayList<T> labeling = new ArrayList<T>(1);
        labeling.add(label);
        this.setLabeling(labeling);
    }

    public List<T> intern(List<T> labeling) {
        return this.mapping.intern(labeling);
    }

    public List<T> intern(T label) {
        ArrayList<T> labeling = new ArrayList<T>(1);
        labeling.add(label);
        return this.intern((T)labeling);
    }

    @Override
    public int getEntitiesPerPixel() {
        return 1;
    }

    @Override
    public DirectAccessContainer<LabelingType<T>, ? extends IntAccess> createSuitableDirectAccessContainer(DirectAccessContainerFactory storageFactory, int[] dim) {
        DirectAccessContainer<LabelingType<LabelingType<T>>, IntAccess> container = storageFactory.createIntInstance(dim, 1);
        LabelingType<T> linkedType = new LabelingType<T>(container);
        container.setLinkedType(linkedType);
        return container;
    }

    @Override
    public void updateContainer(Cursor<?> c) {
        this.access = this.storage.update(c);
    }

    @Override
    public LabelingType<T> createVariable() {
        return new LabelingType<T>();
    }

    @Override
    public LabelingType<T> copy() {
        return new LabelingType<T>(this.getLabeling());
    }

    @Override
    public LabelingType<T> duplicateTypeOnSameDirectAccessContainer() {
        return new LabelingType<T>(this.storage, this.mapping, this.access, this.generation);
    }

    @Override
    public void set(LabelingType<T> c) {
        this.setLabeling(c.getLabeling());
    }

    public LabelingType<T>[] createArray1D(int size1) {
        LabelingType[] result = (LabelingType[])Array.newInstance(this.getClass(), size1);
        return result;
    }

    public LabelingType<T>[][] createArray2D(int size1, int size2) {
        LabelingType<T>[] row1 = this.createArray1D(size2);
        LabelingType[][] result = (LabelingType[][])Array.newInstance(row1.getClass(), size1);
        switch (size1) {
            case 0: {
                break;
            }
            case 1: {
                result[0] = row1;
                break;
            }
            default: {
                result[0] = row1;
                for (int i = 1; i < size1; ++i) {
                    result[i] = this.createArray1D(size2);
                }
            }
        }
        return result;
    }

    public LabelingType<T>[][][] createArray3D(int size1, int size2, int size3) {
        LabelingType<T>[][] row1 = this.createArray2D(size2, size3);
        LabelingType[][][] result = (LabelingType[][][])Array.newInstance(row1.getClass(), size1);
        switch (size1) {
            case 0: {
                break;
            }
            case 1: {
                result[0] = row1;
                break;
            }
            default: {
                result[0] = row1;
                for (int i = 1; i < size1; ++i) {
                    result[i] = this.createArray2D(size2, size3);
                }
            }
        }
        return result;
    }

    @Override
    public String toString() {
        return this.getLabeling().toString();
    }

    @Override
    public Display<LabelingType<T>> getDefaultDisplay(Image<LabelingType<T>> image) {
        return new DefaultDisplay(image);
    }

    List<T> getLabels() {
        return this.mapping.getLabels();
    }

    long getGeneration() {
        return this.generation[0];
    }

    class DefaultDisplay
    extends Display<LabelingType<T>> {
        public DefaultDisplay(Image<LabelingType<T>> img) {
            super(img);
            this.min = 0.0;
            this.max = 0.0;
        }

        @Override
        public void setMinMax() {
            Cursor c = this.img.createCursor();
            if (!c.hasNext()) {
                this.min = 0.0;
                this.max = 0.0;
                return;
            }
            c.fwd();
            this.min = this.max = (double)this.valueAt(c);
            while (c.hasNext()) {
                c.fwd();
                long value = this.valueAt(c);
                if ((double)value > this.max) {
                    this.max = value;
                    continue;
                }
                if (!((double)value < this.min)) continue;
                this.min = value;
            }
            c.close();
        }

        private long valueAt(Cursor<LabelingType<T>> c) {
            return c.getType().mapping.indexOf(c.getType().getLabeling()).intValue();
        }

        private long valueAt(LabelingType<T> v) {
            return v.mapping.indexOf(v.getLabeling()).intValue();
        }

        @Override
        public float get32Bit(LabelingType<T> c) {
            return this.valueAt(c);
        }

        @Override
        public float get32BitNormed(LabelingType<T> c) {
            return this.normFloat(this.valueAt(c));
        }

        @Override
        public byte get8BitSigned(LabelingType<T> c) {
            return (byte)Math.round(this.normFloat(this.valueAt(c)) * 255.0f);
        }

        @Override
        public short get8BitUnsigned(LabelingType<T> c) {
            return (short)Math.round(this.normFloat(this.valueAt(c)) * 255.0f);
        }
    }
}

