/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.java3d.utils.scenegraph.io.state.org.scijava.java3d;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.scijava.java3d.Material;
import org.scijava.java3d.SceneGraphObject;
import org.scijava.java3d.utils.scenegraph.io.retained.Controller;
import org.scijava.java3d.utils.scenegraph.io.retained.SymbolTableData;
import org.scijava.java3d.utils.scenegraph.io.state.org.scijava.java3d.NodeComponentState;
import org.scijava.vecmath.Color3f;

public class MaterialState
extends NodeComponentState {
    public MaterialState(SymbolTableData symbol, Controller control) {
        super(symbol, control);
    }

    @Override
    public void writeObject(DataOutput out) throws IOException {
        super.writeObject(out);
        Material attr = (Material)this.node;
        Color3f clr = new Color3f();
        attr.getAmbientColor(clr);
        this.control.writeColor3f(out, clr);
        attr.getDiffuseColor(clr);
        this.control.writeColor3f(out, clr);
        attr.getEmissiveColor(clr);
        this.control.writeColor3f(out, clr);
        attr.getSpecularColor(clr);
        this.control.writeColor3f(out, clr);
        out.writeBoolean(attr.getLightingEnable());
        out.writeInt(attr.getColorTarget());
    }

    @Override
    public void readObject(DataInput in) throws IOException {
        super.readObject(in);
        Material attr = (Material)this.node;
        attr.setAmbientColor(this.control.readColor3f(in));
        attr.setDiffuseColor(this.control.readColor3f(in));
        attr.setEmissiveColor(this.control.readColor3f(in));
        attr.setSpecularColor(this.control.readColor3f(in));
        attr.setLightingEnable(in.readBoolean());
        attr.setColorTarget(in.readInt());
    }

    @Override
    protected SceneGraphObject createNode() {
        return new Material();
    }
}

