/*
 * Decompiled with CFR 0.152.
 */
package QuickPALM;

import QuickPALM.MyDialogs;
import QuickPALM.MyFunctions;
import QuickPALM.MyIO;
import ij.IJ;
import ij.ImagePlus;
import ij.gui.Plot;
import ij.measure.CurveFitter;
import ij.measure.ResultsTable;
import ij.plugin.PlugIn;
import ij.process.ImageProcessor;
import java.awt.Color;
import java.awt.Rectangle;
import java.util.Random;

public class Create_3D_calibration
implements PlugIn {
    ImagePlus imp;
    ImageProcessor ip;
    MyDialogs dg = new MyDialogs();
    MyFunctions fx = new MyFunctions();
    MyIO io = new MyIO();
    ResultsTable res = new ResultsTable();
    ResultsTable extrainfo = new ResultsTable();

    public boolean setup(String arg) {
        if (!this.dg.checkBeads() || !this.dg.beadCalibration3d()) {
            return false;
        }
        this.imp = this.dg.imp;
        this.imp.setSlice(1);
        IJ.register(Create_3D_calibration.class);
        return true;
    }

    public void run(String arg) {
        int pmin;
        int s;
        if (!this.setup(arg)) {
            return;
        }
        IJ.run((ImagePlus)this.imp, (String)"Select None", (String)"");
        double[][] sgnl = new double[this.dg.nrois][this.dg.nslices];
        double[][] xstd = new double[this.dg.nrois][this.dg.nslices];
        double[][] ystd = new double[this.dg.nrois][this.dg.nslices];
        double[][] wmh = new double[this.dg.nrois][this.dg.nslices];
        double[] mean_wmh = new double[this.dg.nslices];
        int index_z0 = 0;
        double sSum = 0.0;
        for (int s2 = 1; s2 <= this.dg.nslices; ++s2) {
            this.imp.setSlice(s2);
            this.ip = this.imp.getProcessor().duplicate();
            ImageProcessor lpip = this.ip.duplicate();
            this.fx.gblur.blur(this.ip, 0.5);
            this.fx.gblur.blur(lpip, this.dg.fwhm * 2.0);
            for (int i = 0; i < this.ip.getWidth(); ++i) {
                for (int j = 0; j < this.ip.getHeight(); ++j) {
                    int v = this.ip.get(i, j) - lpip.get(i, j);
                    if (v >= 0) {
                        this.ip.set(i, j, v);
                        continue;
                    }
                    this.ip.set(i, j, 0);
                }
            }
            sSum = 0.0;
            for (int r = 0; r < this.dg.rois.length; ++r) {
                Rectangle roi = this.dg.rois[r].getBoundingRect();
                double[] results = this.fx.getParticleForCalibration(this.ip, this.dg, roi.x, roi.x + roi.width, roi.y, roi.y + roi.height);
                sgnl[r][s2 - 1] = results[0];
                xstd[r][s2 - 1] = results[3] + results[4];
                ystd[r][s2 - 1] = results[5] + results[6];
                wmh[r][s2 - 1] = results[7];
                int n = s2 - 1;
                mean_wmh[n] = mean_wmh[n] + results[7] * results[0];
                sSum += results[0];
            }
            int n = s2 - 1;
            mean_wmh[n] = mean_wmh[n] / sSum;
        }
        double[] bias = new double[this.dg.rois.length];
        int r = 0;
        while (r < this.dg.rois.length) {
            sSum = 0.0;
            for (s = 1; s <= this.dg.nslices; ++s) {
                int n = r;
                bias[n] = bias[n] + (wmh[r][s - 1] - mean_wmh[s - 1]) * sgnl[r][s - 1];
                sSum += sgnl[r][s - 1];
            }
            int n = r++;
            bias[n] = bias[n] / sSum;
        }
        for (r = 0; r < this.dg.rois.length; ++r) {
            for (s = 1; s <= this.dg.nslices; ++s) {
                double[] dArray = wmh[r];
                int n = s - 1;
                dArray[n] = dArray[n] - bias[r];
            }
        }
        for (int s3 = 1; s3 <= this.dg.nslices; ++s3) {
            mean_wmh[s3 - 1] = 0.0;
            sSum = 0.0;
            for (int r2 = 0; r2 < this.dg.rois.length; ++r2) {
                int n = s3 - 1;
                mean_wmh[n] = mean_wmh[n] + wmh[r2][s3 - 1] * sgnl[r2][s3 - 1];
                sSum += sgnl[r2][s3 - 1];
            }
            int n = s3 - 1;
            mean_wmh[n] = mean_wmh[n] / sSum;
        }
        mean_wmh = this.fx.movingMean(mean_wmh, this.dg.window);
        double[] zpos = new double[this.dg.nslices];
        for (s = 1; s <= this.dg.nslices; ++s) {
            zpos[s - 1] = s;
        }
        double[] cal_mean_wmh = (double[])mean_wmh.clone();
        if (this.dg.model != this.dg.models[0]) {
            CurveFitter cf = new CurveFitter(zpos, mean_wmh);
            if (this.dg.model == this.dg.models[1]) {
                cf.doFit(0);
            } else if (this.dg.model == this.dg.models[2]) {
                cf.doFit(1);
            } else if (this.dg.model == this.dg.models[3]) {
                cf.doFit(2);
            } else if (this.dg.model == this.dg.models[4]) {
                cf.doFit(3);
            }
            IJ.log((String)"---- Model Estimation ----");
            IJ.log((String)cf.getResultString());
            cal_mean_wmh = cf.getResiduals();
            for (int s4 = 0; s4 < cal_mean_wmh.length; ++s4) {
                cal_mean_wmh[s4] = mean_wmh[s4] - cal_mean_wmh[s4];
            }
        }
        index_z0 = this.fx.getClosest(0.0, cal_mean_wmh, 0);
        for (int s5 = 1; s5 <= this.dg.nslices; ++s5) {
            zpos[s5 - 1] = (double)(s5 - index_z0) * this.dg.cal_z;
        }
        int pmax = this.fx.argmax(cal_mean_wmh);
        int start = pmax < (pmin = this.fx.argmin(cal_mean_wmh)) ? pmax : pmin;
        int stop = pmax < pmin ? pmin : pmax;
        double[] tmp_mean_wmh = new double[stop - start + 1];
        double[] tmp_cal_mean_wmh = new double[stop - start + 1];
        double[] tmp_zpos = new double[stop - start + 1];
        System.arraycopy(mean_wmh, start, tmp_mean_wmh, 0, stop - start + 1);
        System.arraycopy(cal_mean_wmh, start, tmp_cal_mean_wmh, 0, stop - start + 1);
        System.arraycopy(zpos, start, tmp_zpos, 0, stop - start + 1);
        mean_wmh = tmp_mean_wmh;
        cal_mean_wmh = tmp_cal_mean_wmh;
        zpos = tmp_zpos;
        Plot plot = new Plot("Calibration Values", "Z-position (nm)", "PSF Width minus Height (px)", zpos, cal_mean_wmh);
        Random rand = new Random(0L);
        plot.setLineWidth(1);
        for (int r3 = 0; r3 < this.dg.nrois; ++r3) {
            float f = (float)r3 / (float)(this.dg.nrois - 1) * 2.0f;
            float a = f < 1.0f ? 1.0f - f : 0.0f;
            float b = f < 1.0f ? f / 2.0f : (2.0f - f) / 2.0f;
            float c = f < 1.0f ? 0.0f : f - 1.0f;
            Color color = new Color(a, b, c);
            plot.setColor(color);
            double[] tmp = new double[stop - start + 1];
            System.arraycopy(wmh[r3], start, tmp, 0, stop - start + 1);
            plot.addPoints(zpos, tmp, 5);
        }
        plot.setLineWidth(2);
        plot.setColor(Color.BLACK);
        plot.show();
        for (int s6 = 0; s6 < zpos.length; ++s6) {
            this.res.incrementCounter();
            this.res.addValue("Z-Step", zpos[s6]);
            this.res.addValue("Raw Width minus Heigh", mean_wmh[s6]);
            this.res.addValue("Calibration Width minus Height", cal_mean_wmh[s6]);
        }
        this.res.show("Astigmatism calibration");
        if (this.dg.part_divergence) {
            double[] mean_resol = new double[zpos.length];
            double[] std_resol = new double[zpos.length];
            this.fx.cal3d_z = zpos;
            this.fx.cal3d_wmh = cal_mean_wmh;
            double count = 0.0;
            for (int s7 = 0; s7 < zpos.length; ++s7) {
                mean_resol[s7] = 0.0;
                std_resol[s7] = 0.0;
                for (int r4 = 0; r4 < this.dg.rois.length; ++r4) {
                    count = 0.0;
                    double zpart = this.fx.getZ(wmh[r4][s7]);
                    if (!(zpart < 9999.0)) continue;
                    int n = s7;
                    mean_resol[n] = mean_resol[n] + Math.abs(zpart - zpos[s7]);
                    int n2 = s7;
                    std_resol[n2] = std_resol[n2] + Math.pow(zpart - zpos[s7], 2.0);
                    count += 1.0;
                }
                int n = s7;
                mean_resol[n] = mean_resol[n] / count;
                std_resol[s7] = Math.sqrt(std_resol[s7] / count);
                if (std_resol[s7] > 1000.0) {
                    std_resol[s7] = 0.0;
                }
                if (!(mean_resol[s7] > 1000.0)) continue;
                mean_resol[s7] = 0.0;
            }
            plot = new Plot("Particle divergence against model", "Z-position (nm)", "Stddev of bead positions vs. model (nm)", zpos, std_resol);
            plot.show();
        }
        if (!this.dg.part_extrainfo) {
            return;
        }
        for (int s8 = 0; s8 < this.dg.nslices; ++s8) {
            this.extrainfo.incrementCounter();
            for (int r5 = 0; r5 < this.dg.nrois; ++r5) {
                this.extrainfo.addValue("Width P" + r5, xstd[r5][s8]);
                this.extrainfo.addValue("Height P" + r5, ystd[r5][s8]);
            }
        }
        this.extrainfo.show("Particle extra information...");
    }
}

