/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.blocks;

import java.util.function.Supplier;
import net.imglib2.Interval;
import net.imglib2.algorithm.blocks.BlockSupplier;
import net.imglib2.type.NativeType;
import net.imglib2.util.CloseableThreadLocal;

public abstract class AbstractBlockSupplier<T extends NativeType<T>>
implements BlockSupplier<T> {
    private Supplier<BlockSupplier<T>> threadSafeSupplier;

    @Override
    public BlockSupplier<T> threadSafe() {
        if (this.threadSafeSupplier == null) {
            this.threadSafeSupplier = CloseableThreadLocal.withInitial(this::independentCopy)::get;
        }
        return new BlockSupplier<T>(){

            @Override
            public T getType() {
                return (NativeType)AbstractBlockSupplier.this.getType();
            }

            @Override
            public int numDimensions() {
                return AbstractBlockSupplier.this.numDimensions();
            }

            @Override
            public void copy(Interval interval, Object dest) {
                ((BlockSupplier)AbstractBlockSupplier.this.threadSafeSupplier.get()).copy(interval, dest);
            }

            @Override
            public BlockSupplier<T> independentCopy() {
                return AbstractBlockSupplier.this.independentCopy().threadSafe();
            }

            @Override
            public BlockSupplier<T> threadSafe() {
                return this;
            }
        };
    }
}

