/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.region;

import net.imglib2.Localizable;
import net.imglib2.RandomAccessible;
import net.imglib2.algorithm.region.EllipseCursor;
import net.imglib2.type.Type;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.operators.Add;

public class Ellipses {
    public static <T extends RealType<T>> void inc(RandomAccessible<T> rai, Localizable center, long radiusX, long radiusY) {
        Ellipses.inc(rai, center, radiusX, radiusY, 0, 1);
    }

    public static <T extends RealType<T>> void inc(RandomAccessible<T> rai, Localizable center, long radiusX, long radiusY, int dimX, int dimY) {
        EllipseCursor<T> cursor = new EllipseCursor<T>(rai, center, radiusX, radiusY, dimX, dimY);
        while (cursor.hasNext()) {
            cursor.fwd();
            ((RealType)cursor.get()).inc();
        }
    }

    public static <T extends Type<T>> void set(RandomAccessible<T> rai, Localizable center, long radiusX, long radiusY, T value) {
        Ellipses.set(rai, center, radiusX, radiusY, 0, 1, value);
    }

    public static <T extends Type<T>> void set(RandomAccessible<T> rai, Localizable center, long radiusX, long radiusY, int dimX, int dimY, T value) {
        EllipseCursor<T> cursor = new EllipseCursor<T>(rai, center, radiusX, radiusY, dimX, dimY);
        while (cursor.hasNext()) {
            cursor.fwd();
            ((Type)cursor.get()).set(value);
        }
    }

    public static <T extends Add<T>> void add(RandomAccessible<T> rai, Localizable center, long radiusX, long radiusY, T value) {
        Ellipses.add(rai, center, radiusX, radiusY, 0, 1, value);
    }

    public static <T extends Add<T>> void add(RandomAccessible<T> rai, Localizable center, long radiusX, long radiusY, int dimX, int dimY, T value) {
        EllipseCursor<T> cursor = new EllipseCursor<T>(rai, center, radiusX, radiusY, dimX, dimY);
        while (cursor.hasNext()) {
            cursor.fwd();
            ((Add)cursor.get()).add(value);
        }
    }

    private Ellipses() {
    }
}

