/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.display.process;

import java.util.Arrays;
import net.imagej.Dataset;
import net.imagej.display.DataView;
import net.imagej.display.DatasetView;
import net.imagej.display.ImageDisplay;
import net.imagej.display.ImageDisplayService;
import org.scijava.convert.ConvertService;
import org.scijava.module.Module;
import org.scijava.module.ModuleItem;
import org.scijava.module.ModuleService;
import org.scijava.module.process.AbstractSingleInputPreprocessor;
import org.scijava.module.process.PreprocessorPlugin;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=PreprocessorPlugin.class, priority=10000.0)
public class ActiveImagePreprocessor
extends AbstractSingleInputPreprocessor {
    @Parameter(required=false)
    private ImageDisplayService imageDisplayService;
    @Parameter(required=false)
    private ModuleService moduleService;
    @Parameter(required=false)
    private ConvertService convertService;

    public void process(Module m) {
        if (this.imageDisplayService == null || this.moduleService == null) {
            return;
        }
        for (Class type : Arrays.asList(ImageDisplay.class, DatasetView.class, DataView.class, Dataset.class)) {
            this.fill(m, this.getSingleInput(m, type), type);
            this.fill(m, this.getConvertibleSingleInput(m, type), type);
        }
    }

    private String getConvertibleSingleInput(Module m, Class<?> type) {
        if (this.moduleService == null || this.convertService == null) {
            return null;
        }
        ModuleItem item = this.moduleService.getSingleInput(m, this.convertService.getCompatibleOutputClasses(type));
        if (item == null || !item.isAutoFill()) {
            return null;
        }
        return item.getName();
    }

    private void fill(Module module, String name, Class<?> valueType) {
        if (name == null) {
            return;
        }
        ImageDisplay imageDisplay = this.imageDisplayService.getActiveImageDisplay();
        if (imageDisplay == null) {
            return;
        }
        Object value = null;
        if (valueType == ImageDisplay.class) {
            value = imageDisplay;
        } else if (valueType == DatasetView.class) {
            this.imageDisplayService.getActiveDatasetView(imageDisplay);
        } else if (valueType == DataView.class) {
            value = imageDisplay.getActiveView();
        } else if (valueType == Dataset.class) {
            value = this.imageDisplayService.getActiveDataset(imageDisplay);
        }
        if (value == null) {
            return;
        }
        Class type = module.getInfo().getInput(name).getType();
        if (!type.isInstance(value)) {
            value = this.convertService.convert(value, type);
        }
        if (value == null) {
            return;
        }
        module.setInput(name, value);
        module.resolveInput(name);
    }
}

