/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.ops.parse;

import java.util.List;
import java.util.Map;
import net.imglib2.img.Img;
import net.imglib2.ops.function.general.GeneralBinaryFunction;
import net.imglib2.ops.function.general.GeneralUnaryFunction;
import net.imglib2.ops.function.real.RealAngleFromOriginFunction;
import net.imglib2.ops.function.real.RealConstantFunction;
import net.imglib2.ops.function.real.RealDistanceFromPointFunction;
import net.imglib2.ops.function.real.RealImageFunction;
import net.imglib2.ops.function.real.RealIndexFunction;
import net.imglib2.ops.operation.real.binary.RealAdd;
import net.imglib2.ops.operation.real.binary.RealBinaryOperation;
import net.imglib2.ops.operation.real.binary.RealDivide;
import net.imglib2.ops.operation.real.binary.RealMax;
import net.imglib2.ops.operation.real.binary.RealMin;
import net.imglib2.ops.operation.real.binary.RealMod;
import net.imglib2.ops.operation.real.binary.RealMultiply;
import net.imglib2.ops.operation.real.binary.RealPower;
import net.imglib2.ops.operation.real.binary.RealSubtract;
import net.imglib2.ops.parse.ParseStatus;
import net.imglib2.ops.parse.ParseUtils;
import net.imglib2.ops.parse.token.AngleReference;
import net.imglib2.ops.parse.token.CloseParen;
import net.imglib2.ops.parse.token.Comma;
import net.imglib2.ops.parse.token.DimensionReference;
import net.imglib2.ops.parse.token.DistanceFromCenterReference;
import net.imglib2.ops.parse.token.Divide;
import net.imglib2.ops.parse.token.Exponent;
import net.imglib2.ops.parse.token.FunctionCall;
import net.imglib2.ops.parse.token.ImgReference;
import net.imglib2.ops.parse.token.Int;
import net.imglib2.ops.parse.token.Max;
import net.imglib2.ops.parse.token.Min;
import net.imglib2.ops.parse.token.Minus;
import net.imglib2.ops.parse.token.Mod;
import net.imglib2.ops.parse.token.OpenParen;
import net.imglib2.ops.parse.token.Plus;
import net.imglib2.ops.parse.token.Real;
import net.imglib2.ops.parse.token.Times;
import net.imglib2.ops.parse.token.Token;
import net.imglib2.ops.parse.token.TypeBoundReference;
import net.imglib2.ops.parse.token.Variable;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.real.DoubleType;

@Deprecated
public class EquationParser<T extends RealType<T>> {
    private Map<String, Integer> varMap;
    private Img<T> img;

    public EquationParser(Map<String, Integer> varMap, Img<T> img) {
        this.varMap = varMap;
        this.img = img;
    }

    public ParseStatus equation(List<Token> tokens, int pos) {
        ParseStatus status1 = this.term(tokens, pos);
        if (status1.errMsg != null) {
            return status1;
        }
        ParseStatus status2 = status1;
        if (ParseUtils.match(Plus.class, tokens, status1.tokenNumber)) {
            status2 = this.equation(tokens, status1.tokenNumber + 1);
            if (status2.errMsg != null) {
                return status2;
            }
            status2.function = new GeneralBinaryFunction<long[], DoubleType, DoubleType, DoubleType>(status1.function, status2.function, new RealAdd(), new DoubleType());
        } else if (ParseUtils.match(Minus.class, tokens, status1.tokenNumber)) {
            status2 = this.equation(tokens, status1.tokenNumber + 1);
            if (status2.errMsg != null) {
                return status2;
            }
            status2.function = new GeneralBinaryFunction<long[], DoubleType, DoubleType, DoubleType>(status1.function, status2.function, new RealSubtract(), new DoubleType());
        }
        return status2;
    }

    private ParseStatus term(List<Token> tokens, int pos) {
        ParseStatus status1 = this.factor(tokens, pos);
        if (status1.errMsg != null) {
            return status1;
        }
        ParseStatus status2 = status1;
        if (ParseUtils.match(Times.class, tokens, status1.tokenNumber)) {
            status2 = this.term(tokens, status1.tokenNumber + 1);
            if (status2.errMsg != null) {
                return status2;
            }
            status2.function = new GeneralBinaryFunction<long[], DoubleType, DoubleType, DoubleType>(status1.function, status2.function, new RealMultiply(), new DoubleType());
        } else if (ParseUtils.match(Divide.class, tokens, status1.tokenNumber)) {
            status2 = this.term(tokens, status1.tokenNumber + 1);
            if (status2.errMsg != null) {
                return status2;
            }
            status2.function = new GeneralBinaryFunction<long[], DoubleType, DoubleType, DoubleType>(status1.function, status2.function, new RealDivide(), new DoubleType());
        } else if (ParseUtils.match(Mod.class, tokens, status1.tokenNumber)) {
            status2 = this.term(tokens, status1.tokenNumber + 1);
            if (status2.errMsg != null) {
                return status2;
            }
            status2.function = new GeneralBinaryFunction<long[], DoubleType, DoubleType, DoubleType>(status1.function, status2.function, new RealMod(), new DoubleType());
        }
        return status2;
    }

    private ParseStatus factor(List<Token> tokens, int pos) {
        ParseStatus status1 = this.signedAtom(tokens, pos);
        if (status1.errMsg != null) {
            return status1;
        }
        ParseStatus status2 = status1;
        if (ParseUtils.match(Exponent.class, tokens, status1.tokenNumber)) {
            status2 = this.factor(tokens, status1.tokenNumber + 1);
            if (status2.errMsg != null) {
                return status2;
            }
            status2.function = new GeneralBinaryFunction<long[], DoubleType, DoubleType, DoubleType>(status1.function, status2.function, new RealPower(), new DoubleType());
        }
        return status2;
    }

    private ParseStatus signedAtom(List<Token> tokens, int pos) {
        if (ParseUtils.match(Plus.class, tokens, pos)) {
            return this.atom(tokens, pos + 1);
        }
        if (ParseUtils.match(Minus.class, tokens, pos)) {
            ParseStatus status = this.atom(tokens, pos + 1);
            if (status.errMsg != null) {
                return status;
            }
            RealConstantFunction constant = new RealConstantFunction(new DoubleType(-1.0));
            status.function = new GeneralBinaryFunction<long[], DoubleType, DoubleType, DoubleType>(constant, status.function, new RealMultiply(), new DoubleType());
            return status;
        }
        return this.atom(tokens, pos);
    }

    private ParseStatus atom(List<Token> tokens, int pos) {
        if (ParseUtils.match(Variable.class, tokens, pos)) {
            Variable var = (Variable)tokens.get(pos);
            int index = this.varMap.get(var.getText());
            if (index < 0) {
                return ParseUtils.syntaxError(pos, tokens, "Undeclared variable " + var.getText());
            }
            ParseStatus status = new ParseStatus();
            status.tokenNumber = pos + 1;
            status.function = new RealIndexFunction(index);
            return status;
        }
        if (ParseUtils.match(FunctionCall.class, tokens, pos)) {
            FunctionCall funcCall = (FunctionCall)tokens.get(pos);
            if (!ParseUtils.match(OpenParen.class, tokens, pos + 1)) {
                return ParseUtils.syntaxError(pos + 1, tokens, "Function call definition expected a '('");
            }
            ParseStatus status = this.equation(tokens, pos + 2);
            if (status.errMsg != null) {
                return status;
            }
            if (!ParseUtils.match(CloseParen.class, tokens, status.tokenNumber)) {
                return ParseUtils.syntaxError(status.tokenNumber, tokens, "Function call definition expected a ')'");
            }
            status.function = new GeneralUnaryFunction<long[], DoubleType, DoubleType>(status.function, funcCall.getOp(), new DoubleType());
            ++status.tokenNumber;
            return status;
        }
        if (ParseUtils.match(ImgReference.class, tokens, pos)) {
            if (this.img == null) {
                return ParseUtils.syntaxError(pos, tokens, "IMG reference not allowed in this context");
            }
            ParseStatus status = new ParseStatus();
            status.tokenNumber = pos + 1;
            status.function = new RealImageFunction<T, DoubleType>(this.img, new DoubleType());
            return status;
        }
        if (ParseUtils.match(TypeBoundReference.class, tokens, pos)) {
            TypeBoundReference bound = (TypeBoundReference)tokens.get(pos);
            if (this.img == null) {
                return ParseUtils.syntaxError(pos, tokens, "Type bounds only work in equations that are associated with an Img");
            }
            RealType type = (RealType)this.img.cursor().get();
            double constant = bound.isMin() ? type.getMinValue() : type.getMaxValue();
            ParseStatus status = new ParseStatus();
            status.tokenNumber = pos + 1;
            status.function = new RealConstantFunction<long[], DoubleType>(new DoubleType(constant));
            return status;
        }
        if (ParseUtils.match(DimensionReference.class, tokens, pos)) {
            if (!ParseUtils.match(OpenParen.class, tokens, pos + 1)) {
                return ParseUtils.syntaxError(pos + 1, tokens, "Expected a '('.");
            }
            if (!ParseUtils.match(Variable.class, tokens, pos + 2)) {
                return ParseUtils.syntaxError(pos + 2, tokens, "Expected a dimension variable reference.");
            }
            Variable var = (Variable)tokens.get(pos + 2);
            if (!ParseUtils.match(CloseParen.class, tokens, pos + 3)) {
                return ParseUtils.syntaxError(pos + 3, tokens, "Expected a ')'.");
            }
            Integer reference = this.varMap.get(var.getText());
            if (reference == null) {
                return ParseUtils.syntaxError(pos + 2, tokens, "Unknown variable.");
            }
            if (reference < 0) {
                return ParseUtils.syntaxError(pos + 2, tokens, "Undeclared variable.");
            }
            if (this.img == null) {
                return ParseUtils.syntaxError(pos, tokens, "Dimension bounds only work in equations that are associated with an Img");
            }
            double constant = this.img.dimension(reference.intValue());
            ParseStatus status = new ParseStatus();
            status.tokenNumber = pos + 4;
            status.function = new RealConstantFunction<long[], DoubleType>(new DoubleType(constant));
            return status;
        }
        if (ParseUtils.match(DistanceFromCenterReference.class, tokens, pos)) {
            if (this.img == null) {
                return ParseUtils.syntaxError(pos, tokens, "Center distance references only work in equations that are associated with an Img");
            }
            long[] dims = new long[this.img.numDimensions()];
            this.img.dimensions(dims);
            double[] ctr = new double[dims.length];
            for (int i = 0; i < dims.length; ++i) {
                ctr[i] = (double)dims[i] / 2.0;
            }
            ParseStatus status = new ParseStatus();
            status.tokenNumber = pos + 1;
            status.function = new RealDistanceFromPointFunction<DoubleType>(ctr, new DoubleType());
            return status;
        }
        if (ParseUtils.match(AngleReference.class, tokens, pos)) {
            if (!ParseUtils.match(OpenParen.class, tokens, pos + 1)) {
                return ParseUtils.syntaxError(pos + 1, tokens, "Expected a '('.");
            }
            if (!ParseUtils.match(Variable.class, tokens, pos + 2)) {
                return ParseUtils.syntaxError(pos + 2, tokens, "Expected a variable reference.");
            }
            if (!ParseUtils.match(Comma.class, tokens, pos + 3)) {
                return ParseUtils.syntaxError(pos + 3, tokens, "Expected a ','.");
            }
            if (!ParseUtils.match(Variable.class, tokens, pos + 4)) {
                return ParseUtils.syntaxError(pos + 4, tokens, "Expected a variable reference.");
            }
            if (!ParseUtils.match(CloseParen.class, tokens, pos + 5)) {
                return ParseUtils.syntaxError(pos + 5, tokens, "Expected a ')'.");
            }
            Variable var1 = (Variable)tokens.get(pos + 2);
            Variable var2 = (Variable)tokens.get(pos + 4);
            int axis1 = this.varMap.get(var1.getText());
            int axis2 = this.varMap.get(var2.getText());
            if (axis1 < 0) {
                return ParseUtils.syntaxError(pos + 2, tokens, "Undeclared variable.");
            }
            if (axis2 < 0) {
                return ParseUtils.syntaxError(pos + 4, tokens, "Undeclared variable.");
            }
            if (axis1 == axis2) {
                return ParseUtils.syntaxError(pos, tokens, "Cannot reference same axis variable twice.");
            }
            ParseStatus status = new ParseStatus();
            status.tokenNumber = pos + 6;
            status.function = new RealAngleFromOriginFunction<DoubleType>(axis1, axis2, new DoubleType());
            return status;
        }
        if (ParseUtils.match(Min.class, tokens, pos) || ParseUtils.match(Max.class, tokens, pos)) {
            if (!ParseUtils.match(OpenParen.class, tokens, pos + 1)) {
                return ParseUtils.syntaxError(pos + 1, tokens, "Expected a '('.");
            }
            ParseStatus status1 = this.equation(tokens, pos + 2);
            if (status1.errMsg != null) {
                return status1;
            }
            if (!ParseUtils.match(Comma.class, tokens, status1.tokenNumber)) {
                return ParseUtils.syntaxError(status1.tokenNumber, tokens, "Expected a ','.");
            }
            ParseStatus status2 = this.equation(tokens, status1.tokenNumber + 1);
            if (status2.errMsg != null) {
                return status2;
            }
            if (!ParseUtils.match(CloseParen.class, tokens, status2.tokenNumber)) {
                return ParseUtils.syntaxError(status2.tokenNumber, tokens, "Expected a ')'.");
            }
            ParseStatus status = new ParseStatus();
            status.tokenNumber = status2.tokenNumber + 1;
            RealBinaryOperation op = ParseUtils.match(Min.class, tokens, pos) ? new RealMin() : new RealMax();
            status.function = new GeneralBinaryFunction<long[], DoubleType, DoubleType, DoubleType>(status1.function, status2.function, op, new DoubleType());
            return status;
        }
        if (ParseUtils.match(OpenParen.class, tokens, pos)) {
            ParseStatus status = this.equation(tokens, pos + 1);
            if (status.errMsg != null) {
                return status;
            }
            if (!ParseUtils.match(CloseParen.class, tokens, status.tokenNumber)) {
                return ParseUtils.syntaxError(status.tokenNumber, tokens, "Expected a ')'");
            }
            ++status.tokenNumber;
            return status;
        }
        return this.num(tokens, pos);
    }

    private ParseStatus num(List<Token> tokens, int pos) {
        if (ParseUtils.match(Real.class, tokens, pos)) {
            Real r = (Real)tokens.get(pos);
            ParseStatus status = new ParseStatus();
            status.function = new RealConstantFunction<long[], DoubleType>(new DoubleType(r.getValue()));
            status.tokenNumber = pos + 1;
            return status;
        }
        if (ParseUtils.match(Int.class, tokens, pos)) {
            Int i = (Int)tokens.get(pos);
            ParseStatus status = new ParseStatus();
            status.function = new RealConstantFunction<long[], DoubleType>(new DoubleType((double)i.getValue()));
            status.tokenNumber = pos + 1;
            return status;
        }
        return ParseUtils.syntaxError(pos, tokens, "Expected a number.");
    }
}

