/*
 * Decompiled with CFR 0.152.
 */
package spim.process.fusion.export;

import ij.ImagePlus;
import ij.gui.GenericDialog;
import ij.io.FileSaver;
import java.io.File;
import java.util.Date;
import java.util.List;
import mpicbg.spim.data.sequence.TimePoint;
import mpicbg.spim.data.sequence.ViewSetup;
import mpicbg.spim.io.IOFunctions;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.exception.ImgLibException;
import net.imglib2.img.display.imagej.ImageJFunctions;
import net.imglib2.img.imageplus.ImagePlusImg;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.RealType;
import spim.fiji.spimdata.SpimData2;
import spim.process.fusion.FusionHelper;
import spim.process.fusion.boundingbox.BoundingBoxGUI;
import spim.process.fusion.export.DefaultImgTitler;
import spim.process.fusion.export.FixedNameImgTitler;
import spim.process.fusion.export.ImgExport;
import spim.process.fusion.export.ImgExportTitle;
import spim.process.fusion.export.ImgTitler;

public class Save3dTIFF
implements ImgExportTitle {
    public static boolean defaultUseXMLPath = true;
    public static String defaultPath = null;
    String path;
    boolean compress;
    ImgTitler imgTitler = new DefaultImgTitler();

    public Save3dTIFF(String path) {
        this(path, false);
    }

    public Save3dTIFF(String path, boolean compress) {
        this.path = path;
        this.compress = compress;
    }

    public <T extends RealType<T> & NativeType<T>> void exportImage(RandomAccessibleInterval<T> img, String title) {
        ImgTitler current = this.getImgTitler();
        this.setImgTitler(new FixedNameImgTitler(title));
        this.exportImage(img, null, null, null);
        this.setImgTitler(current);
    }

    @Override
    public <T extends RealType<T> & NativeType<T>> boolean exportImage(RandomAccessibleInterval<T> img, BoundingBoxGUI bb, TimePoint tp, ViewSetup vs) {
        return this.exportImage(img, bb, tp, vs, Double.NaN, Double.NaN);
    }

    @Override
    public <T extends RealType<T> & NativeType<T>> boolean exportImage(RandomAccessibleInterval<T> img, BoundingBoxGUI bb, TimePoint tp, ViewSetup vs, double min, double max) {
        if (img == null) {
            return false;
        }
        float[] minmax = Double.isNaN(min) || Double.isNaN(max) ? FusionHelper.minMax(img) : new float[]{(float)min, (float)max};
        ImagePlus imp = null;
        if (img instanceof ImagePlusImg) {
            try {
                imp = ((ImagePlusImg)img).getImagePlus();
            }
            catch (ImgLibException imgLibException) {
                // empty catch block
            }
        }
        if (imp == null) {
            imp = ImageJFunctions.wrap(img, (String)this.getImgTitler().getImageTitle(tp, vs)).duplicate();
        }
        imp.setTitle(this.getImgTitler().getImageTitle(tp, vs));
        if (bb != null) {
            imp.getCalibration().xOrigin = -(bb.min(0) / (long)bb.getDownSampling());
            imp.getCalibration().yOrigin = -(bb.min(1) / (long)bb.getDownSampling());
            imp.getCalibration().zOrigin = -(bb.min(2) / (long)bb.getDownSampling());
            imp.getCalibration().pixelHeight = imp.getCalibration().pixelDepth = (double)bb.getDownSampling();
            imp.getCalibration().pixelWidth = imp.getCalibration().pixelDepth;
        }
        imp.setDimensions(1, (int)img.dimension(2), 1);
        imp.setDisplayRange((double)minmax[0], (double)minmax[1]);
        imp.updateAndDraw();
        String fileName = !this.getImgTitler().getImageTitle(tp, vs).endsWith(".tif") ? new File(this.path, this.getImgTitler().getImageTitle(tp, vs) + ".tif").getAbsolutePath() : new File(this.path, this.getImgTitler().getImageTitle(tp, vs)).getAbsolutePath();
        if (this.compress) {
            IOFunctions.println(new Date(System.currentTimeMillis()) + ": Saving file " + fileName + ".zip");
            return new FileSaver(imp).saveAsZip(fileName);
        }
        IOFunctions.println(new Date(System.currentTimeMillis()) + ": Saving file " + fileName);
        return new FileSaver(imp).saveAsTiffStack(fileName);
    }

    @Override
    public boolean queryParameters(SpimData2 spimData, boolean is16bit) {
        return true;
    }

    @Override
    public void queryAdditionalParameters(GenericDialog gd, SpimData2 spimData) {
        if (defaultPath == null || defaultPath.length() == 0) {
            defaultPath = spimData.getBasePath().getAbsolutePath();
            if (defaultPath.endsWith("/.")) {
                defaultPath = defaultPath.substring(0, defaultPath.length() - 1);
            }
            if (defaultPath.endsWith("/./")) {
                defaultPath = defaultPath.substring(0, defaultPath.length() - 2);
            }
        }
        gd.addStringField("Output_file_directory", defaultPath, 50);
    }

    @Override
    public boolean parseAdditionalParameters(GenericDialog gd, SpimData2 spimData) {
        this.path = gd.getNextString().trim();
        return true;
    }

    @Override
    public ImgExport newInstance() {
        return new Save3dTIFF(this.path);
    }

    @Override
    public String getDescription() {
        return "Save as TIFF stack";
    }

    @Override
    public void setImgTitler(ImgTitler imgTitler) {
        this.imgTitler = imgTitler;
    }

    @Override
    public ImgTitler getImgTitler() {
        return this.imgTitler;
    }

    @Override
    public void setXMLData(List<TimePoint> timepointsToProcess, List<ViewSetup> newViewSetups) {
    }

    @Override
    public boolean finish() {
        return false;
    }
}

