/*
 * Decompiled with CFR 0.152.
 */
package spim.process.fusion.weights;

import net.imglib2.AbstractLocalizableInt;
import net.imglib2.Interval;
import net.imglib2.Localizable;
import net.imglib2.RandomAccess;
import net.imglib2.RealRandomAccess;
import net.imglib2.RealRandomAccessible;
import net.imglib2.realtransform.AffineTransform3D;

public class TransformedInterpolatedRealRandomAccess<T>
extends AbstractLocalizableInt
implements RandomAccess<T> {
    final RealRandomAccessible<T> realRandomAccessible;
    final RealRandomAccess<T> realRandomAccess;
    final Interval transformedInterval;
    final AffineTransform3D transform;
    final int[] offset;
    final T zero;
    final double i00;
    final double i01;
    final double i02;
    final double i03;
    final double i10;
    final double i11;
    final double i12;
    final double i13;
    final double i20;
    final double i21;
    final double i22;
    final double i23;
    final float[] tmp;

    public TransformedInterpolatedRealRandomAccess(RealRandomAccessible<T> realRandomAccessible, T zero, Interval transformedInterval, AffineTransform3D transform, int[] offset) {
        super(realRandomAccessible.numDimensions());
        this.transformedInterval = transformedInterval;
        this.zero = zero;
        this.realRandomAccessible = realRandomAccessible;
        this.transform = transform;
        this.offset = new int[offset.length];
        for (int d = 0; d < this.n; ++d) {
            this.offset[d] = offset[d];
        }
        this.realRandomAccess = realRandomAccessible.realRandomAccess();
        double[] imatrix = transform.inverse().getRowPackedCopy();
        this.i00 = imatrix[0];
        this.i01 = imatrix[1];
        this.i02 = imatrix[2];
        this.i03 = imatrix[3];
        this.i10 = imatrix[4];
        this.i11 = imatrix[5];
        this.i12 = imatrix[6];
        this.i13 = imatrix[7];
        this.i20 = imatrix[8];
        this.i21 = imatrix[9];
        this.i22 = imatrix[10];
        this.i23 = imatrix[11];
        this.tmp = new float[this.n];
    }

    public T get() {
        TransformedInterpolatedRealRandomAccess.applyInverse(this.i00, this.i01, this.i02, this.i03, this.i10, this.i11, this.i12, this.i13, this.i20, this.i21, this.i22, this.i23, this.tmp, this.position, this.offset);
        this.realRandomAccess.setPosition(this.tmp);
        return (T)this.realRandomAccess.get();
    }

    private static final void applyInverse(double i00, double i01, double i02, double i03, double i10, double i11, double i12, double i13, double i20, double i21, double i22, double i23, float[] source, int[] target, int[] offset) {
        double t0 = target[0] + offset[0];
        double t1 = target[1] + offset[1];
        double t2 = target[2] + offset[2];
        double s0 = t0 * i00 + t1 * i01 + t2 * i02 + i03;
        double s1 = t0 * i10 + t1 * i11 + t2 * i12 + i13;
        double s2 = t0 * i20 + t1 * i21 + t2 * i22 + i23;
        source[0] = (float)s0;
        source[1] = (float)s1;
        source[2] = (float)s2;
    }

    public void fwd(int d) {
        int n = d;
        this.position[n] = this.position[n] + 1;
    }

    public void bck(int d) {
        int n = d;
        this.position[n] = this.position[n] - 1;
    }

    public void move(int distance, int d) {
        int n = d;
        this.position[n] = this.position[n] + distance;
    }

    public void move(long distance, int d) {
        int n = d;
        this.position[n] = this.position[n] + (int)distance;
    }

    public void move(Localizable localizable) {
        for (int d = 0; d < this.n; ++d) {
            int n = d;
            this.position[n] = this.position[n] + localizable.getIntPosition(d);
        }
    }

    public void move(int[] distance) {
        for (int d = 0; d < this.n; ++d) {
            int n = d;
            this.position[n] = this.position[n] + distance[d];
        }
    }

    public void move(long[] distance) {
        for (int d = 0; d < this.n; ++d) {
            int n = d;
            this.position[n] = this.position[n] + (int)distance[d];
        }
    }

    public void setPosition(Localizable localizable) {
        for (int d = 0; d < this.n; ++d) {
            this.position[d] = localizable.getIntPosition(d);
        }
    }

    public void setPosition(int[] position) {
        for (int d = 0; d < this.n; ++d) {
            this.position[d] = position[d];
        }
    }

    public void setPosition(long[] position) {
        for (int d = 0; d < this.n; ++d) {
            this.position[d] = (int)position[d];
        }
    }

    public void setPosition(int position, int d) {
        this.position[d] = position;
    }

    public void setPosition(long position, int d) {
        this.position[d] = (int)position;
    }

    public TransformedInterpolatedRealRandomAccess<T> copy() {
        return new TransformedInterpolatedRealRandomAccess<T>(this.realRandomAccessible, this.zero, this.transformedInterval, this.transform, this.offset);
    }

    public TransformedInterpolatedRealRandomAccess<T> copyRandomAccess() {
        return this.copy();
    }
}

