/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.i5d.gui;

import ij.gui.ImageCanvas;
import ij.gui.ImageLayout;
import java.awt.Canvas;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.awt.Rectangle;
import java.util.Vector;
import sc.fiji.i5d.gui.Image5DCanvas;

public class Image5DLayout
extends ImageLayout
implements LayoutManager2 {
    protected int hgap;
    protected int vgap;
    protected Image5DCanvas ic5d;
    protected Vector<Image5DCanvas> imageCanvasses = new Vector();
    protected Vector<Rectangle> imageRectangles = new Vector();
    protected int nCanvassesX = 0;
    protected int nCanvassesY = 0;
    protected Rectangle contentBounds = new Rectangle();
    protected double targetAspect = 1.3333333333333333;
    public static final String CANVAS = "main";
    public static final String SLICE_SELECTOR = "slice";
    public static final String FRAME_SELECTOR = "frame";
    public static final String CHANNEL_SELECTOR = "channel";
    protected Component slice;
    protected Component frame;
    protected Component channel;

    public Image5DLayout(Image5DCanvas ic5d) {
        super((ImageCanvas)ic5d);
        this.ic5d = ic5d;
        this.hgap = 4;
        this.vgap = 4;
    }

    @Override
    public Dimension preferredLayoutSize(Container target) {
        Dimension dim = new Dimension(0, 0);
        Insets insets = target.getInsets();
        dim.width = this.getHorizontalCoreSize(this.ic5d.getPreferredSize().width);
        dim.width += insets.left + insets.right + 2 * this.hgap;
        dim.height = this.getVerticalCoreSize(this.ic5d.getPreferredSize().height);
        dim.height += insets.top + insets.bottom + 2 * this.vgap;
        return dim;
    }

    public Dimension preferredLayoutSize(Container target, int canvasWidth, int canvasHeight) {
        Dimension dim = new Dimension(0, 0);
        Insets insets = target.getInsets();
        dim.width = this.getHorizontalCoreSize(canvasWidth);
        dim.width += insets.left + insets.right + 2 * this.hgap;
        dim.height = this.getVerticalCoreSize(canvasHeight);
        dim.height += insets.top + insets.bottom + 2 * this.vgap;
        return dim;
    }

    @Override
    public Dimension minimumLayoutSize(Container target) {
        return this.preferredLayoutSize(target);
    }

    @Override
    public void layoutContainer(Container target) {
        Dimension d = target.getSize();
        Insets insets = target.getInsets();
        Dimension prefCanvasSize = new Dimension(d);
        this.contentBounds.x = insets.left;
        this.contentBounds.y = insets.top;
        this.contentBounds.width = d.width - (this.contentBounds.x + this.getVerticalControlsWidth() + insets.right);
        if (this.slice != null) {
            this.contentBounds.width = Math.max(this.contentBounds.width, this.slice.getMinimumSize().width + 2 * this.hgap);
        }
        if (this.frame != null) {
            this.contentBounds.width = Math.max(this.contentBounds.width, this.frame.getMinimumSize().width + 2 * this.hgap);
        }
        prefCanvasSize.width = (int)Math.floor((double)(this.contentBounds.width - this.hgap) / (double)this.nCanvassesX) - this.hgap;
        this.contentBounds.height = d.height - (this.contentBounds.y + insets.bottom);
        if (this.channel != null) {
            this.contentBounds.height = Math.max(this.contentBounds.height, this.channel.getMinimumSize().height + 2 * this.vgap);
        }
        this.contentBounds.height -= this.getHorizontalControlsHeight();
        prefCanvasSize.height = (int)Math.floor((double)(this.contentBounds.height - this.vgap) / (double)this.nCanvassesY) - this.vgap;
        Dimension canvasDim = this.ic5d.resizeCanvasI5D(prefCanvasSize.width, prefCanvasSize.height);
        int offsX = insets.left;
        int offsY = insets.top;
        int mainOffsX = offsX + (d.width - offsX - this.getVerticalControlsWidth() - insets.right - canvasDim.width * this.nCanvassesX - this.hgap * (this.nCanvassesX - 1)) / 2;
        int mainOffsY = offsY + (d.height - offsY - this.getHorizontalControlsHeight() - insets.bottom - canvasDim.height * this.nCanvassesY - this.hgap * (this.nCanvassesY - 1)) / 2;
        for (int i = 0; i < this.nCanvassesX * this.nCanvassesY; ++i) {
            int j = 0;
            j = i == 0 ? this.nCanvassesX * this.nCanvassesY - 1 : i - 1;
            int nX = j % this.nCanvassesX;
            int nY = j / this.nCanvassesX;
            int tempOffsX = mainOffsX + nX * (canvasDim.width + this.hgap);
            int tempOffsY = mainOffsY + nY * (canvasDim.height + this.vgap);
            if (i >= this.imageCanvasses.size()) continue;
            ((Canvas)((Object)this.imageCanvasses.get(i))).setLocation(tempOffsX, tempOffsY);
            Rectangle imageRect = this.imageRectangles.get(i);
            imageRect.x = tempOffsX;
            imageRect.y = tempOffsY;
            imageRect.width = canvasDim.width;
            imageRect.height = canvasDim.height;
        }
        int y = d.height - insets.bottom - this.getHorizontalControlsHeight() - this.vgap;
        if (this.slice != null) {
            this.slice.setSize(this.contentBounds.width - 2 * this.hgap, this.slice.getPreferredSize().height);
            this.slice.setLocation(offsX + this.hgap, y += this.vgap);
            y += this.slice.getPreferredSize().height;
        }
        if (this.frame != null) {
            this.frame.setSize(this.contentBounds.width - 2 * this.hgap, this.frame.getPreferredSize().height);
            this.frame.setLocation(offsX + this.hgap, y += this.vgap);
            y += this.frame.getPreferredSize().height;
        }
        int x = d.width - insets.right - this.getVerticalControlsWidth() - this.vgap;
        if (this.channel != null) {
            this.channel.setSize(this.channel.getPreferredSize().width, d.height - insets.top - insets.bottom - 2 * this.vgap);
            this.channel.setLocation(x += this.hgap, offsY + this.vgap);
            x += this.channel.getPreferredSize().width;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addLayoutComponent(Component comp, Object constraints) {
        Object object = comp.getTreeLock();
        synchronized (object) {
            if (constraints == null || !(constraints instanceof String)) {
                throw new IllegalArgumentException("cannot add to layout: constraint must be a string");
            }
            this.addLayoutComponent((String)constraints, comp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void addLayoutComponent(String name, Component comp) {
        Object object = comp.getTreeLock();
        synchronized (object) {
            if (CANVAS.equals(name)) {
                if (!(comp instanceof Image5DCanvas)) throw new IllegalArgumentException("Can only use Image5DCanvasses as 'CANVAS' component.");
                this.imageCanvasses.add((Image5DCanvas)((Object)comp));
                this.imageRectangles.add(new Rectangle());
                this.getCanvasLayout();
            } else if (CHANNEL_SELECTOR.equals(name)) {
                this.channel = comp;
            } else if (SLICE_SELECTOR.equals(name)) {
                this.slice = comp;
            } else {
                if (!FRAME_SELECTOR.equals(name)) throw new IllegalArgumentException("cannot add to layout: unknown constraint: " + name);
                this.frame = comp;
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeLayoutComponent(Component comp) {
        Object object = comp.getTreeLock();
        synchronized (object) {
            if (this.imageCanvasses.contains(comp)) {
                int i = this.imageCanvasses.indexOf(comp);
                this.imageCanvasses.remove(i);
                this.imageRectangles.remove(i);
                this.getCanvasLayout();
            } else if (comp == this.channel) {
                this.channel = null;
            } else if (comp == this.slice) {
                this.slice = null;
            } else if (comp == this.frame) {
                this.frame = null;
            }
        }
    }

    @Override
    public Dimension maximumLayoutSize(Container target) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    @Override
    public float getLayoutAlignmentX(Container target) {
        return 0.5f;
    }

    @Override
    public float getLayoutAlignmentY(Container target) {
        return 0.5f;
    }

    @Override
    public void invalidateLayout(Container target) {
    }

    protected int getHorizontalCoreSize(int canvasWidth) {
        int width = 0;
        width = canvasWidth * this.nCanvassesX + this.hgap * (this.nCanvassesX - 1);
        if (this.slice != null) {
            width = Math.max(width, this.slice.getMinimumSize().width);
        }
        if (this.frame != null) {
            width = Math.max(width, this.frame.getMinimumSize().width);
        }
        return width += this.getVerticalControlsWidth();
    }

    protected int getVerticalCoreSize(int canvasHeight) {
        int height = 0;
        height = canvasHeight * this.nCanvassesY + this.vgap * (this.nCanvassesY - 1);
        height += this.getHorizontalControlsHeight();
        if (this.channel != null) {
            height = Math.max(height, this.channel.getMinimumSize().height);
        }
        return height;
    }

    protected int getHorizontalControlsHeight() {
        int height = 0;
        if (this.slice != null) {
            height += this.vgap + this.slice.getPreferredSize().height;
        }
        if (this.frame != null) {
            height += this.vgap + this.frame.getPreferredSize().height;
        }
        return height;
    }

    protected int getVerticalControlsWidth() {
        int width = 0;
        if (this.channel != null) {
            width += this.hgap + this.channel.getPreferredSize().width;
        }
        return width;
    }

    protected void getCanvasLayout() {
        double width = this.ic5d.getImage().getWidth();
        double height = this.ic5d.getImage().getHeight();
        int n = this.imageCanvasses.size();
        if (n <= 1) {
            this.nCanvassesX = 1;
            this.nCanvassesY = 1;
        } else {
            double tempCanvassesX = Math.sqrt((double)n * height * this.targetAspect / width);
            this.nCanvassesX = (int)Math.round(tempCanvassesX);
            this.nCanvassesY = (int)Math.ceil((double)n / (double)this.nCanvassesX);
        }
    }

    public Rectangle getCanvasBounds(int i) {
        if (i >= 0 && i < this.imageRectangles.size()) {
            return new Rectangle(this.imageRectangles.get(i));
        }
        return null;
    }

    public int getNCanvasses() {
        return this.imageCanvasses.size();
    }

    public Rectangle getContentBounds() {
        return this.contentBounds;
    }
}

