/*
 * Decompiled with CFR 0.152.
 */
package ini.trakem2.imaging.filters;

import ij.process.ColorProcessor;
import ij.process.ImageProcessor;
import ini.trakem2.imaging.filters.IFilter;
import ini.trakem2.utils.Utils;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.util.Map;

public class LUTCustom
implements IFilter {
    protected float r = 1.0f;
    protected float g = 1.0f;
    protected float b = 1.0f;

    public LUTCustom() {
    }

    public LUTCustom(float r, float g, float b) {
        this.r = r;
        this.g = g;
        this.b = b;
        this.fix();
    }

    private void fix() {
        if (this.r < 0.0f) {
            this.r = 0.0f;
        }
        if (this.r > 1.0f) {
            this.r = 1.0f;
        }
        if (this.g < 0.0f) {
            this.g = 0.0f;
        }
        if (this.g > 1.0f) {
            this.g = 1.0f;
        }
        if (this.b < 0.0f) {
            this.b = 0.0f;
        }
        if (this.b > 1.0f) {
            this.b = 1.0f;
        }
    }

    public LUTCustom(Map<String, String> params) {
        try {
            this.r = Float.parseFloat(params.get("r"));
            this.g = Float.parseFloat(params.get("g"));
            this.b = Float.parseFloat(params.get("b"));
            this.fix();
        }
        catch (NumberFormatException nfe) {
            throw new IllegalArgumentException("Could not create LUTCustom filter!", nfe);
        }
    }

    @Override
    public ImageProcessor process(ImageProcessor ip) {
        if (ip instanceof ColorProcessor) {
            Utils.log("Ignoring " + this.getClass().getSimpleName() + " filter for RGB image");
            return ip;
        }
        byte[] s1 = new byte[256];
        byte[] s2 = new byte[256];
        byte[] s3 = new byte[256];
        for (int i = 0; i < 256; ++i) {
            s1[i] = (byte)((float)i * this.r);
            s2[i] = (byte)((float)i * this.g);
            s3[i] = (byte)((float)i * this.b);
            Utils.log2(i + ": r, g, b " + s1[i] + ", " + s2[i] + ", " + s3[i]);
        }
        ip.setColorModel((ColorModel)new IndexColorModel(8, 256, s1, s2, s3));
        return ip;
    }

    @Override
    public String toXML(String indent) {
        return indent + "<t2_filter class=\"" + this.getClass().getName() + "\" r=\"" + this.r + "\" g=\"" + this.g + "\" b=\"" + this.b + "\" />\n";
    }

    public boolean equals(Object o) {
        if (null == o) {
            return false;
        }
        if (o instanceof LUTCustom) {
            LUTCustom l = (LUTCustom)o;
            return this.r == l.r && this.g == l.g && this.b == l.b;
        }
        return false;
    }
}

