/*
 * Decompiled with CFR 0.152.
 */
package ini.trakem2.io;

import ini.trakem2.utils.IJError;
import java.io.File;
import java.io.FilenameFilter;
import java.util.regex.Pattern;

public class ImageFileFilter
implements FilenameFilter {
    private String code = null;
    private Pattern pattern = null;

    public ImageFileFilter() {
    }

    public ImageFileFilter(String regex, String code) {
        this.code = code;
        if (null == regex || 0 == regex.length()) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        if (!regex.startsWith("^")) {
            sb.append("^.*");
        }
        for (int i = 0; i < regex.length(); ++i) {
            sb.append(regex.charAt(i));
        }
        if (!regex.endsWith("$")) {
            sb.append(".*$");
        }
        this.pattern = Pattern.compile(sb.toString());
    }

    @Override
    public boolean accept(File dir, String name) {
        boolean b = this.accept0(dir, name);
        if (b) {
            System.out.println("accepting " + name);
        }
        return b;
    }

    private boolean accept0(File dir, String name) {
        try {
            File file = new File(dir.getCanonicalPath().replace('\\', '/') + "/" + name);
            if (file.isDirectory() || file.isHidden() || name.equals(".") || name.equals("..")) {
                return false;
            }
        }
        catch (Exception e) {
            IJError.print(e);
        }
        return null != this.code ? this.startsWithCode(name) : null == this.pattern || this.pattern.matcher(name).matches();
    }

    boolean startsWithCode(String name) {
        block5: for (int i = 0; i < this.code.length(); ++i) {
            char c = name.charAt(i);
            switch (this.code.charAt(i)) {
                case 'c': {
                    if (Character.isLetter(c)) continue block5;
                    return false;
                }
                case 'd': {
                    if (Character.isDigit(c)) continue block5;
                    return false;
                }
                case 'x': {
                    continue block5;
                }
            }
        }
        return true;
    }
}

