/*
 * Decompiled with CFR 0.152.
 */
package org.lsmp.djep.djep.diffRules;

import org.lsmp.djep.djep.DJep;
import org.lsmp.djep.djep.DiffRulesI;
import org.lsmp.djep.xjep.NodeFactory;
import org.nfunk.jep.ASTFunNode;
import org.nfunk.jep.Node;
import org.nfunk.jep.Operator;
import org.nfunk.jep.OperatorSet;
import org.nfunk.jep.ParseException;

public class MultiplyDiffRule
implements DiffRulesI {
    private String name;
    Operator mulOp = null;

    private MultiplyDiffRule() {
    }

    public MultiplyDiffRule(String inName) {
        this.name = inName;
    }

    public MultiplyDiffRule(String inName, Operator op) {
        this.name = inName;
        this.mulOp = op;
    }

    @Override
    public String toString() {
        return this.name + "  \t\tdiff(f*g,x) -> diff(f,x)*g+f*diff(g,x)";
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Node differentiate(ASTFunNode node, String var, Node[] children, Node[] dchildren, DJep djep) throws ParseException {
        int nchild;
        OperatorSet opset = djep.getOperatorSet();
        NodeFactory nf = djep.getNodeFactory();
        Operator op = opset.getMultiply();
        if (this.mulOp != null) {
            op = this.mulOp;
        }
        if ((nchild = node.jjtGetNumChildren()) == 2) {
            return nf.buildOperatorNode(opset.getAdd(), nf.buildOperatorNode(op, dchildren[0], djep.deepCopy(children[1])), nf.buildOperatorNode(op, djep.deepCopy(children[0]), dchildren[1]));
        }
        Node[] sums = new Node[nchild];
        for (int i = 0; i < nchild; ++i) {
            Node[] terms = new Node[nchild];
            for (int j = 0; j < nchild; ++j) {
                terms[j] = children[j];
            }
            terms[i] = dchildren[i];
            sums[i] = nf.buildOperatorNode(op, terms);
        }
        ASTFunNode res = nf.buildOperatorNode(opset.getAdd(), sums);
        return res;
    }
}

