/*
 * Decompiled with CFR 0.152.
 */
package org.lsmp.djep.vectorJep.function;

import java.util.Stack;
import org.lsmp.djep.vectorJep.Dimensions;
import org.lsmp.djep.vectorJep.function.UnaryOperatorI;
import org.lsmp.djep.vectorJep.values.Matrix;
import org.lsmp.djep.vectorJep.values.MatrixValueI;
import org.lsmp.djep.vectorJep.values.Tensor;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.function.PostfixMathCommand;

public class Transpose
extends PostfixMathCommand
implements UnaryOperatorI {
    public Transpose() {
        this.numberOfParameters = 1;
    }

    @Override
    public Dimensions calcDim(Dimensions ldim) {
        return Dimensions.valueOf(ldim.getLastDim(), ldim.getFirstDim());
    }

    @Override
    public MatrixValueI calcValue(MatrixValueI res, MatrixValueI lhs) throws ParseException {
        if (!(res instanceof Matrix)) {
            throw new ParseException("transpose: result must be a matrix");
        }
        if (!(lhs instanceof Matrix)) {
            throw new ParseException("transpose: argument must be a matrix");
        }
        Matrix resmat = (Matrix)res;
        Matrix mat = (Matrix)lhs;
        if (resmat.getNumCols() != mat.getNumRows() || resmat.getNumRows() != mat.getNumCols()) {
            throw new ParseException("transpose, dimension of result is wrong res " + resmat.getDim() + " arg " + mat.getDim());
        }
        for (int i = 0; i < resmat.getNumRows(); ++i) {
            for (int j = 0; j < resmat.getNumCols(); ++j) {
                resmat.setEle(i, j, mat.getEle(j, i));
            }
        }
        return res;
    }

    @Override
    public void run(Stack s) throws ParseException {
        MatrixValueI obj = (MatrixValueI)s.pop();
        MatrixValueI res = Tensor.getInstance(this.calcDim(obj.getDim()));
        this.calcValue(res, obj);
        s.push(res);
    }
}

