/*
 * Decompiled with CFR 0.152.
 */
package org.siox.example;

import java.io.File;
import java.util.Arrays;
import java.util.HashSet;
import javax.swing.filechooser.FileFilter;

public class ExtensionFileFilter
extends FileFilter {
    private final HashSet extensionSet;
    private final String descString;

    public ExtensionFileFilter(String descString, String[] extensions) {
        this.descString = descString;
        this.extensionSet = new HashSet<String>(Arrays.asList(extensions));
    }

    private String getExtension(String fileName) {
        int idx = fileName.lastIndexOf(46);
        return idx >= 0 ? fileName.substring(idx + 1) : "";
    }

    private boolean isAcceptedFilename(String fileName) {
        return this.extensionSet.contains(this.getExtension(fileName).toLowerCase());
    }

    @Override
    public boolean accept(File file) {
        if (file.isDirectory()) {
            return true;
        }
        return file.isFile() && this.isAcceptedFilename(file.getName());
    }

    @Override
    public String getDescription() {
        return this.descString;
    }
}

