/*
 * Decompiled with CFR 0.152.
 */
package vib.app.module;

import ij.ImagePlus;
import vib.DiffusionInterpol2;
import vib.FloatMatrix;
import vib.InterpolatedImage;
import vib.app.ImageMetaData;
import vib.app.module.LabelCenterTransformation;
import vib.app.module.Module;
import vib.app.module.Resample;
import vib.app.module.State;

public class LabelDiffusionTransformation
extends Module {
    @Override
    public String getName() {
        return "LabelDiffusionTransformation";
    }

    @Override
    protected String getMessage() {
        return "Calculating label diffusion transformation";
    }

    @Override
    protected void run(State state, int index) {
        new Resample().runOnOneImage(state, index);
        new LabelCenterTransformation().runOnOneImage(state, index);
        this.prereqsDone(state, index);
        ImagePlus templateLabels = null;
        DiffusionInterpol2 interpol = new DiffusionInterpol2();
        boolean rememberDistortion = true;
        boolean reuseDistortion = false;
        float tolerance = 0.5f;
        FloatMatrix[] transformations = null;
        for (int i = -1; i < state.options.numChannels; ++i) {
            String imagePath = state.getResampledPath(i, index);
            String warpedPath = state.getWarpedPath(i, index);
            String statisticsPath = state.getStatisticsPath(index);
            if (State.upToDate(new String[]{imagePath, statisticsPath}, warpedPath)) continue;
            if (templateLabels == null) {
                templateLabels = state.getTemplateLabels();
            }
            InterpolatedImage ii = new InterpolatedImage(templateLabels);
            ImagePlus scratch = ii.cloneDimensionsOnly().getImage();
            if (transformations == null) {
                transformations = LabelDiffusionTransformation.readTransformations(state, index);
            }
            ImagePlus model = state.getImage(imagePath);
            FloatMatrix[] trans = LabelDiffusionTransformation.copyMatrices(transformations);
            interpol.initialize(scratch, templateLabels, model, trans, reuseDistortion, rememberDistortion, tolerance);
            interpol.doit();
            reuseDistortion = true;
            if (state.save(scratch, warpedPath)) continue;
            throw new RuntimeException("Could not save " + warpedPath);
        }
    }

    private static FloatMatrix[] readTransformations(State state, int index) {
        ImageMetaData templStats = state.getStatistics(-1);
        ImageMetaData stats = state.getStatistics(index);
        FloatMatrix[] result = new FloatMatrix[templStats.materials.length];
        for (int i = 0; i < result.length; ++i) {
            String name = templStats.materials[i].name;
            String transformName = state.getTransformLabel() + name;
            result[i] = stats.getMatrix(transformName);
        }
        return result;
    }

    private static FloatMatrix[] copyMatrices(FloatMatrix[] orig) {
        FloatMatrix[] res = new FloatMatrix[orig.length];
        System.arraycopy(orig, 0, res, 0, orig.length);
        return res;
    }
}

