/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.common.av;

import com.jogamp.common.os.Clock;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoField;
import java.util.concurrent.TimeUnit;

public final class PTS {
    private final FloatValue speed;
    private volatile long scr;
    private volatile int pts;
    private static final DateTimeFormatter Timestamp = DateTimeFormatter.ofPattern("[H:]m:s[.[SSSSSSSSS][SSSSSSSS][SSSSSSS][SSSSSS][SSSSS][SSSS][SSS][SS][S]]");

    public PTS(FloatValue floatValue) {
        this.speed = floatValue;
        this.scr = 0L;
        this.pts = Integer.MIN_VALUE;
    }

    public PTS(FloatValue floatValue, long l, int n) {
        this.speed = floatValue;
        this.set(l, n);
    }

    public PTS(PTS pTS) {
        this.speed = pTS.speed;
        this.set(pTS);
    }

    public boolean isValid() {
        return Integer.MIN_VALUE != this.pts;
    }

    public boolean isEOS() {
        return Integer.MAX_VALUE == this.pts;
    }

    public long getSCR() {
        return this.scr;
    }

    public String getSCRTimeStr(boolean bl) {
        return PTS.toTimeStr(this.getSCR(), bl);
    }

    public int getLast() {
        return this.pts;
    }

    public String getLastTimeStr(boolean bl) {
        return PTS.toTimeStr(this.getLast(), bl);
    }

    public float getSpeed() {
        return this.speed.get();
    }

    public void set(long l, int n) {
        this.scr = l;
        this.pts = n;
    }

    public void setPTS(int n) {
        this.pts = n;
    }

    public void setSCR(long l) {
        this.scr = l;
    }

    public void set(PTS pTS) {
        this.scr = pTS.getSCR();
        this.pts = pTS.getLast();
    }

    public int get(long l) {
        return this.pts + (int)((float)(l - this.scr) * this.speed.get() + 0.5f);
    }

    public int getCurrent() {
        return this.get(Clock.currentMillis());
    }

    public String getTimeStr(long l, boolean bl) {
        return PTS.toTimeStr(this.get(l), bl);
    }

    public int diffLast(PTS pTS) {
        return this.pts - pTS.getLast();
    }

    public int diff(long l, PTS pTS) {
        return this.get(l) - pTS.get(l);
    }

    public String toString() {
        return String.valueOf(this.pts);
    }

    public String toString(long l) {
        return "last " + this.pts + " ms, current " + this.get(l) + " ms";
    }

    public static String toTimeStr(long l, boolean bl) {
        long l2 = TimeUnit.MILLISECONDS.toHours(l);
        long l3 = TimeUnit.MILLISECONDS.toMinutes(l);
        if (bl) {
            if (0L < l2) {
                return String.format("%02d:%02d:%02d.%03d", l2, l3 - TimeUnit.HOURS.toMinutes(l2), TimeUnit.MILLISECONDS.toSeconds(l) - TimeUnit.MINUTES.toSeconds(l3), l % 1000L);
            }
            return String.format("%02d:%02d.%03d", l3, TimeUnit.MILLISECONDS.toSeconds(l) - TimeUnit.MINUTES.toSeconds(l3), l % 1000L);
        }
        if (0L < l2) {
            return String.format("%02d:%02d:%02d", l2, l3 - TimeUnit.HOURS.toMinutes(l2), TimeUnit.MILLISECONDS.toSeconds(l) - TimeUnit.MINUTES.toSeconds(l3));
        }
        return String.format("%02d:%02d", l3, TimeUnit.MILLISECONDS.toSeconds(l) - TimeUnit.MINUTES.toSeconds(l3));
    }

    public static String toTimeStr(long l) {
        long l2 = TimeUnit.MILLISECONDS.toHours(l);
        long l3 = TimeUnit.MILLISECONDS.toMinutes(l);
        return String.format("%02d:%02d:%02d.%03d", l2, l3 - TimeUnit.HOURS.toMinutes(l2), TimeUnit.MILLISECONDS.toSeconds(l) - TimeUnit.MINUTES.toSeconds(l3), l % 1000L);
    }

    public static int toMillis(String string, boolean bl) {
        try {
            return Timestamp.parse(string).get(ChronoField.MILLI_OF_DAY);
        }
        catch (DateTimeParseException dateTimeParseException) {
            if (bl) {
                throw dateTimeParseException;
            }
            return -1;
        }
    }

    public static int toMillis(String string) {
        return PTS.toMillis(string, false);
    }

    public static interface FloatValue {
        public float get();
    }
}

