/*
 * Decompiled with CFR 0.152.
 */
package bdv.util;

import bdv.viewer.Interpolation;
import java.util.function.Function;
import net.imglib2.RandomAccessible;
import net.imglib2.interpolation.InterpolatorFactory;
import net.imglib2.interpolation.randomaccess.ClampingNLinearInterpolatorFactory;
import net.imglib2.interpolation.randomaccess.NearestNeighborInterpolatorFactory;
import net.imglib2.type.numeric.NumericType;

public class DefaultInterpolators<T extends NumericType<T>>
implements Function<Interpolation, InterpolatorFactory<T, RandomAccessible<T>>> {
    private final InterpolatorFactory<T, RandomAccessible<T>>[] factories = new InterpolatorFactory[Interpolation.values().length];

    public DefaultInterpolators() {
        this.factories[Interpolation.NEARESTNEIGHBOR.ordinal()] = new NearestNeighborInterpolatorFactory();
        this.factories[Interpolation.NLINEAR.ordinal()] = new ClampingNLinearInterpolatorFactory();
    }

    public InterpolatorFactory<T, RandomAccessible<T>> get(Interpolation method) {
        return this.factories[method.ordinal()];
    }

    public int size() {
        return this.factories.length;
    }

    @Override
    public InterpolatorFactory<T, RandomAccessible<T>> apply(Interpolation t) {
        return this.get(t);
    }
}

