/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate;

import fiji.plugin.trackmate.Logger;
import fiji.plugin.trackmate.Model;
import fiji.plugin.trackmate.SelectionModel;
import fiji.plugin.trackmate.Settings;
import fiji.plugin.trackmate.TrackMate;
import fiji.plugin.trackmate.TrackMatePlugIn;
import fiji.plugin.trackmate.action.ExportTracksToXML;
import fiji.plugin.trackmate.features.FeatureFilter;
import fiji.plugin.trackmate.gui.GuiUtils;
import fiji.plugin.trackmate.gui.Icons;
import fiji.plugin.trackmate.gui.components.LogPanel;
import fiji.plugin.trackmate.gui.displaysettings.DisplaySettings;
import fiji.plugin.trackmate.gui.wizard.WizardSequence;
import fiji.plugin.trackmate.gui.wizard.descriptors.LogPanelDescriptor2;
import fiji.plugin.trackmate.io.TmXmlWriter;
import fiji.plugin.trackmate.util.LogRecorder;
import fiji.plugin.trackmate.util.TMUtils;
import fiji.plugin.trackmate.visualization.hyperstack.HyperStackDisplayer;
import fiji.util.SplitString;
import ij.ImageJ;
import ij.ImagePlus;
import ij.Macro;
import ij.WindowManager;
import java.awt.Component;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.swing.JFrame;
import net.imglib2.util.ValuePair;

public class TrackMateRunner
extends TrackMatePlugIn {
    private static final String ARG_RADIUS = "radius";
    private static final String ARG_THRESHOLD = "threshold";
    private static final String ARG_SUBPIXEL = "subpixel";
    private static final String ARG_MEDIAN = "median";
    private static final String ARG_CHANNEL = "channel";
    private static final String ARG_MAX_DISTANCE = "max_distance";
    private static final String ARG_MAX_GAP_DISTANCE = "max_gap_distance";
    private static final String ARG_MAX_GAP_FRAMES = "max_frame_gap";
    private static final String ARG_USE_GUI = "use_gui";
    private static final String ARG_INPUT_IMAGE_ID = "image_id";
    private static final String ARG_INPUT_IMAGE_NAME = "image_name";
    private static final String ARG_INPUT_IMAGE_PATH = "image_path";
    private static final String ARG_SAVE_TO = "save_to";
    private static final String ARG_EXPORT_TO = "export_to";
    private static final String ARG_DISPLAY_RESULTS = "display_results";
    private static final String ARG_FILTER_TRACKS_NSPOTS_ABOVE = "filter_tracks_nspots_above";
    private static final Collection<String> SUPPORTED_ARGS = new ArrayList<String>();
    private Logger logger = new LogRecorder(Logger.DEFAULT_LOGGER);

    @Override
    public void run(String arg) {
        String macroOption;
        lastLoadedFile = null;
        this.logger = new LogRecorder(Logger.IJ_LOGGER);
        if ((null == arg || arg.isEmpty()) && null != (macroOption = Macro.getOptions())) {
            arg = macroOption;
        }
        if (null != arg && !arg.isEmpty()) {
            try {
                Object val;
                MacroArgumentConverter converter;
                String key;
                ValuePair<String, MacroArgumentConverter> parser;
                String value;
                ImagePlus imp;
                Map macroOptions;
                block40: {
                    macroOptions = SplitString.splitMacroOptions((String)arg);
                    HashSet unknownParameters = new HashSet(macroOptions.keySet());
                    unknownParameters.removeAll(SUPPORTED_ARGS);
                    if (!unknownParameters.isEmpty()) {
                        this.logger.error("The following parameters are unkown and were ignored:\n");
                        for (String unknownParameter : unknownParameters) {
                            this.logger.error("  " + unknownParameter);
                        }
                    }
                    if (macroOptions.containsKey(ARG_INPUT_IMAGE_ID)) {
                        String val2 = (String)macroOptions.get(ARG_INPUT_IMAGE_ID);
                        try {
                            int id = Integer.parseInt(val2);
                            imp = WindowManager.getImage((int)id);
                            if (null == imp) {
                                this.logger.error("There is not an opened image with ID " + id + ".\n");
                                return;
                            }
                            break block40;
                        }
                        catch (NumberFormatException nfe) {
                            this.logger.error("Could not parse the image ID set by the image_id paramter. Got " + val2 + ", expected an integer.\n");
                            return;
                        }
                    }
                    if (macroOptions.containsKey(ARG_INPUT_IMAGE_NAME)) {
                        String imageName = (String)macroOptions.get(ARG_INPUT_IMAGE_NAME);
                        imp = WindowManager.getImage((String)imageName);
                        if (null == imp) {
                            this.logger.error("There is not an opened image with name " + imageName + ".\n");
                            return;
                        }
                    } else if (macroOptions.containsKey(ARG_INPUT_IMAGE_PATH)) {
                        String imagePath = (String)macroOptions.get(ARG_INPUT_IMAGE_PATH);
                        imp = new ImagePlus(imagePath);
                        if (null == imp.getOriginalFileInfo()) {
                            this.logger.error("Could not load image with path " + imagePath + ".\n");
                            return;
                        }
                    } else {
                        imp = WindowManager.getCurrentImage();
                        if (null == imp) {
                            this.logger.error("Please open an image before running TrackMate.");
                            return;
                        }
                    }
                }
                Settings settings = this.createSettings(imp);
                Model model = this.createModel(imp);
                SelectionModel selectionModel = new SelectionModel(model);
                model.setLogger(this.logger);
                TrackMate trackmate = this.createTrackMate(model, settings);
                DisplaySettings displaySettings = this.createDisplaySettings();
                Map<String, ValuePair<String, MacroArgumentConverter>> detectorParsers = this.prepareDetectorParsableArguments();
                Map<String, ValuePair<String, MacroArgumentConverter>> trackerParsers = this.prepareTrackerParsableArguments();
                Map<String, FilterGenerator> trackFiltersParsers = this.prepareTrackFiltersParsableArguments();
                for (String parameter : macroOptions.keySet()) {
                    value = (String)macroOptions.get(parameter);
                    parser = detectorParsers.get(parameter);
                    if (parser == null) continue;
                    key = (String)parser.getA();
                    converter = (MacroArgumentConverter)parser.getB();
                    try {
                        val = converter.convert(value);
                        settings.detectorSettings.put(key, val);
                    }
                    catch (NumberFormatException nfe) {
                        this.logger.error("Cannot interprete value for parameter " + parameter + ": " + value + ". Skipping.\n");
                    }
                }
                for (String parameter : macroOptions.keySet()) {
                    value = (String)macroOptions.get(parameter);
                    parser = trackerParsers.get(parameter);
                    if (parser == null) continue;
                    key = (String)parser.getA();
                    converter = (MacroArgumentConverter)parser.getB();
                    try {
                        val = converter.convert(value);
                        settings.trackerSettings.put(key, val);
                    }
                    catch (NumberFormatException nfe) {
                        this.logger.error("Cannot interprete value for parameter " + parameter + ": " + value + ". Skipping.\n");
                    }
                }
                for (String parameter : macroOptions.keySet()) {
                    value = (String)macroOptions.get(parameter);
                    FilterGenerator converter2 = trackFiltersParsers.get(parameter);
                    if (converter2 == null) continue;
                    try {
                        FeatureFilter featureFilter = converter2.get(value);
                        settings.addTrackFilter(featureFilter);
                    }
                    catch (NumberFormatException nfe) {
                        this.logger.error("Cannot interprete value for parameter " + parameter + ": " + value + ". Skipping.\n");
                    }
                }
                if (macroOptions.containsKey(ARG_USE_GUI) && ((String)macroOptions.get(ARG_USE_GUI)).equalsIgnoreCase("true")) {
                    if (!imp.isVisible()) {
                        imp.setOpenAsHyperStack(true);
                        imp.show();
                    }
                    GuiUtils.userCheckImpDimensions(imp);
                    HyperStackDisplayer displayer = new HyperStackDisplayer(model, selectionModel, imp, displaySettings);
                    displayer.render();
                    WizardSequence sequence = this.createSequence(trackmate, selectionModel, displaySettings);
                    JFrame frame = sequence.run("TrackMate on " + imp.getShortTitle());
                    frame.setIconImage(Icons.TRACKMATE_ICON.getImage());
                    GuiUtils.positionWindow(frame, (Component)imp.getWindow());
                    frame.setVisible(true);
                    return;
                }
                String welcomeMessage = "TrackMate v" + TrackMate.PLUGIN_NAME_VERSION + " started on:\n" + TMUtils.getCurrentTimeString() + '\n';
                this.logger.log(welcomeMessage);
                if (!trackmate.checkInput() || !trackmate.process()) {
                    this.logger.error("Error while performing tracking:\n" + trackmate.getErrorMessage());
                    return;
                }
                if (macroOptions.containsKey(ARG_SAVE_TO)) {
                    String save_path_str = (String)macroOptions.get(ARG_SAVE_TO);
                    File save_path = new File(save_path_str);
                    TmXmlWriter writer = new TmXmlWriter(save_path, this.logger);
                    writer.appendLog(this.logger.toString());
                    writer.appendModel(trackmate.getModel());
                    writer.appendSettings(trackmate.getSettings());
                    try {
                        writer.writeToFile();
                        this.logger.log("Data saved to: " + save_path.toString() + '\n');
                    }
                    catch (FileNotFoundException e) {
                        this.logger.error("When saving to " + save_path + ", file not found:\n" + e.getMessage() + '\n');
                        return;
                    }
                    catch (IOException e) {
                        this.logger.error("When saving to " + save_path + ", Input/Output error:\n" + e.getMessage() + '\n');
                        return;
                    }
                }
                if (macroOptions.containsKey(ARG_EXPORT_TO)) {
                    String export_path_str = (String)macroOptions.get(ARG_EXPORT_TO);
                    File export_path = new File(export_path_str);
                    try {
                        ExportTracksToXML.export(model, settings, export_path);
                        this.logger.log("Data exported to: " + export_path.toString() + '\n');
                    }
                    catch (FileNotFoundException e) {
                        this.logger.error("When exporting to " + export_path + ", file not found:\n" + e.getMessage() + '\n');
                        return;
                    }
                    catch (IOException e) {
                        this.logger.error("When exporting to " + export_path + ", Input/Output error:\n" + e.getMessage() + '\n');
                        return;
                    }
                }
                if (macroOptions.containsKey(ARG_DISPLAY_RESULTS) && ((String)macroOptions.get(ARG_DISPLAY_RESULTS)).equalsIgnoreCase("true")) {
                    if (!settings.imp.isVisible()) {
                        settings.imp.setOpenAsHyperStack(true);
                        settings.imp.show();
                    }
                    HyperStackDisplayer displayer = new HyperStackDisplayer(model, selectionModel, imp, displaySettings);
                    displayer.render();
                    WizardSequence sequence = this.createSequence(trackmate, selectionModel, displaySettings);
                    sequence.setCurrent("ConfigureViews");
                    JFrame frame = sequence.run("TrackMate on " + imp.getShortTitle());
                    frame.setIconImage(Icons.TRACKMATE_ICON.getImage());
                    GuiUtils.positionWindow(frame, (Component)imp.getWindow());
                    frame.setVisible(true);
                    LogPanelDescriptor2 logDescriptor = (LogPanelDescriptor2)sequence.logDescriptor();
                    LogPanel logPanel = (LogPanel)logDescriptor.getPanelComponent();
                    logPanel.setTextContent(this.logger.toString());
                }
            }
            catch (ParseException e) {
                this.logger.error("Could not parse plugin option string: " + e.getMessage() + ".\n");
                e.printStackTrace();
            }
        } else {
            super.run(arg);
        }
    }

    private Map<String, ValuePair<String, MacroArgumentConverter>> prepareDetectorParsableArguments() {
        HashMap<String, ValuePair<String, MacroArgumentConverter>> parsers = new HashMap<String, ValuePair<String, MacroArgumentConverter>>();
        DoubleMacroArgumentConverter doubleConverter = new DoubleMacroArgumentConverter();
        IntegerMacroArgumentConverter integerConverter = new IntegerMacroArgumentConverter();
        BooleanMacroArgumentConverter booleanConverter = new BooleanMacroArgumentConverter();
        ValuePair radiusPair = new ValuePair((Object)"RADIUS", (Object)doubleConverter);
        parsers.put(ARG_RADIUS, radiusPair);
        ValuePair thresholdPair = new ValuePair((Object)"THRESHOLD", (Object)doubleConverter);
        parsers.put(ARG_THRESHOLD, thresholdPair);
        ValuePair subpixelPair = new ValuePair((Object)"DO_SUBPIXEL_LOCALIZATION", (Object)booleanConverter);
        parsers.put(ARG_SUBPIXEL, subpixelPair);
        ValuePair medianPair = new ValuePair((Object)"DO_MEDIAN_FILTERING", (Object)booleanConverter);
        parsers.put(ARG_MEDIAN, medianPair);
        ValuePair channelPair = new ValuePair((Object)"TARGET_CHANNEL", (Object)integerConverter);
        parsers.put(ARG_CHANNEL, channelPair);
        return parsers;
    }

    private Map<String, ValuePair<String, MacroArgumentConverter>> prepareTrackerParsableArguments() {
        HashMap<String, ValuePair<String, MacroArgumentConverter>> parsers = new HashMap<String, ValuePair<String, MacroArgumentConverter>>();
        DoubleMacroArgumentConverter doubleConverter = new DoubleMacroArgumentConverter();
        IntegerMacroArgumentConverter integerConverter = new IntegerMacroArgumentConverter();
        ValuePair maxDistancePair = new ValuePair((Object)"LINKING_MAX_DISTANCE", (Object)doubleConverter);
        parsers.put(ARG_MAX_DISTANCE, maxDistancePair);
        ValuePair maxGapDistancePair = new ValuePair((Object)"GAP_CLOSING_MAX_DISTANCE", (Object)doubleConverter);
        parsers.put(ARG_MAX_GAP_DISTANCE, maxGapDistancePair);
        ValuePair maxGapFramesPair = new ValuePair((Object)"MAX_FRAME_GAP", (Object)integerConverter);
        parsers.put(ARG_MAX_GAP_FRAMES, maxGapFramesPair);
        return parsers;
    }

    private Map<String, FilterGenerator> prepareTrackFiltersParsableArguments() {
        HashMap<String, FilterGenerator> parsers = new HashMap<String, FilterGenerator>();
        FilterAboveGenerator nSpotsFilter = new FilterAboveGenerator("NUMBER_SPOTS");
        parsers.put(ARG_FILTER_TRACKS_NSPOTS_ABOVE, nSpotsFilter);
        return parsers;
    }

    public static void main(String[] args) {
        ImageJ.main((String[])args);
        new TrackMateRunner().run("use_gui=false save_to=[/Users/tinevez/Desktop/TrackMateSaveTest.xml] export_to=[/Users/tinevez/Desktop/TrackMateExportTest.xml] image_path=[samples/FakeTracks.tif] display_results=true radius=2.5 threshold=50.1 subpixel=false median=false channel=1 max_frame_gap=0 paf!=pif!");
    }

    static {
        SUPPORTED_ARGS.add(ARG_CHANNEL);
        SUPPORTED_ARGS.add(ARG_DISPLAY_RESULTS);
        SUPPORTED_ARGS.add(ARG_EXPORT_TO);
        SUPPORTED_ARGS.add(ARG_INPUT_IMAGE_ID);
        SUPPORTED_ARGS.add(ARG_INPUT_IMAGE_NAME);
        SUPPORTED_ARGS.add(ARG_INPUT_IMAGE_PATH);
        SUPPORTED_ARGS.add(ARG_MAX_DISTANCE);
        SUPPORTED_ARGS.add(ARG_MAX_GAP_DISTANCE);
        SUPPORTED_ARGS.add(ARG_MAX_GAP_FRAMES);
        SUPPORTED_ARGS.add(ARG_MEDIAN);
        SUPPORTED_ARGS.add(ARG_SAVE_TO);
        SUPPORTED_ARGS.add(ARG_SUBPIXEL);
        SUPPORTED_ARGS.add(ARG_THRESHOLD);
        SUPPORTED_ARGS.add(ARG_USE_GUI);
        SUPPORTED_ARGS.add(ARG_RADIUS);
        SUPPORTED_ARGS.add(ARG_FILTER_TRACKS_NSPOTS_ABOVE);
    }

    private static final class BooleanMacroArgumentConverter
    implements MacroArgumentConverter {
        private BooleanMacroArgumentConverter() {
        }

        @Override
        public Object convert(String valStr) throws NumberFormatException {
            return Boolean.valueOf(valStr);
        }
    }

    private static final class IntegerMacroArgumentConverter
    implements MacroArgumentConverter {
        private IntegerMacroArgumentConverter() {
        }

        @Override
        public Object convert(String valStr) throws NumberFormatException {
            return Integer.valueOf(valStr);
        }
    }

    private static final class DoubleMacroArgumentConverter
    implements MacroArgumentConverter {
        private DoubleMacroArgumentConverter() {
        }

        @Override
        public Object convert(String valStr) throws NumberFormatException {
            return Double.valueOf(valStr);
        }
    }

    private static interface MacroArgumentConverter {
        public Object convert(String var1) throws NumberFormatException;
    }

    private static class FilterAboveGenerator
    implements FilterGenerator {
        private final String feature;

        public FilterAboveGenerator(String feature) {
            this.feature = feature;
        }

        @Override
        public FeatureFilter get(String valStr) throws NumberFormatException {
            double value = Double.parseDouble(valStr);
            FeatureFilter ff = new FeatureFilter(this.feature, value, true);
            return ff;
        }
    }

    private static interface FilterGenerator {
        public FeatureFilter get(String var1) throws NumberFormatException;
    }
}

