/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.detection;

import fiji.plugin.trackmate.Spot;
import fiji.plugin.trackmate.detection.DetectionUtils;
import fiji.plugin.trackmate.detection.MaskUtils;
import fiji.plugin.trackmate.detection.SpotDetector;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import net.imglib2.Dimensions;
import net.imglib2.Interval;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.img.Img;
import net.imglib2.img.ImgFactory;
import net.imglib2.loops.LoopBuilder;
import net.imglib2.roi.labeling.ImgLabeling;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.IntegerType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.integer.IntType;
import net.imglib2.util.Util;
import net.imglib2.view.IntervalView;
import net.imglib2.view.Views;

public class LabelImageDetector<T extends RealType<T> & NativeType<T>>
implements SpotDetector<T> {
    private static final String BASE_ERROR_MESSAGE = "ThresholdDetector: ";
    protected RandomAccessible<T> input;
    protected String baseErrorMessage = "ThresholdDetector: ";
    protected String errorMessage;
    protected List<Spot> spots = new ArrayList<Spot>();
    protected long processingTime;
    protected int numThreads;
    protected final Interval interval;
    protected final double[] calibration;
    protected final boolean simplify;

    public LabelImageDetector(RandomAccessible<T> input, Interval interval, double[] calibration, boolean simplify) {
        this.input = input;
        this.interval = DetectionUtils.squeeze(interval);
        this.calibration = calibration;
        this.simplify = simplify;
    }

    public boolean checkInput() {
        return true;
    }

    public boolean process() {
        long start = System.currentTimeMillis();
        IntervalView rai = Views.interval(this.input, (Interval)this.interval);
        if (rai.getType() instanceof IntegerType) {
            this.processIntegerImg((RandomAccessibleInterval)Views.zeroMin((RandomAccessibleInterval)rai));
        } else {
            ImgFactory factory = Util.getArrayOrCellImgFactory((Dimensions)this.interval, (NativeType)new IntType());
            Img img = factory.create((Dimensions)this.interval);
            LoopBuilder.setImages((RandomAccessibleInterval)Views.zeroMin((RandomAccessibleInterval)rai), (RandomAccessibleInterval)img).multiThreaded(false).forEachPixel((i, o) -> o.setReal(i.getRealDouble()));
            this.processIntegerImg((RandomAccessibleInterval)img);
        }
        long end = System.currentTimeMillis();
        this.processingTime = end - start;
        return true;
    }

    private <R extends IntegerType<R>> void processIntegerImg(RandomAccessibleInterval<R> rai) {
        AtomicInteger max = new AtomicInteger(0);
        rai.forEach(p -> {
            int val = p.getInteger();
            if (val != 0 && val > max.get()) {
                max.set(val);
            }
        });
        ArrayList<Integer> indices = new ArrayList<Integer>(max.get());
        for (int i = 0; i < max.get(); ++i) {
            indices.add(i + 1);
        }
        ImgLabeling labeling = ImgLabeling.fromImageAndLabels(rai, indices);
        this.spots = this.input.numDimensions() == 2 ? MaskUtils.fromLabelingWithROI(labeling, this.interval, this.calibration, this.simplify, null) : MaskUtils.fromLabeling(labeling, this.interval, this.calibration);
    }

    public List<Spot> getResult() {
        return this.spots;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public long getProcessingTime() {
        return this.processingTime;
    }
}

