/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.features;

import fiji.plugin.trackmate.Dimension;
import fiji.plugin.trackmate.features.ModelDataset;
import fiji.plugin.trackmate.gui.Fonts;
import fiji.plugin.trackmate.util.ExportableChartPanel;
import fiji.plugin.trackmate.util.TMUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Paint;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.ui.RectangleInsets;
import org.jfree.data.xy.XYDataset;

public abstract class AbstractFeatureGrapher {
    protected final String xFeature;
    protected final List<String> yFeatures;
    private final Color bgColor = new Color(220, 220, 220);
    private final Dimension xDimension;
    private final Map<String, Dimension> yDimensions;
    private final Map<String, String> featureNames;
    private final String spaceUnits;
    private final String timeUnits;

    public AbstractFeatureGrapher(String xFeature, List<String> yFeatures, Dimension xDimension, Map<String, Dimension> yDimensions, Map<String, String> featureNames, String spaceUnits, String timeUnits) {
        this.xFeature = xFeature;
        this.yFeatures = yFeatures;
        this.xDimension = xDimension;
        this.yDimensions = yDimensions;
        this.featureNames = featureNames;
        this.spaceUnits = spaceUnits;
        this.timeUnits = timeUnits;
    }

    public JFrame render() {
        String xAxisLabel = this.featureNames.get(this.xFeature) + " (" + TMUtils.getUnitsFor(this.xDimension, this.spaceUnits, this.timeUnits) + ")";
        Set<Dimension> dimensions = this.getUniqueValues(this.yFeatures, this.yDimensions);
        ArrayList<ExportableChartPanel> chartPanels = new ArrayList<ExportableChartPanel>(dimensions.size());
        for (Dimension dimension : dimensions) {
            String yAxisLabel = TMUtils.getUnitsFor(dimension, this.spaceUnits, this.timeUnits);
            List<String> featuresThisDimension = AbstractFeatureGrapher.getCommonKeys(dimension, this.yFeatures, this.yDimensions);
            String title = this.buildPlotTitle(featuresThisDimension, this.featureNames);
            ModelDataset dataset = this.buildMainDataSet(featuresThisDimension);
            XYItemRenderer renderer = dataset.getRenderer();
            JFreeChart chart = ChartFactory.createXYLineChart((String)title, (String)xAxisLabel, (String)yAxisLabel, (XYDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
            chart.getTitle().setFont(Fonts.FONT);
            chart.getLegend().setItemFont(Fonts.SMALL_FONT);
            chart.setBackgroundPaint((Paint)this.bgColor);
            chart.setBorderVisible(false);
            chart.getLegend().setBackgroundPaint((Paint)this.bgColor);
            XYPlot plot = chart.getXYPlot();
            plot.setRenderer(renderer);
            plot.getRangeAxis().setLabelFont(Fonts.FONT);
            plot.getRangeAxis().setTickLabelFont(Fonts.SMALL_FONT);
            plot.getDomainAxis().setLabelFont(Fonts.FONT);
            plot.getDomainAxis().setTickLabelFont(Fonts.SMALL_FONT);
            plot.setOutlineVisible(false);
            plot.setDomainCrosshairVisible(false);
            plot.setDomainGridlinesVisible(false);
            plot.setRangeCrosshairVisible(false);
            plot.setRangeGridlinesVisible(false);
            plot.setBackgroundAlpha(0.0f);
            ((NumberAxis)plot.getRangeAxis()).setAutoRangeIncludesZero(false);
            plot.getRangeAxis().setTickLabelInsets(new RectangleInsets(20.0, 10.0, 20.0, 10.0));
            plot.getDomainAxis().setTickLabelInsets(new RectangleInsets(10.0, 20.0, 10.0, 20.0));
            ExportableChartPanel chartPanel = new ExportableChartPanel(chart);
            chartPanel.setPreferredSize(new java.awt.Dimension(500, 270));
            chartPanels.add(chartPanel);
        }
        return this.renderCharts(chartPanels);
    }

    protected abstract ModelDataset buildMainDataSet(List<String> var1);

    private final JFrame renderCharts(List<ExportableChartPanel> chartPanels) {
        JPanel panel = new JPanel();
        BoxLayout panelLayout = new BoxLayout(panel, 1);
        panel.setLayout(panelLayout);
        for (ExportableChartPanel chartPanel : chartPanels) {
            panel.add((Component)((Object)chartPanel));
            panel.add(Box.createVerticalStrut(5));
        }
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setHorizontalScrollBarPolicy(31);
        scrollPane.setViewportView(panel);
        scrollPane.getVerticalScrollBar().setUnitIncrement(16);
        JFrame frame = new JFrame();
        frame.getContentPane().add(scrollPane);
        frame.validate();
        frame.setSize(new java.awt.Dimension(520, 320));
        return frame;
    }

    private final <K, V> Set<V> getUniqueValues(Iterable<K> keys, Map<K, V> map) {
        LinkedHashSet<V> mapping = new LinkedHashSet<V>();
        for (K key : keys) {
            mapping.add(map.get(key));
        }
        return mapping;
    }

    private static final <K, V> List<K> getCommonKeys(V targetValue, Iterable<K> keys, Map<K, V> map) {
        ArrayList<K> foundKeys = new ArrayList<K>();
        for (K key : keys) {
            if (!map.get(key).equals(targetValue)) continue;
            foundKeys.add(key);
        }
        return foundKeys;
    }

    private final String buildPlotTitle(Iterable<String> lYFeatures, Map<String, String> featureNames) {
        StringBuilder sb = new StringBuilder("Plot of ");
        Iterator<String> it = lYFeatures.iterator();
        sb.append(featureNames.get(it.next()));
        while (it.hasNext()) {
            sb.append(", ");
            sb.append(featureNames.get(it.next()));
        }
        sb.append(" vs ");
        sb.append(featureNames.get(this.xFeature));
        sb.append(".");
        return sb.toString();
    }
}

