/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.gui.displaysettings;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.RoundRectangle2D;
import javax.swing.Icon;

public class ColorIcon
implements Icon {
    private static final int DEFAULT_PAD = 0;
    private static final int DEFAUL_SIZE = 16;
    private final int size;
    private Color color;
    private final int pad;

    public ColorIcon(Color color, int size, int pad) {
        this.color = color;
        this.size = size;
        this.pad = pad;
    }

    public ColorIcon(Color color, int size) {
        this(color, size, 0);
    }

    public ColorIcon(Color color) {
        this(color, 16);
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setColor(this.color);
        RoundRectangle2D.Float shape = new RoundRectangle2D.Float(x + this.pad, y + this.pad, this.size, this.size, 5.0f, 5.0f);
        g2d.fill(shape);
        g2d.setColor(Color.BLACK);
        g2d.draw(shape);
    }

    public void setColor(Color color) {
        this.color = color;
    }

    @Override
    public int getIconWidth() {
        return this.size + 2 * this.pad;
    }

    @Override
    public int getIconHeight() {
        return this.size + 2 * this.pad;
    }
}

