/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.visualization;

import fiji.plugin.trackmate.Model;
import fiji.plugin.trackmate.Spot;
import ij.ImagePlus;
import net.imglib2.FinalInterval;
import net.imglib2.Interval;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.img.array.ArrayImgs;
import net.imglib2.img.display.imagej.ImageJFunctions;
import net.imglib2.view.ExtendedRandomAccessibleInterval;
import net.imglib2.view.IntervalView;
import net.imglib2.view.Views;

public class ViewUtils {
    private static final double TARGET_X_IMAGE_SIZE = 512.0;
    private static final double TARGET_Z_IMAGE_SIZE = 128.0;

    private ViewUtils() {
    }

    public static final ImagePlus makeEmptyImagePlus(int width, int height, int nslices, int nframes, double[] calibration) {
        ExtendedRandomAccessibleInterval randomAccessible = Views.extendBorder((RandomAccessibleInterval)ArrayImgs.unsignedBytes((long[])new long[]{1L, 1L, 1L, 1L}));
        FinalInterval interval = new FinalInterval(new long[]{width, height, nslices, nframes});
        IntervalView view = Views.interval((RandomAccessible)randomAccessible, (Interval)interval);
        ImagePlus imp = ImageJFunctions.wrap((RandomAccessibleInterval)view, (String)"blank");
        imp.getCalibration().pixelWidth = calibration[0];
        imp.getCalibration().pixelHeight = calibration[1];
        imp.getCalibration().pixelDepth = calibration[2];
        imp.setDimensions(1, nslices, nframes);
        imp.setOpenAsHyperStack(true);
        return imp;
    }

    public static final ImagePlus makeEmpytImagePlus(Model model) {
        double maxX = 0.0;
        double maxY = 0.0;
        double maxZ = 0.0;
        int nframes = 0;
        for (Spot spot : model.getSpots().iterable(true)) {
            double r = spot.getFeature("RADIUS");
            double x = Math.ceil(r + spot.getFeature("POSITION_X"));
            double y = Math.ceil(r + spot.getFeature("POSITION_Y"));
            double z = Math.ceil(spot.getFeature("POSITION_Z"));
            int t = spot.getFeature("FRAME").intValue();
            if (x > maxX) {
                maxX = x;
            }
            if (y > maxY) {
                maxY = y;
            }
            if (z > maxZ) {
                maxZ = z;
            }
            if (t <= nframes) continue;
            nframes = t;
        }
        double calX = maxX / 512.0;
        double calY = maxY / 512.0;
        double calxy = Math.max(calX, calY);
        double calZ = maxZ / 128.0;
        int width = (int)Math.ceil(maxX / calxy);
        int height = (int)Math.ceil(maxY / calxy);
        int nslices = maxZ == 0.0 ? 1 : (int)Math.ceil(maxZ / calZ);
        double[] calibration = new double[]{calxy, calxy, calZ};
        ImagePlus imp = ViewUtils.makeEmptyImagePlus(width, height, nslices, nframes + 1, calibration);
        imp.getCalibration().setUnit(model.getSpaceUnits());
        imp.getCalibration().setTimeUnit(model.getTimeUnits());
        return imp;
    }
}

