/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.realtransform;

import net.imglib2.RealLocalizable;
import net.imglib2.RealPositionable;
import net.imglib2.realtransform.RealTransform;

public class RealComponentMappingTransform
implements RealTransform {
    protected int numSourceDimensions;
    protected int numTargetDimensions;
    protected int[] components;

    public RealComponentMappingTransform(int numSourceDimensions, int[] components) {
        this.components = components;
        this.numSourceDimensions = numSourceDimensions;
        this.numTargetDimensions = components.length;
    }

    public void apply(double[] source, double[] target) {
        assert (source.length >= this.numTargetDimensions);
        assert (target.length >= this.numTargetDimensions);
        for (int d = 0; d < this.numTargetDimensions; ++d) {
            target[d] = source[this.components[d]];
        }
    }

    public void apply(RealLocalizable source, RealPositionable target) {
        assert (source.numDimensions() >= this.numTargetDimensions);
        assert (target.numDimensions() >= this.numTargetDimensions);
        for (int d = 0; d < this.numTargetDimensions; ++d) {
            target.setPosition(source.getDoublePosition(this.components[d]), d);
        }
    }

    public RealComponentMappingTransform copy() {
        return new RealComponentMappingTransform(this.numSourceDimensions, this.components);
    }

    public int numSourceDimensions() {
        return this.numSourceDimensions;
    }

    public int numTargetDimensions() {
        return this.numTargetDimensions;
    }
}

