/*
 * Decompiled with CFR 0.152.
 */
package edu.utexas.archipelago.plugin;

import edu.utexas.archipelago.ArchipelagoUtils;
import edu.utexas.archipelago.segmentation.BatchWekaSegmentation;
import edu.utexas.clm.archipelago.Cluster;
import edu.utexas.clm.archipelago.FijiArchipelago;
import edu.utexas.clm.archipelago.ui.ClusterXML;
import edu.utexas.clm.archipelago.util.PrintStreamLogger;
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Macro;
import ij.VirtualStack;
import ij.gui.GenericDialog;
import ij.io.OpenDialog;
import ij.plugin.PlugIn;
import java.awt.Button;
import java.awt.GraphicsEnvironment;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.security.InvalidAlgorithmParameterException;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class Batch_Weka_Segmentation
implements PlugIn {
    private static final int DEFAULT_BLOCK_SIZE = 512;
    private static final int DEFAULT_OVLP = 32;

    private File getBWSParams(String arg, int[] blockSize, int[] overlap) {
        final GenericDialog gd = new GenericDialog("Block Segmentation Parameters");
        Panel buttonPanel = new Panel();
        Button selectFileButton = new Button("Select File...");
        gd.addStringField("Classifier File", !arg.isEmpty() && new File(arg).exists() ? arg : "", 64);
        buttonPanel.add(selectFileButton);
        gd.addPanel(buttonPanel);
        gd.addNumericField("Block Size (px)", 512.0, 0);
        gd.addNumericField("Overlap (px)", 32.0, 0);
        selectFileButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OpenDialog od = new OpenDialog("Select a classifier file", null);
                String dirName = od.getDirectory();
                String fileName = od.getFileName();
                if (fileName != null) {
                    ((TextField)gd.getStringFields().get(0)).setText(dirName + fileName);
                    gd.validate();
                }
            }
        });
        gd.showDialog();
        if (gd.wasOKed()) {
            String file = gd.getNextString();
            int bs = (int)gd.getNextNumber();
            int ovlp = (int)gd.getNextNumber();
            blockSize[0] = bs;
            blockSize[1] = bs;
            overlap[0] = ovlp;
            overlap[1] = ovlp;
            return new File(file).getAbsoluteFile();
        }
        return null;
    }

    public void runWithUI(String arg) {
        ImagePlus imp = IJ.getImage();
        ArrayList<File> fileList = new ArrayList<File>();
        try {
            if (imp != null && ArchipelagoUtils.getFileList(fileList, imp)) {
                Cluster cluster = Cluster.getClusterWithUI();
                int[] blockSize = new int[2];
                int[] overlap = new int[2];
                File classifierFile = this.getBWSParams(arg, blockSize, overlap);
                cluster.waitUntilReady();
                if (classifierFile != null) {
                    BatchWekaSegmentation bws = new BatchWekaSegmentation(classifierFile, blockSize, overlap, cluster);
                    int i = 0;
                    for (VirtualStack vs : bws.segmentImages(fileList)) {
                        new ImagePlus(imp.getTitle() + " probability map " + ++i, (ImageStack)vs).show();
                    }
                }
            }
        }
        catch (InvalidAlgorithmParameterException iape) {
            FijiArchipelago.err("" + iape);
        }
        catch (IOException ioe) {
            FijiArchipelago.err("" + ioe);
        }
    }

    public void runHeadless(String options) {
        PrintStream debugLogStream;
        ArrayList<String> args = new ArrayList<String>();
        ArrayList<File> fileList = new ArrayList<File>();
        StringTokenizer tokenizer = new StringTokenizer(options);
        while (tokenizer.hasMoreTokens()) {
            args.add(tokenizer.nextToken(" "));
        }
        if (args.size() < 3) {
            System.err.println("Batch Weka Segmentation needs at least three arguments:\n\tfiji --run \"Weka Segmentation 2D\" \"<image_list> <classifier_file> <cluster_file> [<block_size> [<overlap_size>]]\n\timage list - a text file with one image path per line\n\tclassifier file - a weka .model file\n\tcluster file - a cluster .arc file\n\tblock size - image block size, defaults to 512\n\toverlap size - image block overlap, defaults to 32");
            return;
        }
        String imageListPath = (String)args.get(0);
        String classifierPath = (String)args.get(1);
        String clusterPath = (String)args.get(2);
        int blockSize = args.size() >= 4 ? Integer.parseInt((String)args.get(3)) : 512;
        int ovlp = args.size() >= 5 ? Integer.parseInt((String)args.get(4)) : 32;
        FijiArchipelago.setDebugLogger(new PrintStreamLogger());
        try {
            String line;
            BufferedReader br = new BufferedReader(new FileReader(imageListPath));
            while ((line = br.readLine()) != null) {
                fileList.add(new File(line));
            }
        }
        catch (IOException ioe) {
            System.out.println("Error while reading " + imageListPath + ": " + ioe);
            return;
        }
        Cluster cluster = Cluster.getCluster();
        try {
            ClusterXML.loadClusterFile(new File(clusterPath), cluster, null);
        }
        catch (Exception e) {
            System.err.println("Could not load cluster file " + clusterPath + ": " + e);
            return;
        }
        try {
            debugLogStream = new PrintStream(new FileOutputStream("archipelago debug " + System.currentTimeMillis() + ".log"));
        }
        catch (IOException ioe) {
            System.err.println("Could not open log file for writing, debug stream to std out");
            debugLogStream = System.out;
        }
        FijiArchipelago.setDebugLogger(new PrintStreamLogger(debugLogStream));
        FijiArchipelago.setErrorLogger(new PrintStreamLogger(System.err));
        FijiArchipelago.setInfoLogger(new PrintStreamLogger(System.out));
        cluster.start();
        cluster.waitUntilReady();
        try {
            BatchWekaSegmentation bws = new BatchWekaSegmentation(new File(classifierPath), new int[]{blockSize, blockSize}, new int[]{ovlp, ovlp}, cluster);
            bws.segmentImages(fileList);
        }
        catch (InvalidAlgorithmParameterException iape) {
            System.err.println("" + iape);
        }
    }

    public void run(String arg) {
        String options = Macro.getOptions();
        System.out.println("Got options " + options);
        if (GraphicsEnvironment.getLocalGraphicsEnvironment().isHeadlessInstance()) {
            this.runHeadless(options);
        } else {
            this.runWithUI(arg);
        }
    }
}

