/*
 * Decompiled with CFR 0.152.
 */
package fiji.expressionparser.function;

import fiji.expressionparser.ImgLibUtils;
import fiji.expressionparser.function.TwoOperandsAbstractFunction;
import net.imglib2.RandomAccessible;
import net.imglib2.algorithm.gauss3.Gauss3;
import net.imglib2.exception.IncompatibleTypeException;
import net.imglib2.img.Img;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.real.FloatType;
import net.imglib2.view.Views;
import org.nfunk.jep.ParseException;

public final class ImgLibGaussConv<T extends RealType<T>>
extends TwoOperandsAbstractFunction<T> {
    public ImgLibGaussConv() {
        this.numberOfParameters = 2;
    }

    @Override
    public String toString() {
        return "Gaussian convolution";
    }

    @Override
    public String getDocumentationString() {
        return "<h3>Gaussian convolution</h3> This function implements the isotropic gaussian convolution, as coded in ImgLib, effectively implementing a gaussian filter. Syntax: <br><code>" + this.getFunctionString() + "(A, sigma)</code><br> with A an image and sigma a number. Sigma is the standard deviation of the gaussian kernel applied to image A.<br> Input image is converted to <i>FloatType</i> then convolved. If the source image is a 3D image, the convolution will be made in 3D as well. ";
    }

    @Override
    public String getFunctionString() {
        return "gauss";
    }

    @Override
    public final <R extends RealType<R>> Img<FloatType> evaluate(Img<R> img, R alpha) throws ParseException {
        Img<FloatType> fimg = ImgLibUtils.copyToFloatTypeImage(img);
        try {
            Gauss3.gauss((double)alpha.getRealDouble(), (RandomAccessible)Views.extendZero(fimg), fimg);
        }
        catch (IncompatibleTypeException e) {
            throw new RuntimeException(e);
        }
        return fimg;
    }

    @Override
    public final <R extends RealType<R>> float evaluate(R t1, R t2) throws ParseException {
        throw new ParseException("In function " + this.getFunctionString() + ": Arguments must be one image and one number, got 2 numbers.");
    }

    @Override
    public final <R extends RealType<R>> Img<FloatType> evaluate(Img<R> img1, Img<R> img2) throws ParseException {
        throw new ParseException("In function " + this.getFunctionString() + ": Arguments must be one image and one number, got 2 images.");
    }

    @Override
    public final <R extends RealType<R>> Img<FloatType> evaluate(R alpha, Img<R> img) throws ParseException {
        throw new ParseException("In function " + this.getFunctionString() + ": First argument must be one image and second one a number, in this order.");
    }
}

