/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.filter.fftSize;

import net.imagej.ops.Ops;
import net.imagej.ops.filter.fftSize.NextPowerOfTwo;
import net.imagej.ops.filter.fftSize.NextSmoothNumber;
import net.imagej.ops.special.function.AbstractUnaryFunctionOp;
import net.imglib2.Dimensions;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=Ops.Filter.FFTSize.class)
public class DefaultComputeFFTSize
extends AbstractUnaryFunctionOp<Dimensions, long[][]>
implements Ops.Filter.FFTSize {
    @Parameter
    private boolean powerOfTwo;

    @Override
    public long[][] calculate(Dimensions inputDimensions) {
        long[][] size = new long[][]{new long[inputDimensions.numDimensions()], new long[inputDimensions.numDimensions()]};
        for (int i = 0; i < inputDimensions.numDimensions(); ++i) {
            size[0][i] = this.powerOfTwo ? NextPowerOfTwo.nextPowerOfTwo(inputDimensions.dimension(i)) : (long)NextSmoothNumber.nextSmooth((int)inputDimensions.dimension(i));
            size[1][i] = i == 0 ? size[0][i] / 2L + 1L : size[0][i];
        }
        return size;
    }
}

