/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.geom.geom2d;

import java.util.ArrayList;
import java.util.Iterator;
import net.imagej.ops.Contingent;
import net.imagej.ops.Ops;
import net.imagej.ops.special.function.AbstractUnaryFunctionOp;
import net.imglib2.Cursor;
import net.imglib2.Localizable;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.RealPoint;
import net.imglib2.outofbounds.OutOfBounds;
import net.imglib2.roi.geom.real.DefaultWritablePolygon2D;
import net.imglib2.roi.geom.real.Polygon2D;
import net.imglib2.type.BooleanType;
import net.imglib2.type.Type;
import net.imglib2.util.Util;
import net.imglib2.view.Views;
import org.scijava.ItemIO;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=Ops.Geometric.Contour.class)
public class DefaultContour<B extends BooleanType<B>>
extends AbstractUnaryFunctionOp<RandomAccessibleInterval<B>, Polygon2D>
implements Contingent,
Ops.Geometric.Contour {
    @Parameter(type=ItemIO.INPUT, description="Set this flag to use  refined Jacobs stopping criteria")
    private boolean useJacobs = true;

    @Override
    public Polygon2D calculate(RandomAccessibleInterval<B> input) {
        ArrayList<RealPoint> p = new ArrayList<RealPoint>();
        BooleanType var = (BooleanType)((BooleanType)Util.getTypeFromInterval(input)).createVariable();
        OutOfBounds raInput = Views.extendValue(input, (Type)var).randomAccess();
        Cursor cInput = Views.flatIterable(input).cursor();
        ClockwiseMooreNeighborhoodIterator cNeigh = new ClockwiseMooreNeighborhoodIterator(raInput);
        double[] position = new double[2];
        double[] startPos = new double[2];
        block0: while (cInput.hasNext()) {
            if (!((BooleanType)cInput.next()).get()) continue;
            raInput.setPosition((Localizable)cInput);
            raInput.localize(startPos);
            p.add(new RealPoint(new double[]{startPos[0], startPos[1]}));
            raInput.move(-1, 0);
            cNeigh.reset();
            while (cNeigh.hasNext()) {
                if (!((BooleanType)cNeigh.next()).get()) continue;
                boolean specialBacktrack = false;
                raInput.localize(position);
                if (startPos[0] == position[0] && startPos[1] == position[1]) {
                    if (!this.useJacobs) break block0;
                    int index = cNeigh.getIndex();
                    if (index == 1 || index == 0) {
                        specialBacktrack = true;
                    } else if (index == 2 || index == 3) break block0;
                }
                p.add(new RealPoint(new double[]{position[0], position[1]}));
                if (specialBacktrack) {
                    cNeigh.backtrackSpecial();
                    continue;
                }
                cNeigh.backtrack();
            }
            break block0;
        }
        return new DefaultWritablePolygon2D(p);
    }

    @Override
    public boolean conforms() {
        return 2 == ((RandomAccessibleInterval)this.in()).numDimensions();
    }

    final class ClockwiseMooreNeighborhoodIterator<T extends Type<T>>
    implements Iterator<T> {
        private final RandomAccess<T> m_ra;
        private final int[][] CLOCKWISE_OFFSETS = new int[][]{{0, -1}, {1, 0}, {1, 0}, {0, 1}, {0, 1}, {-1, 0}, {-1, 0}, {0, -1}};
        private final int[][] CCLOCKWISE_OFFSETS = new int[][]{{0, 1}, {0, 1}, {-1, 0}, {-1, 0}, {0, -1}, {0, -1}, {1, 0}, {1, 0}};
        private int m_curOffset = 0;
        private int m_startIndex = 7;

        public ClockwiseMooreNeighborhoodIterator(RandomAccess<T> ra) {
            this.m_ra = ra;
        }

        @Override
        public final boolean hasNext() {
            return this.m_curOffset != this.m_startIndex;
        }

        @Override
        public final T next() {
            this.m_ra.move(this.CLOCKWISE_OFFSETS[this.m_curOffset]);
            this.m_curOffset = this.m_curOffset + 1 & 7;
            return (T)((Type)this.m_ra.get());
        }

        @Override
        public final void remove() {
            throw new UnsupportedOperationException();
        }

        public final void backtrack() {
            int[] back = this.CCLOCKWISE_OFFSETS[this.m_curOffset];
            this.m_ra.move(back);
            this.m_curOffset = back[0] == 0 ? (back[1] == 1 ? 6 : 2) : (back[0] == 1 ? 4 : 0);
            this.m_startIndex = this.m_curOffset + 7 & 7;
        }

        public final int getIndex() {
            return this.m_curOffset;
        }

        public final void reset() {
            this.m_curOffset = 0;
            this.m_startIndex = 7;
        }

        public void backtrackSpecial() {
            int[] back = this.CCLOCKWISE_OFFSETS[this.m_curOffset];
            this.m_ra.move(back);
            this.m_curOffset = back[0] == 0 ? (back[1] == 1 ? 6 : 2) : (back[0] == 1 ? 4 : 0);
            this.m_startIndex = this.m_curOffset + 5 & 7;
        }
    }
}

